/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.goal;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarOpenListBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarRegionNode;

public class RegionGoal
implements AStarGoalBase<AStarRegionNode> {
    private static final int BEND_PENALTY = 1;
    private static final int VIA_PENALTY = 1;
    private AStarOpenListBase<AStarRegionNode> openList;
    private AStarRegionNode goalNode;
    private int maxRevolutions = 0;

    private int distance(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        return Math.abs(startX - endX) + Math.abs(startY - endY) + Math.abs(startZ - endZ);
    }

    @Override
    public int distanceToGoal(int startX, int startY, int startZ) {
        int viaPenaltyEstimation = Math.abs(startZ - this.goalNode.getZ()) * 1;
        return this.distance(startX, startY, startZ, this.goalNode.getX(), this.goalNode.getY(), this.goalNode.getZ()) + viaPenaltyEstimation;
    }

    @Override
    public int getNodeCost(AStarRegionNode from, int toX, int toY, int toZ) {
        int bendPenalty = 0;
        int viaPenalty = 0;
        if (from.getZ() != toZ) {
            viaPenalty = 1;
        }
        if (from.getY() == toY) {
            if (from.origin != null && ((AStarRegionNode)from.origin).getY() != toY) {
                bendPenalty = 1;
            }
            return from.getVerticalCapacity() + bendPenalty + viaPenalty;
        }
        if (from.getX() == toX) {
            if (from.origin != null && ((AStarRegionNode)from.origin).getX() != toX) {
                bendPenalty = 1;
            }
            return from.getHorizontalCapacity() + bendPenalty + viaPenalty;
        }
        throw new IllegalArgumentException("Routing diagonally is not allowed globally, tried to route from (" + from.getX() + "," + from.getY() + "," + from.getZ() + ") to (" + toX + "," + toY + "," + toZ + ").");
    }

    @Override
    public boolean isPathFinished(AStarRegionNode currentNode) {
        return this.goalNode.equals(currentNode);
    }

    @Override
    public void setGoalNode(AStarRegionNode goal) {
        this.goalNode = goal;
    }

    @Override
    public void setMaximumRevolutions(int maximum) {
        this.maxRevolutions = maximum;
    }

    @Override
    public void setNodeStorage(AStarOpenListBase<AStarRegionNode> openList) {
        this.openList = openList;
    }

    @Override
    public boolean shouldGiveUp(int currentRevolutions) {
        if (this.maxRevolutions > 0 && currentRevolutions >= this.maxRevolutions) {
            return true;
        }
        return this.openList.isOpenListEmpty();
    }
}

