/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.extract.ExtractedPBucket;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;

public class TransistorPBucket
implements ExtractedPBucket {
    public String gateName;
    public String sourceName;
    public String drainName;
    private TransistorSize size;
    private double sourceArea;
    private double drainArea;
    private double sourcePerim;
    private double drainPerim;
    public NodeInst ni;
    private double mFactor;

    public TransistorPBucket(NodeInst ni, TransistorSize size, String gName, String sName, String dName, double factor) {
        this.ni = ni;
        this.size = size;
        this.gateName = gName;
        this.sourceName = sName;
        this.drainName = dName;
        this.mFactor = factor;
    }

    public char getType() {
        char type = this.ni.getFunction().isNTypeTransistor() ? (char)'n' : 'p';
        return type;
    }

    public double getTransistorLength(double legnthOffset) {
        return this.size.getDoubleLength() - legnthOffset;
    }

    public double getTransistorWidth() {
        return this.size.getDoubleWidth() * this.mFactor;
    }

    public double getActiveArea() {
        return DBMath.round(this.getTransistorWidth() * this.size.getDoubleActiveLength());
    }

    public double getActivePerim() {
        return DBMath.round((this.getTransistorWidth() + this.size.getDoubleActiveLength()) * 2.0);
    }

    public void addDifussionInformation(String net, double area, double perimeter) {
        if (net.equals(this.drainName)) {
            this.drainArea += area;
            this.drainPerim += perimeter;
        } else if (net.equals(this.sourceName)) {
            this.sourceArea += area;
            this.sourcePerim += perimeter;
        } else {
            System.out.println("Error in TransistorPBucket.addDifussionInformation");
        }
    }

    @Override
    public String getInfo(Technology tech) {
        double scale = tech.getScale();
        double legnthOffset = tech.getGateLengthSubtraction() / scale;
        double length = this.getTransistorLength(legnthOffset);
        double width = this.getTransistorWidth();
        char type = this.getType();
        StringBuffer line = new StringBuffer();
        line.append(type);
        line.append(" " + this.gateName + " " + this.sourceName + " " + this.drainName);
        line.append(" " + TextUtils.formatDouble(length));
        line.append(" " + TextUtils.formatDouble(width));
        line.append(" " + TextUtils.formatDouble(this.ni.getAnchorCenterX()));
        line.append(" " + TextUtils.formatDouble(this.ni.getAnchorCenterY()));
        if (type == 'n') {
            line.append(" g=S_gnd");
        } else {
            line.append(" g=S_vdd");
        }
        if (this.sourceArea == 0.0 || this.sourcePerim == 0.0 || this.drainArea == 0.0 || this.drainPerim == 0.0) {
            this.drainArea = this.sourceArea = this.getActiveArea();
            this.drainPerim = this.sourcePerim = this.getActivePerim();
        }
        if (this.sourceArea == 0.0 || this.sourcePerim == 0.0 || this.drainArea == 0.0 || this.drainPerim == 0.0) {
            ParasiticTool.getParasiticErrorLogger().logError("Zero active area/perimenter in parasitics extraction for '" + this.ni.getName() + "' in '" + this.ni.getParent().getName() + "'", this.ni.getParent(), this.ni.getParent().hashCode());
        }
        line.append(" s=A_" + (int)this.sourceArea + ",P_" + (int)this.sourcePerim);
        line.append(" d=A_" + (int)this.drainArea + ",P_" + (int)this.drainPerim);
        return line.toString();
    }
}

