/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CellBackup {
    private static final int BIN_SORT_THRESHOLD = 32;
    public static final CellBackup[] NULL_ARRAY = new CellBackup[0];
    public static final ImmutableArrayList<CellBackup> EMPTY_LIST = new ImmutableArrayList<CellBackup>(NULL_ARRAY);
    static int cellBackupsCreated = 0;
    static int cellBackupsMemoized = 0;
    public final CellRevision cellRevision;
    public final TechPool techPool;
    public final boolean modified;
    private volatile Memoization m;
    private AbstractShapeBuilder.Shrinkage shrinkage;
    private ERectangle primitiveBounds;
    private static final Comparator<ImmutableExport> BY_ORIGINAL_PORT = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            int result = e1.originalNodeId - e2.originalNodeId;
            if (result != 0) {
                return result;
            }
            result = e1.originalPortId.getChronIndex() - e2.originalPortId.getChronIndex();
            if (result != 0) {
                return result;
            }
            return e1.exportId.chronIndex - e2.exportId.chronIndex;
        }
    };

    private CellBackup(CellRevision cellRevision, TechPool techPool, boolean modified) {
        this.cellRevision = cellRevision;
        this.techPool = techPool;
        this.modified = modified;
        ++cellBackupsCreated;
        if (Job.getDebug()) {
            this.check();
        }
    }

    public static CellBackup newInstance(ImmutableCell d, TechPool techPool) {
        if (d.cellId.idManager != techPool.idManager) {
            throw new IllegalArgumentException();
        }
        if (techPool.getTech(d.techId) == null) {
            throw new IllegalArgumentException();
        }
        CellRevision cellRevision = new CellRevision(d);
        TechPool restrictedPool = techPool.restrict(cellRevision.techUsages, techPool);
        return new CellBackup(cellRevision, restrictedPool, true);
    }

    public CellBackup with(ImmutableCell d, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray, TechPool superPool) {
        CellRevision newRevision = this.cellRevision.with(d, nodesArray, arcsArray, exportsArray);
        TechPool restrictedPool = superPool.restrict(newRevision.techUsages, this.techPool);
        if (newRevision == this.cellRevision && restrictedPool == this.techPool) {
            return this;
        }
        if (arcsArray != null) {
            for (ImmutableArcInst a : arcsArray) {
                if (a == null || a.check(restrictedPool)) continue;
                throw new IllegalArgumentException("arc " + a.name + " is not compatible with TechPool");
            }
        }
        return new CellBackup(newRevision, restrictedPool, this.modified || newRevision != this.cellRevision);
    }

    public CellBackup withRevisionDate(long revisionDate) {
        CellRevision newRevision = this.cellRevision.withRevisionDate(revisionDate);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision, this.techPool, true);
    }

    public CellBackup withoutModified() {
        if (!this.modified) {
            return this;
        }
        return new CellBackup(this.cellRevision, this.techPool, false);
    }

    public CellBackup withTechPool(TechPool techPool) {
        TechPool restrictedPool = techPool.restrict(this.cellRevision.techUsages, this.techPool);
        if (this.techPool == restrictedPool) {
            return this;
        }
        if (techPool.idManager != this.techPool.idManager) {
            throw new IllegalArgumentException();
        }
        return new CellBackup(this.cellRevision, restrictedPool, this.modified);
    }

    CellBackup withRenamedIds(IdMapper idMapper, CellName newGroupName) {
        CellRevision newRevision = this.cellRevision.withRenamedIds(idMapper, newGroupName);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision, this.techPool, true);
    }

    void write(IdWriter writer) throws IOException {
        this.cellRevision.write(writer);
        writer.writeBoolean(this.modified);
    }

    static CellBackup read(IdReader reader, TechPool techPool) throws IOException {
        CellRevision newRevision = CellRevision.read(reader);
        boolean modified = reader.readBoolean();
        TechPool restrictedPool = techPool.restrict(newRevision.techUsages, techPool);
        return new CellBackup(newRevision, restrictedPool, modified);
    }

    public void check() {
        this.cellRevision.check();
        IdManager idManager = this.cellRevision.d.cellId.idManager;
        assert (this.techPool.idManager == idManager);
        BitSet techUsages = new BitSet();
        for (Technology tech : this.techPool.values()) {
            int techIndex = tech.getId().techIndex;
            assert (!techUsages.get(techIndex));
            techUsages.set(techIndex);
        }
        assert (techUsages.equals(this.cellRevision.techUsages));
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            if (a == null) continue;
            a.check(this.techPool);
        }
        if (this.m != null) {
            this.m.check();
        }
    }

    public String toString() {
        return this.cellRevision.toString();
    }

    public Memoization getMemoization() {
        Memoization m = this.m;
        if (m != null) {
            return m;
        }
        this.m = new Memoization();
        return this.m;
    }

    public Memoization computeMemoization() {
        return new Memoization();
    }

    public AbstractShapeBuilder.Shrinkage getShrinkage() {
        if (this.shrinkage == null) {
            this.shrinkage = new AbstractShapeBuilder.Shrinkage(this);
        }
        return this.shrinkage;
    }

    public ERectangle getPrimitiveBounds() {
        ERectangle primitiveBounds = this.primitiveBounds;
        if (primitiveBounds != null) {
            return primitiveBounds;
        }
        this.primitiveBounds = this.computePrimitiveBounds();
        return this.primitiveBounds;
    }

    public ERectangle computePrimitiveBounds() {
        double cellLowX = 0.0;
        double cellHighX = 0.0;
        double cellLowY = 0.0;
        double cellHighY = 0.0;
        boolean boundsEmpty = true;
        BoundsBuilder b = new BoundsBuilder(this);
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            if (!(n.protoId instanceof PrimitiveNodeId)) continue;
            PrimitiveNode np = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
            n.computeBounds(b, bounds);
            if (np == Generic.tech().cellCenterNode) continue;
            if (np == Generic.tech().invisiblePinNode) {
                boolean found = false;
                Iterator<Variable> it = n.getVariables();
                while (it.hasNext()) {
                    TextDescriptor td;
                    Variable var = it.next();
                    if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            double lowx = bounds.getMinX();
            double highx = bounds.getMaxX();
            double lowy = bounds.getMinY();
            double highy = bounds.getMaxY();
            if (boundsEmpty) {
                boundsEmpty = false;
                cellLowX = lowx;
                cellHighX = highx;
                cellLowY = lowy;
                cellHighY = highy;
                continue;
            }
            if (lowx < cellLowX) {
                cellLowX = lowx;
            }
            if (highx > cellHighX) {
                cellHighX = highx;
            }
            if (lowy < cellLowY) {
                cellLowY = lowy;
            }
            if (!(highy > cellHighY)) continue;
            cellHighY = highy;
        }
        long gridMinX = DBMath.lambdaToGrid(cellLowX);
        long gridMinY = DBMath.lambdaToGrid(cellLowY);
        long gridMaxX = DBMath.lambdaToGrid(cellHighX);
        long gridMaxY = DBMath.lambdaToGrid(cellHighY);
        ERectangle primitiveArcBounds = this.computePrimitiveBoundsOfArcs();
        if (boundsEmpty) {
            return primitiveArcBounds;
        }
        if (primitiveArcBounds != null) {
            assert (!boundsEmpty);
            gridMinX = Math.min(gridMinX, primitiveArcBounds.getGridMinX());
            gridMaxX = Math.max(gridMaxX, primitiveArcBounds.getGridMaxX());
            gridMinY = Math.min(gridMinY, primitiveArcBounds.getGridMinY());
            gridMaxY = Math.max(gridMaxY, primitiveArcBounds.getGridMaxY());
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    public int[] getArcIndexByArcIdMap() {
        return (int[])this.getMemoization().arcIndexByArcId.clone();
    }

    private ERectangle computePrimitiveBoundsOfArcs() {
        ImmutableArrayList<ImmutableArcInst> arcs = this.cellRevision.arcs;
        if (arcs.isEmpty()) {
            return null;
        }
        int intMinX = Integer.MAX_VALUE;
        int intMinY = Integer.MAX_VALUE;
        int intMaxX = Integer.MIN_VALUE;
        int intMaxY = Integer.MIN_VALUE;
        int[] intCoords = new int[4];
        BoundsBuilder boundsBuilder = new BoundsBuilder(this);
        for (ImmutableArcInst a : arcs) {
            if (boundsBuilder.genBoundsEasy(a, intCoords)) {
                int y2;
                int x2;
                int y1;
                int x1 = intCoords[0];
                if (x1 < intMinX) {
                    intMinX = x1;
                }
                if ((y1 = intCoords[1]) < intMinY) {
                    intMinY = y1;
                }
                if ((x2 = intCoords[2]) > intMaxX) {
                    intMaxX = x2;
                }
                if ((y2 = intCoords[3]) <= intMaxY) continue;
                intMaxY = y2;
                continue;
            }
            boundsBuilder.genShapeOfArc(a);
        }
        ERectangle bounds = boundsBuilder.makeBounds();
        if (bounds == null) {
            assert (intMinX <= intMaxX && intMinY <= intMaxY);
            int iw = intMaxX - intMinX;
            int ih = intMaxY - intMinY;
            return ERectangle.fromGrid(intMinX, intMinY, iw >= 0 ? (long)iw : (long)intMaxX - (long)intMinX, ih >= 0 ? (long)ih : (long)intMaxY - (long)intMinY);
        }
        if (intMinX > intMaxX) {
            return bounds;
        }
        long longMinX = Math.min(bounds.getGridMinX(), (long)intMinX);
        long longMinY = Math.min(bounds.getGridMinY(), (long)intMinY);
        long longMaxX = Math.max(bounds.getGridMaxX(), (long)intMaxX);
        long longMaxY = Math.max(bounds.getGridMaxY(), (long)intMaxY);
        return ERectangle.fromGrid(longMinX, longMinY, longMaxX - longMinX, longMaxY - longMinY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Memoization {
        private final int[] nodeIndexByNodeId;
        private final int[] arcIndexByArcId;
        private final int[] connections;
        private final ImmutableExport[] exportIndexByOriginalPort;
        private final BitSet wiped = new BitSet();
        private final BitSet hardArcs = new BitSet();

        Memoization() {
            ++cellBackupsMemoized;
            this.nodeIndexByNodeId = this.makeNodeIndexByNodeId();
            this.arcIndexByArcId = this.makeArcIndexByArcId();
            this.connections = this.makeConnections1();
            this.exportIndexByOriginalPort = this.makeExportIndexByOriginalPort1();
            for (ImmutableArcInst a : CellBackup.this.cellRevision.arcs) {
                ArcProto ap = CellBackup.this.techPool.getArcProto(a.protoId);
                if (ap.isWipable()) {
                    this.wiped.set(a.tailNodeId);
                    this.wiped.set(a.headNodeId);
                }
                if (ap.getTechnology().isEasyShape(a, false)) continue;
                this.hardArcs.set(a.arcId);
            }
            ImmutableArrayList<ImmutableNodeInst> nodes = CellBackup.this.cellRevision.nodes;
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
                NodeProtoId np = n.protoId;
                if (np instanceof PrimitiveNodeId && CellBackup.this.techPool.getPrimitiveNode((PrimitiveNodeId)np).isArcsWipe()) continue;
                this.wiped.clear(n.nodeId);
            }
            this.check();
        }

        private int[] makeNodeIndexByNodeId() {
            ImmutableArrayList<ImmutableNodeInst> nodes = CellBackup.this.cellRevision.nodes;
            int maxNodeId = -1;
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                maxNodeId = Math.max(maxNodeId, ((ImmutableNodeInst)nodes.get((int)nodeIndex)).nodeId);
            }
            int[] nodesById = new int[maxNodeId + 1];
            Arrays.fill(nodesById, -1);
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
                nodesById[n.nodeId] = nodeIndex++;
            }
            return nodesById;
        }

        private int[] makeArcIndexByArcId() {
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            int maxArcId = -1;
            for (int arcIndex = 0; arcIndex < arcs.size(); ++arcIndex) {
                maxArcId = Math.max(maxArcId, ((ImmutableArcInst)arcs.get((int)arcIndex)).arcId);
            }
            int[] arcsById = new int[maxArcId + 1];
            Arrays.fill(arcsById, -1);
            int arcIndex = 0;
            while (arcIndex < arcs.size()) {
                ImmutableArcInst a = (ImmutableArcInst)arcs.get(arcIndex);
                arcsById[a.arcId] = arcIndex++;
            }
            return arcsById;
        }

        private int[] makeConnections1() {
            int nodeId;
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            int[] connections = new int[arcs.size() * 2];
            int[] connectionsByNodeId = new int[this.nodeIndexByNodeId.length];
            for (ImmutableArcInst a : arcs) {
                int n = a.headNodeId;
                connectionsByNodeId[n] = connectionsByNodeId[n] + 1;
                int n2 = a.tailNodeId;
                connectionsByNodeId[n2] = connectionsByNodeId[n2] + 1;
            }
            int sum = 0;
            for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
                int start = sum;
                sum += connectionsByNodeId[nodeId];
                connectionsByNodeId[nodeId] = start;
            }
            for (int i = 0; i < arcs.size(); ++i) {
                ImmutableArcInst a = (ImmutableArcInst)arcs.get(i);
                int n = a.tailNodeId;
                int n3 = connectionsByNodeId[n];
                connectionsByNodeId[n] = n3 + 1;
                connections[n3] = i * 2;
                int n4 = a.headNodeId;
                int n5 = connectionsByNodeId[n4];
                connectionsByNodeId[n4] = n5 + 1;
                connections[n5] = i * 2 + 1;
            }
            sum = 0;
            for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
                sum = connectionsByNodeId[nodeId];
                int start = sum;
                if (sum - 1 <= start) continue;
                this.sortConnections(connections, start, sum - 1);
            }
            return connections;
        }

        private ImmutableExport[] makeExportIndexByOriginalPort1() {
            ImmutableExport[] exportIndexByOriginalPort = CellBackup.this.cellRevision.exports.toArray(new ImmutableExport[CellBackup.this.cellRevision.exports.size()]);
            Arrays.sort(exportIndexByOriginalPort, BY_ORIGINAL_PORT);
            return exportIndexByOriginalPort;
        }

        public int getArcIndex(ImmutableArcInst a) {
            return this.arcIndexByArcId[a.arcId];
        }

        public boolean hasExports(ImmutableNodeInst originalNode) {
            int startIndex = this.searchExportByOriginalPort(originalNode.nodeId, 0);
            if (startIndex >= this.exportIndexByOriginalPort.length) {
                return false;
            }
            ImmutableExport e = this.exportIndexByOriginalPort[startIndex];
            return e.originalNodeId == originalNode.nodeId;
        }

        public int getNumExports(int originalNodeId) {
            int startIndex;
            int j;
            for (j = startIndex = this.searchExportByOriginalPort(originalNodeId, 0); j < this.exportIndexByOriginalPort.length; ++j) {
                ImmutableExport e = this.exportIndexByOriginalPort[j];
                if (e.originalNodeId != originalNodeId) break;
            }
            return j - startIndex;
        }

        public Iterator<ImmutableExport> getExports(int originalNodeId) {
            int startIndex;
            int j;
            for (j = startIndex = this.searchExportByOriginalPort(originalNodeId, 0); j < this.exportIndexByOriginalPort.length; ++j) {
                ImmutableExport e = this.exportIndexByOriginalPort[j];
                if (e.originalNodeId != originalNodeId) break;
            }
            return ArrayIterator.iterator(this.exportIndexByOriginalPort, startIndex, j);
        }

        public boolean pinUseCount(ImmutableNodeInst pin) {
            int numConnections = this.getNumConnections(pin);
            if (numConnections > 2) {
                return false;
            }
            if (this.hasExports(pin)) {
                return true;
            }
            return numConnections != 0;
        }

        public List<ImmutableArcInst> getConnections(BitSet headEnds, ImmutableNodeInst n, PortProtoId portId) {
            int i;
            List<ImmutableArcInst> result = null;
            if (headEnds != null) {
                headEnds.clear();
            }
            int myNodeId = n.nodeId;
            int chronIndex = 0;
            if (portId != null) {
                assert (portId.parentId == n.protoId);
                chronIndex = portId.chronIndex;
            }
            for (int j = i = this.searchConnectionByPort(myNodeId, chronIndex); j < this.connections.length; ++j) {
                int nodeId;
                int con = this.connections[j];
                ImmutableArcInst a = (ImmutableArcInst)this.getArcs().get(con >>> 1);
                boolean end = (con & 1) != 0;
                int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
                if (nodeId != myNodeId) break;
                if (portId != null) {
                    PortProtoId endProtoId;
                    PortProtoId portProtoId = endProtoId = end ? a.headPortId : a.tailPortId;
                    if (endProtoId.getChronIndex() != chronIndex) break;
                }
                if (result == null) {
                    result = new ArrayList<ImmutableArcInst>();
                }
                if (headEnds != null && end) {
                    headEnds.set(((ArrayList)result).size());
                }
                ((ArrayList)result).add(a);
            }
            return result != null ? result : Collections.emptyList();
        }

        public boolean hasConnections(ImmutableNodeInst n, PortProtoId portId) {
            int nodeId;
            int i;
            int chronIndex = 0;
            if (portId != null) {
                assert (portId.parentId == n.protoId);
                chronIndex = portId.chronIndex;
            }
            if ((i = this.searchConnectionByPort(n.nodeId, chronIndex)) >= this.connections.length) {
                return false;
            }
            int con = this.connections[i];
            ImmutableArcInst a = (ImmutableArcInst)this.getArcs().get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
            if (nodeId != n.nodeId) {
                return false;
            }
            return portId == null || portId == (end ? a.headPortId : a.tailPortId);
        }

        public int getNumConnections(ImmutableNodeInst n) {
            int i;
            int j;
            int myNodeId = n.nodeId;
            for (j = i = this.searchConnectionByPort(myNodeId, 0); j < this.connections.length; ++j) {
                int nodeId;
                int con = this.connections[j];
                ImmutableArcInst a = (ImmutableArcInst)this.getArcs().get(con >>> 1);
                boolean end = (con & 1) != 0;
                int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
                if (nodeId != myNodeId) break;
            }
            return j - i;
        }

        private int searchExportByOriginalPort(int originalNodeId, int originalChronIndex) {
            int low = 0;
            int high = this.exportIndexByOriginalPort.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                ImmutableExport e = this.exportIndexByOriginalPort[mid];
                int cmp = e.originalNodeId - originalNodeId;
                if (cmp == 0) {
                    int n = cmp = e.originalPortId.getChronIndex() >= originalChronIndex ? 1 : -1;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        private int searchConnectionByPort(int nodeId, int chronIndex) {
            int low = 0;
            int high = this.connections.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int con = this.connections[mid];
                ImmutableArcInst a = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con >>> 1);
                boolean end = (con & 1) != 0;
                int endNodeId = end ? a.headNodeId : a.tailNodeId;
                int cmp = endNodeId - nodeId;
                if (cmp == 0) {
                    PortProtoId portId = end ? a.headPortId : a.tailPortId;
                    cmp = portId.getChronIndex() - chronIndex;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        public CellBackup getCellBackup() {
            return CellBackup.this;
        }

        public TechPool getTechPool() {
            return CellBackup.this.techPool;
        }

        public ImmutableNodeInst getNodeById(int nodeId) {
            if (nodeId >= this.nodeIndexByNodeId.length) {
                return null;
            }
            int nodeIndex = this.nodeIndexByNodeId[nodeId];
            return nodeIndex >= 0 ? (ImmutableNodeInst)CellBackup.this.cellRevision.nodes.get(nodeIndex) : null;
        }

        public int getNodeIndexByNodeId(int nodeId) {
            return this.nodeIndexByNodeId[nodeId];
        }

        public ImmutableArcInst getArcById(int arcId) {
            if (arcId >= this.arcIndexByArcId.length) {
                return null;
            }
            int arcIndex = this.arcIndexByArcId[arcId];
            return arcIndex >= 0 ? (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(arcIndex) : null;
        }

        public ImmutableArrayList<ImmutableArcInst> getArcs() {
            return CellBackup.this.cellRevision.arcs;
        }

        public boolean isWiped(ImmutableNodeInst n) {
            return this.wiped.get(n.nodeId);
        }

        public boolean isHardArc(int arcId) {
            return this.hardArcs.get(arcId);
        }

        private void check() {
            for (int nodeIndex = 0; nodeIndex < CellBackup.this.cellRevision.nodes.size(); ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)CellBackup.this.cellRevision.nodes.get(nodeIndex);
                assert (this.nodeIndexByNodeId[n.nodeId] == nodeIndex);
            }
            int numNodes = 0;
            for (int nodeId = 0; nodeId < this.nodeIndexByNodeId.length; ++nodeId) {
                if (this.nodeIndexByNodeId[nodeId] == -1) continue;
                ++numNodes;
            }
            assert (numNodes == CellBackup.this.cellRevision.nodes.size());
            for (int arcIndex = 0; arcIndex < CellBackup.this.cellRevision.arcs.size(); ++arcIndex) {
                ImmutableArcInst a = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(arcIndex);
                assert (this.arcIndexByArcId[a.arcId] == arcIndex);
            }
            int numArcs = 0;
            for (int arcId = 0; arcId < this.arcIndexByArcId.length; ++arcId) {
                if (this.arcIndexByArcId[arcId] == -1) continue;
                ++numArcs;
            }
            assert (numArcs == CellBackup.this.cellRevision.arcs.size());
            assert (this.exportIndexByOriginalPort.length == CellBackup.this.cellRevision.exports.size());
            ImmutableExport prevE = null;
            for (ImmutableExport e : this.exportIndexByOriginalPort) {
                if (prevE != null) assert (BY_ORIGINAL_PORT.compare(prevE, e) < 0);
                assert (e == CellBackup.this.cellRevision.getExport(e.exportId));
                prevE = e;
            }
            assert (this.connections.length == CellBackup.this.cellRevision.arcs.size() * 2);
            for (int i = 1; i < this.connections.length; ++i) {
                assert (this.compareConnections(this.connections[i - 1], this.connections[i]) < 0);
            }
        }

        private void sortConnections(int[] connections, int l, int r) {
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            while (r - l > 32) {
                int x = connections[l + r >>> 1];
                ImmutableArcInst ax = (ImmutableArcInst)arcs.get(x >>> 1);
                boolean endx = (x & 1) != 0;
                PortProtoId portIdX = endx ? ax.headPortId : ax.tailPortId;
                int chronIndexX = portIdX.getChronIndex();
                int i = l;
                int j = r;
                while (true) {
                    PortProtoId portId;
                    int con = connections[i];
                    ImmutableArcInst a = (ImmutableArcInst)arcs.get(con >>> 1);
                    boolean end = (con & 1) != 0;
                    PortProtoId portProtoId = portId = end ? a.headPortId : a.tailPortId;
                    if (portId.getChronIndex() <= chronIndexX && (portId.getChronIndex() != chronIndexX || con < x)) {
                        ++i;
                        continue;
                    }
                    while (true) {
                        con = connections[j];
                        a = (ImmutableArcInst)arcs.get(con >>> 1);
                        end = (con & 1) != 0;
                        PortProtoId portProtoId2 = portId = end ? a.headPortId : a.tailPortId;
                        if (chronIndexX > portId.getChronIndex() || chronIndexX == portId.getChronIndex() && x >= con) break;
                        --j;
                    }
                    if (i <= j) {
                        int w = connections[i];
                        connections[i] = connections[j];
                        connections[j] = w;
                        ++i;
                        --j;
                    }
                    if (i > j) break;
                }
                if (j - l < r - i) {
                    this.sortConnections(connections, l, j);
                    l = i;
                    continue;
                }
                this.sortConnections(connections, i, r);
                r = j;
            }
            this.binarySort(connections, l, r + 1);
        }

        private void binarySort(int[] connections, int lo, int hi) {
            PortProtoId portIdS;
            ImmutableArcInst aS;
            int conS;
            ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.this.cellRevision.arcs;
            assert (lo <= hi);
            int start = lo + 1;
            if (start >= hi) {
                return;
            }
            int conL = connections[lo];
            ImmutableArcInst aL = (ImmutableArcInst)arcs.get(conL >>> 1);
            PortProtoId portIdL = (conL & 1) != 0 ? aL.headPortId : aL.tailPortId;
            while (true) {
                conS = connections[start];
                aS = (ImmutableArcInst)arcs.get(conS >>> 1);
                portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
                int cmp = portIdS.chronIndex - portIdL.chronIndex;
                if (cmp < 0 || cmp == 0 && conS < conL) break;
                if (++start >= hi) {
                    return;
                }
                conL = conS;
                aL = aS;
                portIdL = portIdS;
            }
            while (true) {
                assert (start < hi);
                int left = lo;
                int right = start;
                assert (left <= right);
                while (left < right) {
                    int mid = left + right >>> 1;
                    int conM = connections[mid];
                    ImmutableArcInst aM = (ImmutableArcInst)arcs.get(conM >>> 1);
                    PortProtoId portIdM = (conM & 1) != 0 ? aM.headPortId : aM.tailPortId;
                    int cmp = portIdS.chronIndex - portIdM.chronIndex;
                    if (cmp == 0) {
                        cmp = conS - conM;
                    }
                    if (cmp < 0) {
                        right = mid;
                        continue;
                    }
                    left = mid + 1;
                }
                assert (left == right);
                int n = start - left;
                switch (n) {
                    case 2: {
                        connections[left + 2] = connections[left + 1];
                    }
                    case 1: {
                        connections[left + 1] = connections[left];
                        break;
                    }
                    default: {
                        System.arraycopy(connections, left, connections, left + 1, n);
                    }
                }
                connections[left] = conS;
                if (++start >= hi) {
                    return;
                }
                conS = connections[start];
                aS = (ImmutableArcInst)arcs.get(conS >>> 1);
                portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
            }
        }

        private int compareConnectionsSameNode(int con1, int con2) {
            ImmutableArcInst a1 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con1 >>> 1);
            ImmutableArcInst a2 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con2 >>> 1);
            PortProtoId portId1 = (con1 & 1) != 0 ? a1.headPortId : a1.tailPortId;
            PortProtoId portId2 = (con2 & 1) != 0 ? a2.headPortId : a2.tailPortId;
            int cmp = portId1.chronIndex - portId2.chronIndex;
            return cmp != 0 ? cmp : con1 - con2;
        }

        private int compareConnections(int con1, int con2) {
            boolean end2;
            int nodeId2;
            ImmutableArcInst a1 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con1 >>> 1);
            ImmutableArcInst a2 = (ImmutableArcInst)CellBackup.this.cellRevision.arcs.get(con2 >>> 1);
            boolean end1 = (con1 & 1) != 0;
            int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
            int cmp = nodeId1 - (nodeId2 = (end2 = (con2 & 1) != 0) ? a2.headNodeId : a2.tailNodeId);
            if (cmp != 0) {
                return cmp;
            }
            PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
            PortProtoId portId2 = end2 ? a2.headPortId : a2.tailPortId;
            cmp = portId1.getChronIndex() - portId2.getChronIndex();
            if (cmp != 0) {
                return cmp;
            }
            return con1 - con2;
        }
    }
}

