/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.xml.Xml807;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.awt.Color;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer {
    public static final double DEFAULT_THICKNESS = 0.0;
    public static final double DEFAULT_DISTANCE = 0.0;
    public static final String DEFAULT_MODE = "NONE";
    public static final double DEFAULT_FACTOR = 0.0;
    private static final double DEFAULT_AREA_COVERAGE = 10.0;
    private static final int PTYPE = 64;
    private static final int NTYPE = 128;
    private static final int DEPLETION = 256;
    private static final int ENHANCEMENT = 512;
    private static final int LIGHT = 1024;
    private static final int HEAVY = 2048;
    private static final int NONELEC = 8192;
    private static final int CONMETAL = 16384;
    private static final int CONPOLY = 32768;
    private static final int CONDIFF = 65536;
    private static final int NATIVE = 131072;
    private static final int HLVT = 0x200000;
    private static final int INTRANS = 0x400000;
    private static final int THICK = 0x800000;
    private static final ArrayList<Function> metalLayers = new ArrayList();
    private static final ArrayList<Function> contactLayers = new ArrayList();
    private static final ArrayList<Function> polyLayers = new ArrayList();
    private static List<Function> allFunctions;
    public static final LayerSortByName layerSortByName;
    private final String name;
    private int index = -1;
    private final Technology tech;
    private EGraphics graphics;
    private Function function;
    private static final int noFunctionExtras = 0;
    private int functionExtras;
    private boolean pseudo;
    private Setting cifLayerSetting;
    private Setting dxfLayerSetting;
    private Setting skillLayerSetting;
    private Setting resistanceSetting;
    private Setting capacitanceSetting;
    private Setting edgeCapacitanceSetting;
    private Layer pseudoLayer;
    private Layer nonPseudoLayer;
    private boolean visible;
    private boolean visibilityInitialized;
    private boolean dimmed;
    private PrimitiveNode pureLayerNode;
    private Technology.Distance pureLayerNodeXmlSize;
    private static final HashMap<Layer, Pref> layerVisibilityPrefs;
    private static final HashMap<Layer, Pref> layer3DThicknessPrefs;
    private static final HashMap<Layer, Pref> layer3DDistancePrefs;
    private static final HashMap<Layer, Pref> layer3DTransModePrefs;
    private static final HashMap<Layer, Pref> layer3DTransFactorPrefs;
    private static final HashMap<Layer, Pref> areaCoveragePrefs;

    private Layer(String name, Technology tech, EGraphics graphics) {
        this.name = name;
        this.tech = tech;
        this.graphics = graphics;
        this.nonPseudoLayer = this;
        this.visible = true;
        this.visibilityInitialized = false;
        this.dimmed = false;
        this.function = Function.UNKNOWN;
    }

    public static Layer newInstance(Technology tech, String name, EGraphics graphics) {
        Color colorFromMap;
        if (tech == null) {
            throw new NullPointerException();
        }
        int transparent = graphics.getFactoryTransparentLayer();
        if (transparent != 0 && ((colorFromMap = tech.getFactoryColorMap()[1 << transparent - 1]).getRGB() & 0xFFFFFF) != graphics.getRGB()) {
            throw new IllegalArgumentException();
        }
        Layer layer = new Layer(name, tech, graphics);
        tech.addLayer(layer);
        if (graphics.getLayer() == null) {
            graphics.setLayer(layer);
        }
        return layer;
    }

    public static Layer newInstanceFree(Technology tech, String name, EGraphics graphics) {
        Layer layer = new Layer(name, tech, graphics);
        graphics.setLayer(layer);
        return layer;
    }

    public Layer makePseudo() {
        assert (this.pseudoLayer == null);
        String pseudoLayerName = "Pseudo-" + this.name;
        this.pseudoLayer = new Layer(pseudoLayerName, this.tech, this.graphics);
        this.pseudoLayer.setFunction(this.function, this.functionExtras, true);
        this.pseudoLayer.nonPseudoLayer = this;
        return this.pseudoLayer;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public EGraphics getGraphics() {
        return this.graphics;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.functionExtras = 0;
    }

    public void setFunction(Function function, int functionExtras) {
        this.setFunction(function, functionExtras, false);
    }

    public void setFunction(Function function, int functionExtras, boolean pseudo) {
        this.function = function;
        int numBits = 0;
        for (int i = 0; i < 32; ++i) {
            if ((functionExtras & 1 << i) == 0) continue;
            ++numBits;
        }
        if (numBits >= 2 && functionExtras != 2304 && functionExtras != 1280 && functionExtras != 2560 && functionExtras != 1536) {
            throw new IllegalArgumentException("functionExtras=" + Integer.toHexString(functionExtras));
        }
        this.functionExtras = functionExtras;
        this.pseudo = pseudo;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFunctionExtras() {
        return this.functionExtras;
    }

    public void setPureLayerNode(PrimitiveNode pln) {
        this.pureLayerNode = pln;
    }

    public PrimitiveNode makePureLayerNode(String nodeName, double size, Poly.Type style, String portName, ArcProto ... connections) {
        Technology.Distance d = new Technology.Distance();
        d.addLambda(size);
        return this.makePureLayerNode(nodeName, size, null, style, portName, connections);
    }

    public PrimitiveNode makePureLayerNode(String nodeName, double size, Technology.Distance xmlSize, Poly.Type style, String portName, ArcProto ... connections) {
        PrimitiveNode pln = PrimitiveNode.newInstance0(nodeName, this.tech, size, size, new Technology.NodeLayer[]{new Technology.NodeLayer(this, 0, style, 1, Technology.TechPoint.makeFullBox())});
        pln.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this.tech, pln, connections, portName, 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        pln.setFunction(PrimitiveNode.Function.NODE);
        pln.setHoldsOutline();
        pln.setSpecialType(2);
        this.pureLayerNode = pln;
        this.pureLayerNodeXmlSize = xmlSize;
        return pln;
    }

    void resizePureLayerNode(Technology.DistanceContext context) {
        if (this.pureLayerNodeXmlSize == null) {
            return;
        }
        double lambdaSize = this.pureLayerNodeXmlSize.getLambda(context);
        this.pureLayerNode.setDefSize(lambdaSize, lambdaSize);
    }

    public PrimitiveNode getPureLayerNode() {
        return this.pureLayerNode;
    }

    public boolean isNonElectrical() {
        return (this.functionExtras & 0x2000) != 0;
    }

    public boolean isDiffusionLayer() {
        return !this.isPseudoLayer() && this.getFunction().isDiff();
    }

    public boolean isVTImplantLayer() {
        return this.function.isImplant() && (this.functionExtras & 0x200000) != 0;
    }

    public boolean isPseudoLayer() {
        return this.pseudo;
    }

    public Layer getPseudoLayer() {
        return this.pseudoLayer;
    }

    public Layer getNonPseudoLayer() {
        return this.nonPseudoLayer;
    }

    private void setNonPseudoLayer(Layer nonPseudoLayer) {
        this.nonPseudoLayer = nonPseudoLayer;
    }

    public boolean isVisible() {
        if (this.tech == null) {
            return true;
        }
        if (!this.visibilityInitialized) {
            this.visible = this.getBooleanPref("Visibility", layerVisibilityPrefs, this.visible).getBoolean();
            this.visibilityInitialized = true;
        }
        return this.visible;
    }

    public void setVisible(boolean newVis) {
        if (!this.visibilityInitialized) {
            this.visible = this.getBooleanPref("Visibility", layerVisibilityPrefs, this.visible).getBoolean();
            this.visibilityInitialized = true;
        }
        this.visible = newVis;
        PrimitiveNode.resetAllVisibility();
    }

    public static void preserveVisibility() {
        Pref.delayPrefFlushing();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                Pref visPref = layer.getBooleanPref("Visibility", layerVisibilityPrefs, layer.visible);
                boolean savedVis = visPref.getBoolean();
                if (savedVis == layer.visible) continue;
                visPref.setBoolean(layer.visible);
                if (!Job.getDebug()) continue;
                System.err.println("Save visibility of " + layer.getName());
            }
        }
        Pref.resumePrefFlushing();
    }

    public boolean isDimmed() {
        return this.dimmed;
    }

    public void setDimmed(boolean dimmed) {
        this.dimmed = dimmed;
    }

    private Setting makeLayerSetting(String what, String factory) {
        String techName = this.tech.getTechName();
        return Setting.makeStringSetting(what + "LayerFor" + this.name + "IN" + techName, Technology.getTechnologyPreferences(), this.getSubNode(what), this.name, what + " tab", what + " for layer " + this.name + " in technology " + techName, factory);
    }

    private Setting makeParasiticSetting(String what, double factory) {
        return Setting.makeDoubleSetting(what + "ParasiticFor" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), this.getSubNode(what), this.name, "Parasitic tab", "Technology " + this.tech.getTechName() + ", " + what + " for layer " + this.name, factory);
    }

    private ProjSettingsNode getSubNode(String type) {
        ProjSettingsNode node = this.tech.getProjectSettings();
        ProjSettingsNode typenode = node.getNode(type);
        return typenode;
    }

    public Pref getStringPref(String what, HashMap<Layer, Pref> map, String factory) {
        Pref pref = map.get(this);
        if (pref == null) {
            pref = Pref.makeStringPref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getBooleanPref(String what, HashMap<Layer, Pref> map, boolean factory) {
        Pref pref = map.get(this);
        if (pref == null) {
            pref = Pref.makeBooleanPref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getDoublePref(String what, HashMap<Layer, Pref> map, double factory) {
        Pref pref = map.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getIntegerPref(String what, HashMap<Layer, Pref> map, int factory) {
        Pref pref = map.get(this);
        if (pref == null) {
            pref = Pref.makeIntPref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactory3DInfo(double thickness, double distance, String mode, double factor) {
        assert (!this.isPseudoLayer());
        thickness = DBMath.round(thickness);
        distance = DBMath.round(distance);
        this.getDoublePref("Distance", layer3DDistancePrefs, distance).setDouble(distance);
        this.getDoublePref("Thickness", layer3DThicknessPrefs, thickness).setDouble(thickness);
        if (mode != null) {
            this.setTransparencyMode(mode);
        }
        this.setTransparencyFactor(factor);
    }

    public String getTransparencyMode() {
        if (this.isPseudoLayer()) {
            return this.getNonPseudoLayer().getTransparencyMode();
        }
        return this.getStringPref("3DTransparencyMode", layer3DTransModePrefs, DEFAULT_MODE).getString();
    }

    public void setTransparencyMode(String mode) {
        assert (!this.isPseudoLayer());
        this.getStringPref("3DTransparencyMode", layer3DTransModePrefs, mode).setString(mode);
    }

    public double getTransparencyFactor() {
        if (this.isPseudoLayer()) {
            return this.getNonPseudoLayer().getTransparencyFactor();
        }
        return this.getDoublePref("3DTransparencyFactor", layer3DTransFactorPrefs, 0.0).getDouble();
    }

    public void setTransparencyFactor(double factor) {
        assert (!this.isPseudoLayer());
        this.getDoublePref("3DTransparencyFactor", layer3DTransFactorPrefs, factor).setDouble(factor);
    }

    public double getDistance() {
        if (this.isPseudoLayer()) {
            return this.getNonPseudoLayer().getDistance();
        }
        return this.getDoublePref("Distance", layer3DDistancePrefs, 0.0).getDouble();
    }

    public void setDistance(double distance) {
        assert (!this.isPseudoLayer());
        try {
            Class viewClass = Resources.get3DClass("View3DWindow");
            Method setMethod = viewClass.getDeclaredMethod("setZValues", Layer.class, Double.class, Double.class, Double.class, Double.class);
            setMethod.invoke((Object)viewClass, this, new Double(this.getDistance()), new Double(this.getThickness()), new Double(distance), new Double(this.getThickness()));
        }
        catch (Exception e) {
            String extra = e.getMessage() != null ? " due to: " + e.getMessage() : ".";
            System.out.print("Cannot call 3D plugin method setZValues" + extra);
        }
        this.getDoublePref("Distance", layer3DDistancePrefs, distance).setDouble(distance);
    }

    public double getDepth() {
        return this.getDistance() + this.getThickness();
    }

    public double getThickness() {
        if (this.isPseudoLayer()) {
            return 0.0;
        }
        return this.getDoublePref("Thickness", layer3DThicknessPrefs, 0.0).getDouble();
    }

    public void setThickness(double thickness) {
        assert (!this.isPseudoLayer());
        try {
            Class viewClass = Resources.get3DClass("View3DWindow");
            Method setMethod = viewClass.getDeclaredMethod("setZValues", Layer.class, Double.class, Double.class, Double.class, Double.class);
            setMethod.invoke((Object)viewClass, this, new Double(this.getDistance()), new Double(this.getThickness()), new Double(this.getDistance()), new Double(thickness));
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method setZValues: " + e.getMessage());
            e.printStackTrace();
        }
        this.getDoublePref("Thickness", layer3DThicknessPrefs, thickness).setDouble(thickness);
    }

    public void setFactoryCIFLayer(String cifLayer) {
        assert (!this.isPseudoLayer());
        this.cifLayerSetting = this.makeLayerSetting("CIF", cifLayer);
    }

    public String getCIFLayer() {
        return this.cifLayerSetting.getString();
    }

    public Setting getCIFLayerSetting() {
        return this.cifLayerSetting;
    }

    public void setFactoryDXFLayer(String dxfLayer) {
        assert (!this.isPseudoLayer());
        this.dxfLayerSetting = this.makeLayerSetting("DXF", dxfLayer);
    }

    public String getDXFLayer() {
        if (this.dxfLayerSetting == null) {
            return "";
        }
        return this.dxfLayerSetting.getString();
    }

    public Setting getDXFLayerSetting() {
        return this.dxfLayerSetting;
    }

    public void setFactorySkillLayer(String skillLayer) {
        assert (!this.isPseudoLayer());
        this.skillLayerSetting = this.makeLayerSetting("Skill", skillLayer);
    }

    public String getSkillLayer() {
        return this.skillLayerSetting.getString();
    }

    public Setting getSkillLayerSetting() {
        return this.skillLayerSetting;
    }

    public void setFactoryParasitics(double resistance, double capacitance, double edgeCapacitance) {
        assert (!this.isPseudoLayer());
        this.resistanceSetting = this.makeParasiticSetting("Resistance", resistance);
        this.capacitanceSetting = this.makeParasiticSetting("Capacitance", capacitance);
        this.edgeCapacitanceSetting = this.makeParasiticSetting("EdgeCapacitance", edgeCapacitance);
    }

    public double getResistance() {
        return this.resistanceSetting.getDouble();
    }

    public Setting getResistanceSetting() {
        return this.resistanceSetting;
    }

    public double getCapacitance() {
        return this.capacitanceSetting.getDouble();
    }

    public Setting getCapacitanceSetting() {
        return this.capacitanceSetting;
    }

    public double getEdgeCapacitance() {
        return this.edgeCapacitanceSetting.getDouble();
    }

    public Setting getEdgeCapacitanceSetting() {
        return this.edgeCapacitanceSetting;
    }

    public void setFactoryAreaCoverage(double area) {
        this.getDoublePref("AreaCoverageJob", areaCoveragePrefs, area).setDouble(area);
    }

    public double getAreaCoverage() {
        return this.getDoublePref("AreaCoverageJob", areaCoveragePrefs, 10.0).getDouble();
    }

    public void setFactoryAreaCoverageInfo(double area) {
        this.getDoublePref("AreaCoverageJob", areaCoveragePrefs, area).setDouble(area);
    }

    void finish() {
        if (this.resistanceSetting == null || this.capacitanceSetting == null || this.edgeCapacitanceSetting == null) {
            this.setFactoryParasitics(0.0, 0.0, 0.0);
        }
        if (this.cifLayerSetting == null) {
            this.setFactoryCIFLayer("");
        }
        if (this.dxfLayerSetting == null) {
            this.setFactoryDXFLayer("");
        }
        if (this.skillLayerSetting == null) {
            this.setFactorySkillLayer("");
        }
    }

    public String toString() {
        return "Layer " + this.name;
    }

    void dump(PrintWriter out) {
        String[] layerBits = new String[]{null, null, null, null, null, null, "PTYPE", "NTYPE", "DEPLETION", "ENHANCEMENT", "LIGHT", "HEAVY", null, "NONELEC", "CONMETAL", "CONPOLY", "CONDIFF", null, null, null, null, "HLVT", "INTRANS", "THICK"};
        out.print("Layer " + this.getName() + " " + this.getFunction().name());
        Technology.printlnBits(out, layerBits, this.getFunctionExtras());
        out.print("\t");
        Technology.printlnSetting(out, this.getCIFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, this.getDXFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, this.getSkillLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, this.getResistanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, this.getCapacitanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, this.getEdgeCapacitanceSetting());
        EGraphics desc = this.getGraphics();
        out.println("\tpatternedOnDisplay=" + desc.isPatternedOnDisplay() + "(" + desc.isFactoryPatternedOnDisplay() + ")");
        out.println("\tpatternedOnPrinter=" + desc.isPatternedOnPrinter() + "(" + desc.isFactoryPatternedOnPrinter() + ")");
        out.println("\toutlined=" + (Object)((Object)desc.getOutlined()) + "(" + (Object)((Object)desc.getFactoryOutlined()) + ")");
        out.println("\ttransparent=" + desc.getTransparentLayer() + "(" + desc.getFactoryTransparentLayer() + ")");
        out.println("\tcolor=" + Integer.toHexString(desc.getColor().getRGB()) + "(" + Integer.toHexString(desc.getFactoryColor()) + ")");
        out.println("\topacity=" + desc.getOpacity() + "(" + desc.getFactoryOpacity() + ")");
        out.println("\tforeground=" + desc.getForeground());
        int[] pattern = desc.getFactoryPattern();
        out.print("\tpattern");
        for (int p : pattern) {
            out.print(" " + Integer.toHexString(p));
        }
        out.println();
        out.println("\tdistance3D=" + this.getDistance());
        out.println("\tthickness3D=" + this.getThickness());
        out.println("\tmode3D=" + this.getTransparencyMode());
        out.println("\tfactor3D=" + this.getTransparencyFactor());
        if (this.getPseudoLayer() != null) {
            out.println("\tpseudoLayer=" + this.getPseudoLayer().getName());
        }
    }

    Xml.Layer makeXml() {
        Xml.Layer l = new Xml.Layer();
        l.name = this.getName();
        l.function = this.getFunction();
        l.extraFunction = this.getFunctionExtras();
        l.desc = this.getGraphics();
        if (this.getThickness() != 0.0 || this.getDistance() != 0.0 || !this.getTransparencyMode().equals(DEFAULT_MODE) || this.getTransparencyFactor() != 0.0) {
            l.thick3D = this.getThickness();
            l.height3D = this.getDistance();
            l.mode3D = this.getTransparencyMode();
            l.factor3D = this.getTransparencyFactor();
        }
        l.cif = (String)this.getCIFLayerSetting().getFactoryValue();
        l.skill = (String)this.getSkillLayerSetting().getFactoryValue();
        l.resistance = this.getResistanceSetting().getDoubleFactoryValue();
        l.capacitance = this.getCapacitanceSetting().getDoubleFactoryValue();
        l.edgeCapacitance = this.getEdgeCapacitanceSetting().getDoubleFactoryValue();
        if (this.pureLayerNode != null) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = this.pureLayerNode.getName();
            for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
                if (e.getValue() != this.pureLayerNode) continue;
                assert (l.pureLayerNode.oldName == null);
                l.pureLayerNode.oldName = e.getKey();
            }
            l.pureLayerNode.style = this.pureLayerNode.getLayers()[0].getStyle();
            l.pureLayerNode.port = this.pureLayerNode.getPort(0).getName();
            l.pureLayerNode.size.addLambda(this.pureLayerNode.getDefWidth());
            for (ArcProto ap : this.pureLayerNode.getPort(0).getConnections()) {
                if (ap.getTechnology() != this.tech) continue;
                l.pureLayerNode.portArcs.add(ap.getName());
            }
        }
        return l;
    }

    Xml807.Layer makeXml807(Xml807.Technology t, Xml807.DisplayStyle displayStyle) {
        Xml807.Layer l = t.newLayer(this.getName());
        l.function = this.getFunction();
        l.extraFunction = this.getFunctionExtras();
        l.cif = (String)this.getCIFLayerSetting().getFactoryValue();
        l.skill = (String)this.getSkillLayerSetting().getFactoryValue();
        l.resistance = this.getResistanceSetting().getDoubleFactoryValue();
        l.capacitance = this.getCapacitanceSetting().getDoubleFactoryValue();
        l.edgeCapacitance = this.getEdgeCapacitanceSetting().getDoubleFactoryValue();
        if (this.pureLayerNode != null) {
            l.pureLayerNode = new Xml807.PureLayerNode();
            l.pureLayerNode.name = this.pureLayerNode.getName();
            for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
                if (e.getValue() != this.pureLayerNode) continue;
                assert (l.pureLayerNode.oldName == null);
                l.pureLayerNode.oldName = e.getKey();
            }
            l.pureLayerNode.style = this.pureLayerNode.getLayers()[0].getStyle();
            l.pureLayerNode.port = this.pureLayerNode.getPort(0).getName();
            for (ArcProto ap : this.pureLayerNode.getPort(0).getConnections()) {
                if (ap.getTechnology() != this.tech) continue;
                l.pureLayerNode.portArcs.add(ap.getName());
            }
        }
        Xml807.LayerDisplayStyle lds = displayStyle.newLayer(l);
        lds.desc = this.getGraphics();
        if (!this.getTransparencyMode().equals(DEFAULT_MODE) || this.getTransparencyFactor() != 0.0) {
            lds.mode3D = this.getTransparencyMode();
            lds.factor3D = this.getTransparencyFactor();
        }
        return l;
    }

    void makeXml807(Xml807.Technology t, Map<Xml807.Layer, Xml807.Distance> thick3D, Map<Xml807.Layer, Xml807.Distance> height3D) {
        Xml807.Layer l = t.findLayer(this.getName());
        Xml807.Distance dist = new Xml807.Distance();
        dist.addLambda(this.getThickness());
        thick3D.put(l, dist);
        dist = new Xml807.Distance();
        dist.addLambda(this.getDistance());
        height3D.put(l, dist);
    }

    static {
        layerSortByName = new LayerSortByName();
        layerVisibilityPrefs = new HashMap();
        layer3DThicknessPrefs = new HashMap();
        layer3DDistancePrefs = new HashMap();
        layer3DTransModePrefs = new HashMap();
        layer3DTransFactorPrefs = new HashMap();
        areaCoveragePrefs = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerSortByName
    implements Comparator<Layer> {
        private LayerSortByName() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            String s1 = l1.getName();
            String s2 = l2.getName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Function
    extends Enum<Function> {
        public static final /* enum */ Function UNKNOWN = new Function("unknown", 0, 0, 0, 35, 0);
        public static final /* enum */ Function METAL1 = new Function("metal-1", 1, 0, 0, 17, 0);
        public static final /* enum */ Function METAL2 = new Function("metal-2", 2, 0, 0, 19, 0);
        public static final /* enum */ Function METAL3 = new Function("metal-3", 3, 0, 0, 21, 0);
        public static final /* enum */ Function METAL4 = new Function("metal-4", 4, 0, 0, 23, 0);
        public static final /* enum */ Function METAL5 = new Function("metal-5", 5, 0, 0, 25, 0);
        public static final /* enum */ Function METAL6 = new Function("metal-6", 6, 0, 0, 27, 0);
        public static final /* enum */ Function METAL7 = new Function("metal-7", 7, 0, 0, 29, 0);
        public static final /* enum */ Function METAL8 = new Function("metal-8", 8, 0, 0, 31, 0);
        public static final /* enum */ Function METAL9 = new Function("metal-9", 9, 0, 0, 33, 0);
        public static final /* enum */ Function METAL10 = new Function("metal-10", 10, 0, 0, 35, 0);
        public static final /* enum */ Function METAL11 = new Function("metal-11", 11, 0, 0, 37, 0);
        public static final /* enum */ Function METAL12 = new Function("metal-12", 12, 0, 0, 39, 0);
        public static final /* enum */ Function POLY1 = new Function("poly-1", 0, 0, 1, 12, 0);
        public static final /* enum */ Function POLY2 = new Function("poly-2", 0, 0, 2, 13, 0);
        public static final /* enum */ Function POLY3 = new Function("poly-3", 0, 0, 3, 14, 0);
        public static final /* enum */ Function GATE = new Function("gate", 0, 0, 0, 15, 0x400000);
        public static final /* enum */ Function DIFF = new Function("diffusion", 0, 0, 0, 11, 0);
        public static final /* enum */ Function DIFFP = new Function("p-diffusion", 0, 0, 0, 11, 64);
        public static final /* enum */ Function DIFFN = new Function("n-diffusion", 0, 0, 0, 11, 128);
        public static final /* enum */ Function IMPLANT = new Function("implant", 0, 0, 0, 2, 0);
        public static final /* enum */ Function IMPLANTP = new Function("p-implant", 0, 0, 0, 2, 64);
        public static final /* enum */ Function IMPLANTN = new Function("n-implant", 0, 0, 0, 2, 128);
        public static final /* enum */ Function CONTACT1 = new Function("contact-1", 0, 1, 0, 16, 0);
        public static final /* enum */ Function CONTACT2 = new Function("contact-2", 0, 2, 0, 18, 0);
        public static final /* enum */ Function CONTACT3 = new Function("contact-3", 0, 3, 0, 20, 0);
        public static final /* enum */ Function CONTACT4 = new Function("contact-4", 0, 4, 0, 22, 0);
        public static final /* enum */ Function CONTACT5 = new Function("contact-5", 0, 5, 0, 24, 0);
        public static final /* enum */ Function CONTACT6 = new Function("contact-6", 0, 6, 0, 26, 0);
        public static final /* enum */ Function CONTACT7 = new Function("contact-7", 0, 7, 0, 28, 0);
        public static final /* enum */ Function CONTACT8 = new Function("contact-8", 0, 8, 0, 30, 0);
        public static final /* enum */ Function CONTACT9 = new Function("contact-9", 0, 9, 0, 32, 0);
        public static final /* enum */ Function CONTACT10 = new Function("contact-10", 0, 10, 0, 34, 0);
        public static final /* enum */ Function CONTACT11 = new Function("contact-11", 0, 11, 0, 36, 0);
        public static final /* enum */ Function CONTACT12 = new Function("contact-12", 0, 12, 0, 38, 0);
        public static final /* enum */ Function PLUG = new Function("plug", 0, 0, 0, 40, 0);
        public static final /* enum */ Function OVERGLASS = new Function("overglass", 0, 0, 0, 41, 0);
        public static final /* enum */ Function RESISTOR = new Function("resistor", 0, 0, 0, 4, 0);
        public static final /* enum */ Function CAP = new Function("capacitor", 0, 0, 0, 5, 0);
        public static final /* enum */ Function TRANSISTOR = new Function("transistor", 0, 0, 0, 3, 0);
        public static final /* enum */ Function EMITTER = new Function("emitter", 0, 0, 0, 6, 0);
        public static final /* enum */ Function BASE = new Function("base", 0, 0, 0, 7, 0);
        public static final /* enum */ Function COLLECTOR = new Function("collector", 0, 0, 0, 8, 0);
        public static final /* enum */ Function SUBSTRATE = new Function("substrate", 0, 0, 0, 1, 0);
        public static final /* enum */ Function WELL = new Function("well", 0, 0, 0, 0, 0);
        public static final /* enum */ Function WELLP = new Function("p-well", 0, 0, 0, 0, 64);
        public static final /* enum */ Function WELLN = new Function("n-well", 0, 0, 0, 0, 128);
        public static final /* enum */ Function GUARD = new Function("guard", 0, 0, 0, 9, 0);
        public static final /* enum */ Function ISOLATION = new Function("isolation", 0, 0, 0, 10, 0);
        public static final /* enum */ Function BUS = new Function("bus", 0, 0, 0, 42, 0);
        public static final /* enum */ Function ART = new Function("art", 0, 0, 0, 43, 0);
        public static final /* enum */ Function CONTROL = new Function("control", 0, 0, 0, 44, 0);
        public static final /* enum */ Function TILENOT = new Function("tileNot", 0, 0, 0, 45, 0);
        public static final int DEPLETION = 256;
        public static final int ENHANCEMENT = 512;
        public static final int LIGHT = 1024;
        public static final int HEAVY = 2048;
        public static final int NONELEC = 8192;
        public static final int CONMETAL = 16384;
        public static final int CONPOLY = 32768;
        public static final int CONDIFF = 65536;
        public static final int HLVT = 0x200000;
        public static final int THICK = 0x800000;
        public static final int NATIVE = 131072;
        private final String name;
        private final boolean isMetal;
        private final boolean isContact;
        private final boolean isPoly;
        private int level;
        private final int height;
        private final int extraBits;
        private static final int[] extras;
        private static final /* synthetic */ Function[] $VALUES;

        public static final Function[] values() {
            return (Function[])$VALUES.clone();
        }

        public static Function valueOf(String name) {
            return Enum.valueOf(Function.class, name);
        }

        private Function(String name, int metalLevel, int contactLevel, int polyLevel, int height, int extraBits) {
            this.name = name;
            this.height = height;
            this.extraBits = extraBits;
            this.isMetal = metalLevel != 0;
            this.isContact = contactLevel != 0;
            boolean bl = this.isPoly = polyLevel != 0;
            if (this.isMetal) {
                this.addToLayers(metalLayers, metalLevel);
            }
            if (contactLevel != 0) {
                this.addToLayers(contactLayers, contactLevel);
            }
            if (polyLevel != 0) {
                this.addToLayers(polyLayers, polyLevel);
            }
        }

        private void addToLayers(ArrayList<Function> layers, int level) {
            this.level = level;
            while (layers.size() <= level) {
                layers.add(null);
            }
            Function oldFunction = layers.set(level, this);
            assert (oldFunction == null);
        }

        public String toString() {
            String toStr = this.name;
            for (int i = 0; i < extras.length; ++i) {
                if ((this.extraBits & extras[i]) == 0) continue;
                toStr = toStr + "," + Function.getExtraName(extras[i]);
            }
            return toStr;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public static List<Function> getFunctions() {
            return allFunctions;
        }

        public static int[] getFunctionExtras() {
            return extras;
        }

        public static String getExtraName(int extra) {
            if (extra == 64) {
                return "p-type";
            }
            if (extra == 128) {
                return "n-type";
            }
            if (extra == 256) {
                return "depletion";
            }
            if (extra == 512) {
                return "enhancement";
            }
            if (extra == 1024) {
                return "light";
            }
            if (extra == 2048) {
                return "heavy";
            }
            if (extra == 8192) {
                return "nonelectrical";
            }
            if (extra == 16384) {
                return "connects-metal";
            }
            if (extra == 32768) {
                return "connects-poly";
            }
            if (extra == 65536) {
                return "connects-diff";
            }
            if (extra == 0x200000) {
                return "vt";
            }
            if (extra == 0x400000) {
                return "inside-transistor";
            }
            if (extra == 0x800000) {
                return "thick";
            }
            if (extra == 131072) {
                return "native";
            }
            return "";
        }

        public static String getExtraConstantName(int extra) {
            if (extra == 64) {
                return "PTYPE";
            }
            if (extra == 128) {
                return "NTYPE";
            }
            if (extra == 256) {
                return "DEPLETION";
            }
            if (extra == 512) {
                return "ENHANCEMENT";
            }
            if (extra == 1024) {
                return "LIGHT";
            }
            if (extra == 2048) {
                return "HEAVY";
            }
            if (extra == 8192) {
                return "NONELEC";
            }
            if (extra == 16384) {
                return "CONMETAL";
            }
            if (extra == 32768) {
                return "CONPOLY";
            }
            if (extra == 65536) {
                return "CONDIFF";
            }
            if (extra == 0x200000) {
                return "HLVT";
            }
            if (extra == 0x400000) {
                return "INTRANS";
            }
            if (extra == 0x800000) {
                return "THICK";
            }
            if (extra == 131072) {
                return "NATIVE";
            }
            return "";
        }

        public static int parseExtraName(String name) {
            if (name.equalsIgnoreCase("p-type")) {
                return 64;
            }
            if (name.equalsIgnoreCase("n-type")) {
                return 128;
            }
            if (name.equalsIgnoreCase("depletion")) {
                return 256;
            }
            if (name.equalsIgnoreCase("enhancement")) {
                return 512;
            }
            if (name.equalsIgnoreCase("light")) {
                return 1024;
            }
            if (name.equalsIgnoreCase("heavy")) {
                return 2048;
            }
            if (name.equalsIgnoreCase("nonelectrical")) {
                return 8192;
            }
            if (name.equalsIgnoreCase("connects-metal")) {
                return 16384;
            }
            if (name.equalsIgnoreCase("connects-poly")) {
                return 32768;
            }
            if (name.equalsIgnoreCase("connects-diff")) {
                return 65536;
            }
            if (name.equalsIgnoreCase("inside-transistor")) {
                return 0x400000;
            }
            if (name.equalsIgnoreCase("thick")) {
                return 0x800000;
            }
            if (name.equalsIgnoreCase("vt")) {
                return 0x200000;
            }
            if (name.equalsIgnoreCase("native")) {
                return 131072;
            }
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            if (level > 12) {
                System.out.println("Invalid metal layer level:" + level);
                return null;
            }
            Function func = (Function)((Object)metalLayers.get(new Integer(level)));
            return func;
        }

        public static Function getContact(int level) {
            if (level > 12) {
                System.out.println("Invalid via layer level:" + level);
                return null;
            }
            Function func = (Function)((Object)contactLayers.get(new Integer(level)));
            return func;
        }

        public static Function getPoly(int level) {
            Function func = (Function)((Object)polyLayers.get(new Integer(level)));
            return func;
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public boolean isDiff() {
            return this == DIFF || this == DIFFP || this == DIFFN;
        }

        public boolean isPoly() {
            return this.isPoly || this == GATE;
        }

        public boolean isGatePoly() {
            return this.isPoly() && (this.extraBits & 0x400000) != 0;
        }

        public boolean isContact() {
            return this.isContact;
        }

        public boolean isWell() {
            return this == WELL || this == WELLP || this == WELLN;
        }

        public boolean isSubstrate() {
            return this == SUBSTRATE || this == WELL || this == WELLP || this == WELLN || this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isImplant() {
            return this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isUsed(int numMetals, int numPolys) {
            if (this.isMetal || this.isContact) {
                return this.level <= numMetals;
            }
            if (this.isPoly) {
                return this.level <= numPolys;
            }
            return true;
        }

        public int getHeight() {
            return this.height;
        }

        static {
            $VALUES = new Function[]{UNKNOWN, METAL1, METAL2, METAL3, METAL4, METAL5, METAL6, METAL7, METAL8, METAL9, METAL10, METAL11, METAL12, POLY1, POLY2, POLY3, GATE, DIFF, DIFFP, DIFFN, IMPLANT, IMPLANTP, IMPLANTN, CONTACT1, CONTACT2, CONTACT3, CONTACT4, CONTACT5, CONTACT6, CONTACT7, CONTACT8, CONTACT9, CONTACT10, CONTACT11, CONTACT12, PLUG, OVERGLASS, RESISTOR, CAP, TRANSISTOR, EMITTER, BASE, COLLECTOR, SUBSTRATE, WELL, WELLP, WELLN, GUARD, ISOLATION, BUS, ART, CONTROL, TILENOT};
            extras = new int[]{64, 128, 256, 512, 1024, 2048, 8192, 16384, 32768, 65536, 0x200000, 0x400000, 0x800000};
            allFunctions = Arrays.asList(Function.class.getEnumConstants());
            assert (allFunctions.size() <= 64);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Set {
            final long bits;
            final int extraBits;
            public static final Set ALL = new Set((Function[])Function.class.getEnumConstants());

            public Set(Function f, int extraB) {
                this.bits = Set.bit(f);
                this.extraBits = extraB;
            }

            public Set(Function ... funs) {
                long bits = 0L;
                for (Function f : funs) {
                    bits |= Set.bit(f);
                }
                this.bits = bits;
                this.extraBits = 0;
            }

            public Set(Collection<Function> funs) {
                long bits = 0L;
                for (Function f : funs) {
                    bits |= Set.bit(f);
                }
                this.bits = bits;
                this.extraBits = 0;
            }

            public boolean contains(Function f, int extraFunction) {
                boolean extraBitsM = this.extraBits == 0 || this.extraBits == extraFunction;
                return extraBitsM && (this.bits & Set.bit(f)) != 0L;
            }

            private static long bit(Function f) {
                return 1L << f.ordinal();
            }
        }
    }
}

