/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Router {
    protected boolean verbose = false;
    protected Tool tool;

    public void createRoute(Route route, Cell cell) {
        new CreateRouteJob(this.toString(), route, cell, this.verbose, this.tool);
    }

    public static PortInst createRouteNoJob(Route route, Cell cell, boolean highlightRouteEnd, Map<ArcProto, Integer> arcsCreatedMap, Map<NodeProto, Integer> nodesCreatedMap) {
        RouteElementPort finalRE;
        RouteElementPort rep;
        Integer i;
        EDatabase.serverDatabase().checkChanging();
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, true) != 0) {
            return null;
        }
        for (RouteElement e : route) {
            if (e.getAction() != RouteElement.RouteElementAction.newNode || e.isDone()) continue;
            e.doAction();
            RouteElementPort rep2 = (RouteElementPort)e;
            i = nodesCreatedMap.get(rep2.getPortProto().getParent());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            nodesCreatedMap.put(rep2.getPortProto().getParent(), i);
        }
        for (RouteElement e : route) {
            e.doAction();
            if (e.getAction() != RouteElement.RouteElementAction.newArc) continue;
            RouteElementArc rea = (RouteElementArc)e;
            i = arcsCreatedMap.get(rea.getArcProto());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            arcsCreatedMap.put(rea.getArcProto(), i);
        }
        if (arcsCreatedMap.get(Generic.tech.unrouted_arc) == null && (rep = route.getStart()) != null && rep.getPortInst() != null) {
            PortInst pi = rep.getPortInst();
            Iterator<Connection> it = pi.getConnections();
            while (it.hasNext()) {
                Connection conn = it.next();
                ArcInst ai = conn.getArc();
                if (ai.getProto() != Generic.tech.unrouted_arc) continue;
                Connection oconn = ai.getConnection(1 - conn.getEndIndex());
                if (oconn.getPortInst() != route.getEnd().getPortInst()) {
                    RouteElementPort newEnd = RouteElementPort.existingPortInst(oconn.getPortInst(), oconn.getLocation());
                    RouteElementArc newArc = RouteElementArc.newArc(cell, Generic.tech.unrouted_arc, Generic.tech.unrouted_arc.getDefaultLambdaBaseWidth(), route.getEnd(), newEnd, route.getEnd().getLocation(), oconn.getLocation(), null, ai.getTextDescriptor(ArcInst.ARC_NAME), ai, true, true, null);
                    newArc.doAction();
                }
                if (!conn.getArc().isLinked()) continue;
                conn.getArc().kill();
            }
        }
        PortInst created = null;
        if (highlightRouteEnd && (finalRE = route.getEnd()) != null) {
            created = finalRE.getPortInst();
        }
        return created;
    }

    public static void reportRoutingResults(String prefix, Map<ArcProto, Integer> arcsCreatedMap, Map<NodeProto, Integer> nodesCreatedMap) {
        ArrayList<ArcProto> arcEntries = new ArrayList<ArcProto>(arcsCreatedMap.keySet());
        ArrayList<NodeProto> nodeEntries = new ArrayList<NodeProto>(nodesCreatedMap.keySet());
        if (arcEntries.size() == 0 && nodeEntries.size() == 0) {
            System.out.println(prefix + ": nothing added");
        } else {
            Integer i;
            System.out.print(prefix + " added: ");
            Collections.sort(arcEntries, new TextUtils.ObjectsByToString());
            Collections.sort(nodeEntries, new TextUtils.ObjectsByToString());
            int total = arcEntries.size() + nodeEntries.size();
            int sofar = 0;
            for (ArcProto ap : arcEntries) {
                i = arcsCreatedMap.get(ap);
                if (++sofar > 1 && total > 1) {
                    if (sofar < total) {
                        System.out.print(", ");
                    } else {
                        System.out.print(" and ");
                    }
                }
                System.out.print(i + " " + ap.describe());
                if (i > 1) {
                    System.out.print(" arcs");
                    continue;
                }
                System.out.print(" arc");
            }
            for (NodeProto np : nodeEntries) {
                i = nodesCreatedMap.get(np);
                if (++sofar > 1 && total > 1) {
                    if (sofar < total) {
                        System.out.print(", ");
                    } else {
                        System.out.print(" and ");
                    }
                }
                System.out.print(i + " " + np.describe(false));
                if (i > 1) {
                    System.out.print(" nodes");
                    continue;
                }
                System.out.print(" node");
            }
            System.out.println();
            User.playSound();
        }
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public static ArcProto getArcToUse(PortProto port1, PortProto port2) {
        ArcProto curAp = User.getUserTool().getCurrentArcProto();
        ArcProto uni = Generic.tech.universal_arc;
        ArcProto invis = Generic.tech.invisible_arc;
        ArcProto unr = Generic.tech.unrouted_arc;
        PortProto pp1 = null;
        PortProto pp2 = null;
        if (port1 == null) {
            pp1 = port2;
        } else {
            pp1 = port1;
            pp2 = port2;
        }
        if (pp1 == null && pp2 == null) {
            return null;
        }
        if (pp2 == null) {
            if (pp1.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator<Comparable<ArcProto>> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator<ArcProto> aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = aIt.next();
                    if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        } else {
            if (pp1.connectsTo(curAp) && pp2.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator<Comparable<ArcProto>> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator<ArcProto> aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = aIt.next();
                    if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        }
        return null;
    }

    protected static void useWidestWire(Route route, ArcProto ap) {
        double width = Router.getArcWidthToUse(route, ap);
        for (RouteElement re : route) {
            RouteElementArc reArc;
            if (!(re instanceof RouteElementArc) || (reArc = (RouteElementArc)re).getArcProto() != ap) continue;
            reArc.setArcBaseWidth(width);
        }
    }

    protected static double getArcWidthToUse(Route route, ArcProto ap) {
        double widest = ap.getDefaultLambdaBaseWidth();
        for (RouteElement re : route) {
            double width = Router.getArcWidthToUse(re, ap);
            if (!(width > widest)) continue;
            widest = width;
        }
        return widest;
    }

    public static double getArcWidthToUse(PortInst pi, ArcProto ap) {
        Cell cell;
        Export export;
        PortInst exportedInst;
        double width2;
        if (pi == null) {
            return ap.getDefaultLambdaBaseWidth();
        }
        double width = ap.getDefaultLambdaBaseWidth();
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (ai.getProto() != ap || !(width < (newWidth = c.getArc().getLambdaBaseWidth()))) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = Router.getArcWidthToUse(exportedInst = (export = (cell = (Cell)ni.getProto()).findExport(pi.getPortProto().getName())).getOriginalPort(), ap)) > width) {
            width = width2;
        }
        return width;
    }

    protected static double getArcWidthToUse(RouteElement re, ArcProto ap) {
        double width;
        double connectedWidth = width = ap.getDefaultLambdaBaseWidth();
        if (re instanceof RouteElementPort) {
            double width2;
            RouteElementPort rePort = (RouteElementPort)re;
            connectedWidth = rePort.getWidestConnectingArc(ap);
            if (rePort.getPortInst() != null && (width2 = Router.getArcWidthToUse(rePort.getPortInst(), ap)) > connectedWidth) {
                connectedWidth = width2;
            }
        }
        if (re instanceof RouteElementArc) {
            RouteElementArc reArc = (RouteElementArc)re;
            connectedWidth = reArc.getArcBaseWidth();
        }
        if (width > connectedWidth) {
            return width;
        }
        return connectedWidth;
    }

    protected static Dimension2D getContactSize(RouteElement startRE, RouteElement endRE) {
        Dimension2D start = Router.getContactSize(startRE);
        Dimension2D end = Router.getContactSize(endRE);
        Dimension2D.Double dim = new Dimension2D.Double(start);
        if (end.getWidth() > ((Dimension2D)dim).getWidth()) {
            ((Dimension2D)dim).setSize(end.getWidth(), ((Dimension2D)dim).getHeight());
        }
        if (end.getHeight() > ((Dimension2D)dim).getHeight()) {
            ((Dimension2D)dim).setSize(((Dimension2D)dim).getWidth(), end.getHeight());
        }
        return dim;
    }

    protected static Dimension2D getContactSize(RouteElement re) {
        Iterator<Object> it;
        RouteElementPort rePort;
        double width = -1.0;
        double height = -1.0;
        if (re instanceof RouteElementArc) {
            RouteElementArc reArc = (RouteElementArc)re;
            if (reArc.isArcVertical() && reArc.getArcBaseWidth() > width) {
                width = reArc.getArcBaseWidth();
            }
            if (reArc.isArcHorizontal() && reArc.getArcBaseWidth() > height) {
                height = reArc.getArcBaseWidth();
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            rePort = (RouteElementPort)re;
            PortInst pi = rePort.getPortInst();
            it = pi.getConnections();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                ArcInst arc = conn.getArc();
                EPoint head = arc.getHeadLocation();
                EPoint tail = arc.getTailLocation();
                double newWidth = arc.getLambdaBaseWidth();
                if (((Point2D)head).getX() == ((Point2D)tail).getX() && newWidth > width) {
                    width = newWidth;
                }
                if (((Point2D)head).getY() != ((Point2D)tail).getY() || !(newWidth > height)) continue;
                height = newWidth;
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.newNode) {
            rePort = (RouteElementPort)re;
            Dimension2D dim = null;
            it = rePort.getNewArcs();
            while (it.hasNext()) {
                RouteElement newArcRE = (RouteElement)it.next();
                Dimension2D d = Router.getContactSize(newArcRE);
                if (dim == null) {
                    dim = d;
                }
                if (d.getWidth() > dim.getWidth()) {
                    dim.setSize(d.getWidth(), dim.getHeight());
                }
                if (!(d.getHeight() > dim.getHeight())) continue;
                dim.setSize(dim.getWidth(), d.getHeight());
            }
            if (dim == null) {
                dim = new Dimension2D.Double(-1.0, -1.0);
            }
            return dim;
        }
        return new Dimension2D.Double(width, height);
    }

    protected static class CreateRouteJob
    extends Job {
        protected Route route;
        private boolean verbose;
        private Cell cell;
        private PortInst portToHighlight;

        protected CreateRouteJob(String what, Route route, Cell cell, boolean verbose, Tool tool) {
            super(what, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.route = route;
            this.verbose = verbose;
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
            HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
            this.portToHighlight = Router.createRouteNoJob(this.route, this.cell, this.verbose, arcsCreatedMap, nodesCreatedMap);
            Router.reportRoutingResults("Wiring", arcsCreatedMap, nodesCreatedMap);
            this.fieldVariableChanged("portToHighlight");
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui;
            EditWindow_ wnd;
            if (this.portToHighlight != null && (wnd = (ui = Job.getUserInterface()).getCurrentEditWindow_()) != null) {
                wnd.clearHighlighting();
                wnd.addElectricObject(this.portToHighlight, this.cell);
                wnd.finishedHighlighting();
            }
        }
    }
}

