/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.processing.LocalPartitionResult;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.LeafEquivRecords;
import com.sun.electric.tool.user.ncc.ExportAssertionFailures;
import com.sun.electric.tool.user.ncc.ExportConflict;
import com.sun.electric.tool.user.ncc.ExportMismatch;
import com.sun.electric.tool.user.ncc.UnrecognizedPart;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NccComparisonMismatches {
    private boolean exportMatch = true;
    private boolean topologyMatch = true;
    private boolean sizeMatch = true;
    private boolean sizeChecked = false;
    private boolean swapCells = false;
    private String[] cellNames;
    private Cell[] cells;
    private VarContext[] contexts;
    private CellSummary summary;
    private List exportMismatches = new LinkedList();
    private LocalPartitionResult lpResult = null;
    private EquivRecord[] hashMismEqvRecrds;
    private List sizeMismatches = new LinkedList();
    private int numExportsValidOnlyWhenTopologyMismatch = 0;
    private List exportAssertionFailures = new LinkedList();
    private List networkExportConflicts = new LinkedList();
    private List charactExportConflicts = new LinkedList();
    private List unrecognizedParts = new LinkedList();
    private boolean printHashFailures;

    public void setGlobalData(NccGlobals globals) {
        this.cellNames = globals.getRootCellNames();
        this.cells = globals.getRootCells();
        this.contexts = globals.getRootContexts();
        if (this.cellNames[0].indexOf("{sch}") == -1 && this.cellNames[1].indexOf("{sch}") != -1) {
            String s = this.cellNames[0];
            this.cellNames[0] = this.cellNames[1];
            this.cellNames[1] = s;
            Cell c = this.cells[0];
            this.cells[0] = this.cells[1];
            this.cells[1] = c;
            VarContext vc = this.contexts[0];
            this.contexts[0] = this.contexts[1];
            this.contexts[1] = vc;
            this.swapCells = true;
        } else {
            this.swapCells = false;
        }
        this.sizeChecked = globals.getOptions().checkSizes;
        this.printHashFailures = globals.isPrintHashFailures();
        if (this.lpResult == null || this.lpResult.matches()) {
            LeafEquivRecords parts = globals.getPartLeafEquivRecs();
            LeafEquivRecords wires = globals.getWireLeafEquivRecs();
            this.hashMismEqvRecrds = new EquivRecord[parts.numNotMatched() + wires.numNotMatched()];
            int i = 0;
            Iterator it = parts.getNotMatched();
            while (it.hasNext()) {
                this.hashMismEqvRecrds[i] = (EquivRecord)it.next();
                ++i;
            }
            it = wires.getNotMatched();
            while (it.hasNext()) {
                this.hashMismEqvRecrds[i] = (EquivRecord)it.next();
                ++i;
            }
        }
        this.summary = new CellSummary(globals.getPartCounts(), globals.getPortCounts(), globals.getWireCounts(), globals.cantBuildNetlistBits());
    }

    public int getTotalMismatchCount() {
        int eqvRecCount = 0;
        if (this.lpResult != null && !this.lpResult.matches()) {
            eqvRecCount += this.lpResult.size();
        } else if (this.hashMismEqvRecrds != null && this.printHashFailures) {
            eqvRecCount += this.hashMismEqvRecrds.length;
        }
        return this.getValidExportMismatchCount() + eqvRecCount + this.sizeMismatches.size() + this.exportAssertionFailures.size() + this.networkExportConflicts.size() + this.charactExportConflicts.size() + this.unrecognizedParts.size();
    }

    public boolean isSwapCells() {
        return this.swapCells;
    }

    public String[] getNames() {
        return this.cellNames;
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public VarContext[] getContexts() {
        return this.contexts;
    }

    public CellSummary getCellSummary() {
        return this.summary;
    }

    public void addExportMismatch(ExportMismatch em) {
        this.exportMismatches.add(em);
        if (em.isValidOnlyWhenTopologyMismatch()) {
            ++this.numExportsValidOnlyWhenTopologyMismatch;
        }
    }

    public List getExportMismatches() {
        return this.exportMismatches;
    }

    public void setLocalPartitionResult(LocalPartitionResult lpr) {
        this.lpResult = lpr;
    }

    public LocalPartitionResult getLocalPartitionResult() {
        return this.lpResult;
    }

    public EquivRecord[] getHashMismatchedEquivRecords() {
        return this.hashMismEqvRecrds;
    }

    public boolean isHashFailuresPrinted() {
        return this.printHashFailures;
    }

    public void setMatchFlags(boolean em, boolean tm, boolean sm) {
        this.exportMatch = em;
        this.topologyMatch = tm;
        this.sizeMatch = sm;
    }

    public boolean isExportMatch() {
        return this.exportMatch;
    }

    public boolean isSizeMatch() {
        return this.sizeMatch;
    }

    public boolean isTopologyMatch() {
        return this.topologyMatch;
    }

    public boolean isSizeChecked() {
        return this.sizeChecked;
    }

    public int getValidExportMismatchCount() {
        if (this.topologyMatch) {
            return this.exportMismatches.size() - this.numExportsValidOnlyWhenTopologyMismatch;
        }
        return this.exportMismatches.size();
    }

    public List getSizeMismatches() {
        return this.sizeMismatches;
    }

    public void setSizeMismatches(List sizeMismatches) {
        this.sizeMismatches = sizeMismatches;
    }

    public void addExportAssertionFailure(Cell cell, VarContext context, Object[][] items, String[][] names) {
        this.exportAssertionFailures.add(new ExportAssertionFailures(cell, context, items, names));
    }

    public List getExportAssertionFailures() {
        return this.exportAssertionFailures;
    }

    public void addNetworkExportConflict(ExportConflict.NetworkConflict conf) {
        this.networkExportConflicts.add(conf);
    }

    public List getNetworkExportConflicts() {
        return this.networkExportConflicts;
    }

    public void addCharactExportConflict(ExportConflict.CharactConflict conf) {
        this.charactExportConflicts.add(conf);
    }

    public List getCharactExportConflicts() {
        return this.charactExportConflicts;
    }

    public void addUnrecognizedPart(UnrecognizedPart mos) {
        this.unrecognizedParts.add(mos);
    }

    public List getUnrecognizedParts() {
        return this.unrecognizedParts;
    }

    static class CellSummary {
        public final int[] numParts;
        public final int[] numPorts;
        public final int[] numWires;
        public final boolean[] cantBuildNetlist;

        public CellSummary(int[] parts, int[] ports, int[] wires, boolean[] cantBuildNetlistBits) {
            this.numParts = parts;
            this.numPorts = ports;
            this.numWires = wires;
            this.cantBuildNetlist = cantBuildNetlistBits;
        }
    }
}

