/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutableVariable;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.ELIB;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JELIB;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.ReadableDump;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class LibraryFiles
extends Input {
    public static final Variable.Key IO_TRUE_LIBRARY;
    public static final Variable.Key IO_DUMMY_OBJECT;
    protected Library lib;
    protected boolean topLevelLibrary;
    protected int nodeProtoCount;
    protected Cell[] nodeProtoList;
    protected double[] cellLambda;
    protected static int totalCells;
    protected static int cellsConstructed;
    protected List scaledCells;
    protected int errorCount;
    protected Version version;
    protected boolean convertMosisCmosTechnologies;
    protected boolean scaleLambdaBy20;
    protected boolean rotationMirrorBits;
    private String[] fontNames;
    MutableTextDescriptor mtd = new MutableTextDescriptor();
    ArrayList variablesBuf = new ArrayList();
    protected static String mainLibDirectory;
    private static List libsBeingRead;
    protected static final boolean VERBOSE = false;
    protected static final double TINYDISTANCE;
    static final /* synthetic */ boolean $assertionsDisabled;

    LibraryFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Library readLibrary(URL fileURL, String libName, FileType type, boolean quick) {
        if (fileURL == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("Library Read");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        LibraryFiles.initializeLibraryInput();
        Library lib = null;
        boolean formerQuiet = Undo.changesQuiet(true);
        try {
            LibraryFiles.startProgressDialog("library", fileURL.getFile());
            Cell.setAllowCircularLibraryDependences(true);
            Pref.initMeaningVariableGathering();
            StringBuffer errmsg = new StringBuffer();
            boolean exists = TextUtils.URLExists(fileURL, errmsg);
            if (!exists) {
                System.out.print(errmsg.toString());
                String fileName = fileURL.toString();
                if (fileName.indexOf(".") == -1) {
                    fileURL = TextUtils.makeURLToFile(fileName + "." + type.getExtensions()[0]);
                    System.out.print("Attempting to open " + fileURL + "\n");
                    errmsg.setLength(0);
                    exists = TextUtils.URLExists(fileURL, errmsg);
                    if (!exists) {
                        System.out.print(errmsg.toString());
                    }
                }
            }
            if (exists) {
                if (libName == null) {
                    libName = TextUtils.getFileNameWithoutExtension(fileURL);
                }
                lib = LibraryFiles.readALibrary(fileURL, null, libName, type);
            }
            LibraryFiles.cleanupLibraryInput();
        }
        finally {
            LibraryFiles.stopProgressDialog();
            Cell.setAllowCircularLibraryDependences(false);
        }
        Undo.changesQuiet(formerQuiet);
        if (lib != null && !quick) {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
            Pref.reconcileMeaningVariables(lib.getName());
        }
        errorLogger.termLogging(true);
        return lib;
    }

    protected static Library readALibrary(URL fileURL, Library lib, String libName, FileType type) {
        LibraryFiles in;
        if (type == FileType.ELIB) {
            in = new ELIB();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.JELIB) {
            in = new JELIB();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else if (type == FileType.READABLEDUMP) {
            in = new ReadableDump();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else {
            System.out.println("Unknown import type: " + type);
            return null;
        }
        in.topLevelLibrary = false;
        if (lib == null) {
            mainLibDirectory = TextUtils.getFilePath(fileURL);
            in.topLevelLibrary = true;
        }
        if (lib == null) {
            lib = Library.newInstance(libName, fileURL);
        }
        in.lib = lib;
        boolean error = in.readInputLibrary();
        in.closeInput();
        if (error) {
            System.out.println("Error reading " + lib);
            if (in.topLevelLibrary) {
                mainLibDirectory = null;
            }
            return null;
        }
        return in.lib;
    }

    public static void initializeLibraryInput() {
        libsBeingRead = new ArrayList();
    }

    public boolean readInputLibrary() {
        if (!$assertionsDisabled && libsBeingRead.contains(this)) {
            throw new AssertionError();
        }
        libsBeingRead.add(this);
        this.scaledCells = new ArrayList();
        return this.readLib();
    }

    protected void scanNodesForRecursion(Cell cell, HashSet markCellForNodes, NodeProto[] nil, int start, int end) {
        for (int j = start; j < end; ++j) {
            Cell otherCell;
            NodeProto np = nil[j];
            if (np instanceof PrimitiveNode || (otherCell = (Cell)np) == null || markCellForNodes.contains(otherCell)) continue;
            LibraryFiles reader = this;
            if (otherCell.getLibrary() != cell.getLibrary()) {
                reader = this.getReaderForLib(otherCell.getLibrary());
            }
            if (reader == null) continue;
            reader.realizeCellsRecursively(otherCell, markCellForNodes, null, 0.0);
        }
        markCellForNodes.add(cell);
    }

    protected boolean readLib() {
        return true;
    }

    protected View findOldViewName(String viewName) {
        if (this.version.getMajor() < 8) {
            if (viewName.equals("compensated")) {
                return View.LAYOUTCOMP;
            }
            if (viewName.equals("skeleton")) {
                return View.LAYOUTSKEL;
            }
            if (viewName.equals("simulation-snapshot")) {
                return View.DOCWAVE;
            }
            if (viewName.equals("netlist-netlisp-format")) {
                return View.NETLISTNETLISP;
            }
            if (viewName.equals("netlist-rsim-format")) {
                return View.NETLISTRSIM;
            }
            if (viewName.equals("netlist-silos-format")) {
                return View.NETLISTSILOS;
            }
            if (viewName.equals("netlist-quisc-format")) {
                return View.NETLISTQUISC;
            }
            if (viewName.equals("netlist-als-format")) {
                return View.NETLISTALS;
            }
        }
        return null;
    }

    protected Technology findTechnologyName(String name) {
        Technology tech = null;
        if (this.convertMosisCmosTechnologies) {
            if (name.equals("mocmossub")) {
                tech = MoCMOS.tech;
            } else if (name.equals("mocmos")) {
                tech = Technology.findTechnology("mocmosold");
            }
        }
        if (tech == null) {
            tech = Technology.findTechnology(name);
        }
        if (tech == null && name.equals("logic")) {
            tech = Schematics.tech;
        }
        if (tech == null && (name.equals("epic8c") || name.equals("epic7c"))) {
            tech = Technology.findTechnology("epic7s");
        }
        return tech;
    }

    protected Library readExternalLibraryFromFilename(String theFileName, FileType defaultType) {
        boolean exists;
        FileType importType;
        int slashPos;
        int colonPos;
        URL url = TextUtils.makeURLToFile(theFileName);
        String legalLibName = TextUtils.getFileNameWithoutExtension(url);
        String fileName = url.getFile();
        File libFile = new File(fileName);
        String libFileName = libFile.getName();
        int backSlashPos = libFileName.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = libFileName.lastIndexOf(58), slashPos = libFileName.lastIndexOf(47)));
        if (charPos >= 0) {
            libFileName = libFileName.substring(charPos + 1);
        }
        String libName = libFileName;
        FileType preferredType = importType = OpenFile.getOpenFileType(libName, defaultType);
        if (libName.endsWith(".elib")) {
            libName = libName.substring(0, libName.length() - 5);
        } else if (libName.endsWith(".jelib")) {
            libName = libName.substring(0, libName.length() - 6);
        } else if (libName.endsWith(".txt")) {
            libName = libName.substring(0, libName.length() - 4);
        } else {
            libFileName = libFileName + "." + defaultType.getExtensions()[0];
        }
        Library elib = Library.findLibrary(legalLibName);
        if (elib != null) {
            return elib;
        }
        StringBuffer errmsg = new StringBuffer();
        URL externalURL = this.getLibrary(libName + "." + preferredType.getExtensions()[0], libFile.getParent(), errmsg, true);
        if (externalURL == null && preferredType != FileType.JELIB) {
            externalURL = this.getLibrary(libName + "." + FileType.JELIB.getExtensions()[0], libFile.getParent(), errmsg, true);
        }
        if (externalURL == null && preferredType != FileType.ELIB) {
            externalURL = this.getLibrary(libName + "." + FileType.ELIB.getExtensions()[0], libFile.getParent(), errmsg, true);
        }
        if (externalURL == null && preferredType != FileType.READABLEDUMP) {
            externalURL = this.getLibrary(libName + "." + FileType.READABLEDUMP.getExtensions()[0], libFile.getParent(), errmsg, true);
        }
        boolean bl = exists = externalURL != null;
        if (!exists) {
            String description;
            System.out.println("Error: cannot find referenced library " + libName + ":");
            System.out.print(errmsg.toString());
            String pt = null;
            while (!((pt = OpenFile.chooseInputFile(FileType.LIBFILE, description = "Reference library '" + libFileName + "'")) == null || (externalURL = TextUtils.makeURLToFile(pt)) != null && (exists = TextUtils.URLExists(externalURL, null)))) {
            }
        }
        if (exists) {
            System.out.println("Reading referenced library " + externalURL.getFile());
            importType = OpenFile.getOpenFileType(externalURL.getFile(), defaultType);
            elib = Library.newInstance(legalLibName, externalURL);
        }
        if (elib != null) {
            String oldNote = progress.getNote();
            if (progress != null) {
                progress.setProgress(0);
                progress.setNote("Reading referenced library " + legalLibName + "...");
            }
            String eLibName = TextUtils.getFileNameWithoutExtension(externalURL);
            elib = LibraryFiles.readALibrary(externalURL, elib, eLibName, importType);
            progress.setProgress((int)(this.byteCount * 100L / this.fileLength));
            progress.setNote(oldNote);
        }
        if (elib == null) {
            System.out.println("Error: cannot find referenced library " + libFile.getPath());
            System.out.println("...Creating new " + legalLibName + " Library instead");
            elib = Library.newInstance(legalLibName, null);
            elib.setLibFile(TextUtils.makeURLToFile(theFileName));
            elib.clearFromDisk();
        }
        return elib;
    }

    private URL getLibrary(String libFileName, String originalPath, StringBuffer errmsg, boolean checkElectricLib) {
        URL secondURL;
        URL url;
        URL firstURL = TextUtils.makeURLToFile(mainLibDirectory + libFileName);
        boolean exists = TextUtils.URLExists(firstURL, errmsg);
        if (exists) {
            return firstURL;
        }
        HashMap<String, String> searchedURLs = new HashMap<String, String>();
        Iterator libIt = LibDirs.getLibDirs();
        while (libIt.hasNext()) {
            url = TextUtils.makeURLToFile((String)libIt.next() + File.separator + libFileName);
            exists = TextUtils.URLExists(url, errmsg);
            if (exists) {
                return url;
            }
            if (url == null) continue;
            searchedURLs.put(url.getFile(), url.getFile());
        }
        URL thirdURL = TextUtils.makeURLToFile(System.getProperty("user.dir") + File.separator + libFileName);
        if (thirdURL != null && !searchedURLs.containsKey(thirdURL.getFile())) {
            exists = TextUtils.URLExists(thirdURL, errmsg);
            if (exists) {
                return thirdURL;
            }
            if (thirdURL != null) {
                searchedURLs.put(thirdURL.getFile(), thirdURL.getFile());
            }
        }
        if (originalPath != null && (secondURL = TextUtils.makeURLToFile(originalPath + File.separator + libFileName)) != null && !searchedURLs.containsKey(secondURL.getFile())) {
            exists = TextUtils.URLExists(secondURL, errmsg);
            if (exists) {
                return secondURL;
            }
            if (secondURL != null) {
                searchedURLs.put(secondURL.getFile(), secondURL.getFile());
            }
        }
        if (checkElectricLib && (exists = TextUtils.URLExists(url = LibFile.getLibFile(libFileName), errmsg))) {
            return url;
        }
        return null;
    }

    public static void cleanupLibraryInput() {
        Cell cell;
        Cell cell2;
        Cell cell3;
        int cellIndex;
        LibraryFiles reader;
        progress.setNote("Constructing cell contents...");
        progress.setProgress(0);
        HashSet<Cell> uncomputedCells = new HashSet<Cell>();
        Iterator it = libsBeingRead.iterator();
        while (it.hasNext()) {
            reader = (LibraryFiles)it.next();
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                uncomputedCells.add(cell3);
            }
        }
        it = libsBeingRead.iterator();
        while (it.hasNext()) {
            reader = (LibraryFiles)it.next();
            for (cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell3 = reader.nodeProtoList[cellIndex];
                if (cell3 == null || cell3.getLibrary() != reader.lib) continue;
                reader.computeTech(cell3, uncomputedCells);
            }
        }
        totalCells = 0;
        HashSet markCellForNodes = new HashSet();
        Iterator it2 = libsBeingRead.iterator();
        while (it2.hasNext()) {
            LibraryFiles reader2 = (LibraryFiles)it2.next();
            totalCells += reader2.nodeProtoCount;
            for (int cellIndex2 = 0; cellIndex2 < reader2.nodeProtoCount; ++cellIndex2) {
                cell2 = reader2.nodeProtoList[cellIndex2];
                if (cell2 == null || cell2.getLibrary() != reader2.lib) continue;
                reader2.cellLambda[cellIndex2] = reader2.computeLambda(cell2, cellIndex2);
                cell2.setTempInt(cellIndex2);
            }
        }
        cellsConstructed = 0;
        for (int i = 0; i < 20; ++i) {
            boolean unchanged = true;
            Iterator it3 = libsBeingRead.iterator();
            while (it3.hasNext()) {
                LibraryFiles reader3 = (LibraryFiles)it3.next();
                for (int cellIndex3 = 0; cellIndex3 < reader3.nodeProtoCount; ++cellIndex3) {
                    cell = reader3.nodeProtoList[cellIndex3];
                    if (cell == null || cell.getLibrary() != reader3.lib || !reader3.spreadLambda(cell, cellIndex3)) continue;
                    unchanged = false;
                }
            }
            if (unchanged) break;
        }
        it = libsBeingRead.iterator();
        while (it.hasNext()) {
            LibraryFiles reader4 = (LibraryFiles)it.next();
            for (int cellIndex4 = 0; cellIndex4 < reader4.nodeProtoCount; ++cellIndex4) {
                cell2 = reader4.nodeProtoList[cellIndex4];
                if (cell2 == null || markCellForNodes.contains(cell2)) continue;
                reader4.realizeCellsRecursively(cell2, markCellForNodes, null, 0.0);
            }
        }
        boolean first = true;
        Iterator it4 = libsBeingRead.iterator();
        while (it4.hasNext()) {
            LibraryFiles reader5 = (LibraryFiles)it4.next();
            if (reader5.scaledCells == null || reader5.scaledCells.size() == 0) continue;
            if (first) {
                System.out.println("WARNING: to accommodate scaling inconsistencies, these cells were created:");
                first = false;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("   Library " + reader5.lib.getName() + ":");
            Iterator sIt = reader5.scaledCells.iterator();
            while (sIt.hasNext()) {
                cell = (Cell)sIt.next();
                sb.append(" " + cell.noLibDescribe());
            }
            System.out.println(sb.toString());
        }
        it4 = Tool.getListeners();
        while (it4.hasNext()) {
            Listener listener = (Listener)it4.next();
            Iterator lIt = libsBeingRead.iterator();
            while (lIt.hasNext()) {
                LibraryFiles reader6 = (LibraryFiles)lIt.next();
                listener.readLibrary(reader6.lib);
            }
        }
        libsBeingRead.clear();
    }

    protected LibraryFiles getReaderForLib(Library lib) {
        Iterator it = libsBeingRead.iterator();
        while (it.hasNext()) {
            LibraryFiles reader = (LibraryFiles)it.next();
            if (reader.lib != lib) continue;
            return reader;
        }
        return null;
    }

    String convertCellName(String s) {
        StringBuffer buf = null;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\n' || ch == '|' || ch == ':') {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(s.substring(0, i));
                }
                buf.append('-');
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            String newS = buf.toString();
            System.out.println("Cell name " + s + " was converted to " + newS);
            return newS;
        }
        return s;
    }

    protected static String convertGeomName(Object value, boolean isDisplay) {
        if (value == null || !(value instanceof String)) {
            return null;
        }
        String str = (String)value;
        int indexOfAt = str.indexOf(64);
        if (isDisplay) {
            if (indexOfAt >= 0) {
                String newS = "";
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (c == '@') {
                        c = '_';
                    }
                    newS = newS + c;
                }
                str = newS;
            }
        } else if (indexOfAt < 0) {
            return null;
        }
        return str;
    }

    void realizeNode(NodeInstList nil, int nodeIndex, int xoff, int yoff, double lambda, Cell parent, NodeProto proto) {
        NodeInst ni;
        double lowX = nil.lowX[nodeIndex] - xoff;
        double lowY = nil.lowY[nodeIndex] - yoff;
        double highX = nil.highX[nodeIndex] - xoff;
        double highY = nil.highY[nodeIndex] - yoff;
        Point2D.Double center = new Point2D.Double((lowX + highX) / 2.0 / lambda, (lowY + highY) / 2.0 / lambda);
        double width = (highX - lowX) / lambda;
        double height = (highY - lowY) / lambda;
        if (proto instanceof Cell) {
            Cell subCell = (Cell)proto;
            Rectangle2D bounds = subCell.getBounds();
            width = bounds.getWidth();
            height = bounds.getHeight();
        }
        int rotation = nil.rotation[nodeIndex];
        boolean flipX = false;
        boolean flipY = false;
        if (this.rotationMirrorBits) {
            if ((nil.transpose[nodeIndex] & 1) != 0) {
                flipY = true;
                rotation = (rotation + 900) % 3600;
            }
            if ((nil.transpose[nodeIndex] & 2) != 0) {
                flipX = true;
            }
            if ((nil.transpose[nodeIndex] & 4) != 0) {
                flipY = !flipY;
            }
        } else if (nil.transpose[nodeIndex] != 0) {
            flipY = true;
            rotation = (rotation + 900) % 3600;
        }
        Orientation orient = Orientation.fromJava(rotation, flipX, flipY);
        if (proto instanceof Cell) {
            if (nil.anchorX != null) {
                double anchorX = (double)(nil.anchorX[nodeIndex] - xoff) / lambda;
                double anchorY = (double)(nil.anchorY[nodeIndex] - yoff) / lambda;
                ((Point2D)center).setLocation(anchorX, anchorY);
            } else {
                Cell subCell = (Cell)proto;
                Rectangle2D bounds = subCell.getBounds();
                Point2D.Double shift = new Point2D.Double(-bounds.getCenterX(), -bounds.getCenterY());
                AffineTransform trans = orient.pureRotate();
                trans.transform(shift, shift);
                ((Point2D)center).setLocation(((Point2D)center).getX() + ((Point2D)shift).getX(), ((Point2D)center).getY() + ((Point2D)shift).getY());
            }
        }
        int flags = ImmutableNodeInst.flagsFromElib(nil.userBits[nodeIndex]);
        int techBits = ImmutableNodeInst.techSpecificFromElib(nil.userBits[nodeIndex]);
        nil.theNode[nodeIndex] = ni = NodeInst.newInstance(parent, proto, nil.name[nodeIndex], -1, nil.nameTextDescriptor[nodeIndex], center, width, height, orient, flags, techBits, nil.protoTextDescriptor[nodeIndex]);
        if (ni == null) {
            return;
        }
        ImmutableVariable[] vars = nil.vars[nodeIndex];
        if (vars != null) {
            for (int j = 0; j < vars.length; ++j) {
                Object value;
                ImmutableVariable vd = vars[j];
                if (vd == null) continue;
                if (vd.key == NodeInst.TRACE && proto instanceof PrimitiveNode && ((PrimitiveNode)proto).isHoldsOutline() && ((value = vd.getValue()) instanceof Integer[] || value instanceof Float[])) {
                    Number[] outline = (Number[])value;
                    int newLength = outline.length / 2;
                    Point2D[] newOutline = new Point2D[newLength];
                    double lam = outline instanceof Integer[] ? lambda : 1.0;
                    for (int k = 0; k < newLength; ++k) {
                        double oldX = outline[k * 2].doubleValue() / lam;
                        double oldY = outline[k * 2 + 1].doubleValue() / lam;
                        newOutline[k] = new EPoint(oldX, oldY);
                    }
                    vd = vd.withValue(newOutline);
                }
                if (ni.isDeprecatedVariable(vd.key)) continue;
                ni.newVar(vd);
            }
        }
        if (proto instanceof Cell && ((Cell)proto).getVar(IO_DUMMY_OBJECT) != null) {
            ErrorLogger.MessageLog error = Input.errorLogger.logError("Instance of dummy cell " + proto.getName(), parent, 1);
            error.addGeom(ni, true, parent, null);
        }
    }

    void realizeVariables(ElectricObject eObj, ImmutableVariable[] vars) {
        if (vars == null) {
            return;
        }
        for (int i = 0; i < vars.length; ++i) {
            ImmutableVariable vd = vars[i];
            if (vd == null || eObj.isDeprecatedVariable(vd.key)) continue;
            eObj.newVar(vd);
        }
    }

    void realizeMeaningPrefs(Object obj, ImmutableVariable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            String varName;
            Pref.Meaning meaning;
            ImmutableVariable vd = vars[i];
            if (vd == null) continue;
            Object value = vd.getValue();
            if (!(value instanceof String)) {
                if (value instanceof Short || value instanceof Byte) {
                    value = new Integer(((Number)value).intValue());
                }
                if (!(value instanceof Number)) continue;
            }
            if ((meaning = Pref.getMeaningVariable(obj, varName = vd.key.getName())) != null) {
                Pref.changedMeaningVariable(meaning, value);
                continue;
            }
            if (obj instanceof Technology && ((Technology)obj).convertOldVariable(varName, value)) continue;
        }
    }

    ImmutableTextDescriptor makeDescriptor(int td0, int td1) {
        this.mtd.setCBits(td0, this.fixTextDescriptorFont(td1));
        return ImmutableTextDescriptor.newImmutableTextDescriptor(this.mtd);
    }

    ImmutableTextDescriptor makeDescriptor(int td0, int td1, int flags) {
        this.mtd.setCBits(td0, this.fixTextDescriptorFont(td1), flags);
        return ImmutableTextDescriptor.newImmutableTextDescriptor(this.mtd);
    }

    void setFontNames(String[] associationArray) {
        int fontNumber;
        int i;
        int maxAssociation = 0;
        for (i = 0; i < associationArray.length; ++i) {
            if (associationArray[i] == null || (fontNumber = TextUtils.atoi(associationArray[i])) <= maxAssociation) continue;
            maxAssociation = fontNumber;
        }
        if (maxAssociation <= 0) {
            return;
        }
        this.fontNames = new String[maxAssociation];
        for (i = 0; i < maxAssociation; ++i) {
            this.fontNames[i] = null;
        }
        for (i = 0; i < associationArray.length; ++i) {
            int slashPos;
            if (associationArray[i] == null || (fontNumber = TextUtils.atoi(associationArray[i])) <= 0 || (slashPos = associationArray[i].indexOf(47)) < 0) continue;
            this.fontNames[fontNumber - 1] = associationArray[i].substring(slashPos + 1);
        }
    }

    private int fixTextDescriptorFont(int descriptor1) {
        String fontName;
        TextDescriptor.ActiveFont af;
        int fontNumber = (descriptor1 & 0x3F8000) >> 15;
        if (fontNumber == 0) {
            return descriptor1;
        }
        descriptor1 &= 0xFFC07FFF;
        if (this.fontNames != null && fontNumber <= this.fontNames.length && (af = TextDescriptor.ActiveFont.findActiveFont(fontName = this.fontNames[fontNumber - 1])) != null && (fontNumber = af.getIndex()) <= 127) {
            descriptor1 |= fontNumber << 15;
        }
        return descriptor1;
    }

    void setLineNumber(int lineNumber) {
    }

    ErrorLogger.MessageLog logError(String message) {
        ++this.errorCount;
        System.out.println(message);
        return errorLogger.logError(message, null, -1);
    }

    ErrorLogger.MessageLog logWarning(String message) {
        System.out.println(message);
        return errorLogger.logWarning(message, null, -1);
    }

    protected void computeTech(Cell cell, Set uncomputedCells) {
        uncomputedCells.remove(cell);
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        return 1.0;
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        return false;
    }

    protected boolean canScale() {
        return false;
    }

    abstract void realizeCellsRecursively(Cell var1, HashSet var2, String var3, double var4);

    static {
        $assertionsDisabled = !LibraryFiles.class.desiredAssertionStatus();
        IO_TRUE_LIBRARY = Variable.newKey("IO_true_library");
        IO_DUMMY_OBJECT = Variable.newKey("IO_dummy_object");
        mainLibDirectory = null;
        TINYDISTANCE = DBMath.getEpsilon() * 2.0;
    }

    static class NodeInstList {
        NodeInst[] theNode;
        NodeProto[] protoType;
        String[] name;
        ImmutableTextDescriptor[] nameTextDescriptor;
        int[] lowX;
        int[] highX;
        int[] lowY;
        int[] highY;
        int[] anchorX;
        int[] anchorY;
        short[] rotation;
        int[] transpose;
        ImmutableTextDescriptor[] protoTextDescriptor;
        int[] userBits;
        ImmutableVariable[][] vars;

        NodeInstList(int nodeCount, boolean hasAnchor) {
            this.theNode = new NodeInst[nodeCount];
            this.protoType = new NodeProto[nodeCount];
            this.name = new String[nodeCount];
            this.nameTextDescriptor = new ImmutableTextDescriptor[nodeCount];
            this.lowX = new int[nodeCount];
            this.highX = new int[nodeCount];
            this.lowY = new int[nodeCount];
            this.highY = new int[nodeCount];
            if (hasAnchor) {
                this.anchorX = new int[nodeCount];
                this.anchorY = new int[nodeCount];
            }
            this.rotation = new short[nodeCount];
            this.transpose = new int[nodeCount];
            this.protoTextDescriptor = new ImmutableTextDescriptor[nodeCount];
            this.userBits = new int[nodeCount];
            this.vars = new ImmutableVariable[nodeCount][];
        }
    }
}

