/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.ELIB1;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JELIB1;
import com.sun.electric.tool.io.input.LibraryContents;
import com.sun.electric.tool.io.output.Output;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class LibraryStatistics
implements Serializable {
    private static final long serialVersionUID = -361650802811567400L;
    private TreeMap directories = new TreeMap();
    private TreeMap libraryNames = new TreeMap();
    transient LibraryContents totalLibraryContents;
    transient VarStat varStat = new VarStat();
    static /* synthetic */ Class class$com$sun$electric$tool$io$input$LibraryStatistics;

    private LibraryStatistics() {
    }

    Directory getDirectory(String dirName) {
        Directory dir = (Directory)this.directories.get(dirName);
        if (dir == null) {
            dir = new Directory(this, dirName);
        }
        return dir;
    }

    LibraryName getLibraryName(String name) {
        LibraryName libraryName = (LibraryName)this.libraryNames.get(name);
        if (libraryName == null) {
            libraryName = new LibraryName(this, name);
        }
        return libraryName;
    }

    Iterator getDirectories() {
        return this.directories.values().iterator();
    }

    Iterator getLibraryNames() {
        return this.libraryNames.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibraryStatistics scanDirectories(String[] dirNames) {
        LibraryStatistics stat = new LibraryStatistics();
        HashSet canonicalDirs = new HashSet();
        HashMap preLibraries = new HashMap();
        for (int i = 0; i < dirNames.length; ++i) {
            stat.scanDir(new File(dirNames[i]), canonicalDirs, preLibraries);
        }
        byte[] buf = new byte[65536];
        Iterator lit = preLibraries.entrySet().iterator();
        while (lit.hasNext()) {
            Map.Entry entry = lit.next();
            String libName = (String)entry.getKey();
            TreeSet files = (TreeSet)entry.getValue();
            LibraryName libraryName = new LibraryName(stat, libName);
            while (!files.isEmpty()) {
                FileInstance f = (FileInstance)files.iterator().next();
                files.remove(f);
                FileContents fc = new FileContents(libraryName, f);
                byte[] bytes = null;
                int len = (int)f.fileLength;
                Iterator it = files.iterator();
                block14: while (it.hasNext()) {
                    FileInstance f1 = (FileInstance)it.next();
                    if (f1.fileLength != (long)len || f1.crc != f.crc) continue;
                    if (!f.canonicalPath.equals(f1.canonicalPath)) {
                        Input in;
                        if (bytes == null) {
                            in = new Input();
                            if (in.openBinaryInput(TextUtils.makeURLToFile(f1.fileName))) continue;
                            try {
                                bytes = new byte[len];
                                try {
                                    in.dataInputStream.readFully(bytes);
                                }
                                catch (IOException e) {
                                    in.closeInput();
                                    continue;
                                }
                                in.closeInput();
                            }
                            catch (Throwable throwable) {
                                in.closeInput();
                                throw throwable;
                            }
                        }
                        if ((in = new Input()).openBinaryInput(TextUtils.makeURLToFile(f1.fileName))) continue;
                        try {
                            int count;
                            for (int n = 0; n < len; n += count) {
                                count = -1;
                                try {
                                    count = in.dataInputStream.read(buf, 0, Math.min(len - n, buf.length));
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                if (count < 0) continue block14;
                                for (int i = 0; i < count; ++i) {
                                    if (buf[i] == bytes[n + i]) continue;
                                    in.closeInput();
                                    continue block14;
                                }
                            }
                        }
                        finally {
                            in.closeInput();
                            continue;
                        }
                    }
                    it.remove();
                    fc.add(f1);
                }
            }
        }
        return stat;
    }

    private void scanDir(File dir, Set canonicalDirs, Map preLibraries) {
        int i;
        try {
            String canonicalDir = dir.getCanonicalPath();
            if (canonicalDirs.contains(canonicalDir)) {
                return;
            }
            canonicalDirs.add(canonicalDir);
            dir = new File(canonicalDir);
        }
        catch (IOException e) {
            System.out.println(dir + " CANONICAL FAILED");
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.println(dir + " ACCESS DENIED");
            return;
        }
        boolean libFound = false;
        for (i = 0; i < files.length; ++i) {
            int extensionPos;
            String name;
            if (files[i].isDirectory() || (name = files[i].getName()).startsWith("._") || (extensionPos = name.lastIndexOf(46)) < 0) continue;
            String extension = name.substring(extensionPos);
            name = name.substring(0, extensionPos);
            if (!extension.equals(".elib") && !extension.equals(".jelib")) continue;
            if (!libFound) {
                System.out.println(dir.toString());
                libFound = true;
            }
            String strippedName = LibraryStatistics.stripBackup(name);
            try {
                FileInstance f = new FileInstance(this, files[i].toString());
                TreeSet<FileInstance> libFiles = (TreeSet<FileInstance>)preLibraries.get(strippedName);
                if (libFiles == null) {
                    libFiles = new TreeSet<FileInstance>();
                    preLibraries.put(strippedName, libFiles);
                }
                libFiles.add(f);
                continue;
            }
            catch (IOException e) {
                System.out.println(files[i] + " FAILED " + e);
            }
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.scanDir(files[i], canonicalDirs, preLibraries);
        }
    }

    public void readHeaders() {
        Iterator lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = (LibraryName)lit.next();
            Iterator it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = (FileContents)it.next();
                if (!fc.isElib()) continue;
                String fileName = fc.fileName();
                URL fileURL = TextUtils.makeURLToFile(fileName);
                fc.header = ELIB1.readLibraryHeader(fileURL);
                if (fc.header != null) continue;
                System.out.println(fileName + " INVALID HEADER");
            }
        }
    }

    public void readLibraries() {
        this.totalLibraryContents = new LibraryContents("noname", new JELIB1());
        Iterator lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = (LibraryName)lit.next();
            Iterator it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = (FileContents)it.next();
                if (!fc.isElib()) continue;
                String fileName = fc.fileName();
                URL fileURL = TextUtils.makeURLToFile(fileName);
                ELIB1.readLibraryStat(fc, this);
                if (fc.header != null) continue;
                System.out.println(fileName + " INVALID HEADER");
            }
        }
        Iterator it = this.totalLibraryContents.variableKeyRefs.values().iterator();
        while (it.hasNext()) {
            String v = ((LibraryContents.VariableKeyRef)it.next()).getName();
            String s = (String)this.varStat.varNamePool.get(v);
            if (s != null) continue;
            this.varStat.varNamePool.put(v, v);
        }
    }

    public void writeList(String fileName) {
        try {
            new StatisticsOutput(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatistics to " + fileName + " " + e);
        }
    }

    public static LibraryStatistics readList(String fileName) {
        System.out.println(ObjectStreamClass.lookup(VarStat.class).getSerialVersionUID());
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInput in = new StatisticsInput(fileURL);
            return in.stat;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    public void writeSerialized(String fileName) {
        try {
            new StatisticsOutputSerialized(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatistics to " + fileName + " " + e);
        }
    }

    public static LibraryStatistics readSerialized(String fileName) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInputSerialized in = new StatisticsInputSerialized(fileURL);
            return in.stat;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    public void reportFileLength() {
        int elibUniqueCount = 0;
        int jelibUniqueCount = 0;
        int elibCount = 0;
        int jelibCount = 0;
        long elibUniqueLength = 0L;
        long jelibUniqueLength = 0L;
        long elibLength = 0L;
        long jelibLength = 0L;
        TreeMap headerCounts = new TreeMap();
        int withoutHeader = 0;
        Iterator lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = (LibraryName)lit.next();
            Iterator it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = (FileContents)it.next();
                if (fc.isElib()) {
                    ++elibUniqueCount;
                    elibCount += fc.instances.size();
                    elibUniqueLength += fc.fileLength;
                    elibLength += fc.fileLength * (long)fc.instances.size();
                    if (fc.header != null) {
                        GenMath.addToBag(headerCounts, fc.header);
                        continue;
                    }
                    ++withoutHeader;
                    continue;
                }
                ++jelibUniqueCount;
                jelibCount += fc.instances.size();
                jelibUniqueLength += fc.fileLength;
                jelibLength += fc.fileLength * (long)fc.instances.size();
            }
        }
        System.out.println("Scanned " + this.directories.size() + " directories. " + this.libraryNames.size() + " library names");
        System.out.println((elibUniqueLength >> 20) + "M (" + elibUniqueLength + ") in " + elibUniqueCount + " ELIB files ( unique )");
        System.out.println((elibLength >> 20) + "M (" + elibLength + ") in " + elibCount + " ELIB files ( with duplicates )");
        System.out.println((jelibUniqueLength >> 20) + "M (" + jelibUniqueLength + ") in " + jelibUniqueCount + " JELIB files ( unique )");
        System.out.println((jelibLength >> 20) + "M (" + jelibLength + ") in " + jelibCount + " JELIB files ( with duplicates )");
        System.out.println("NOHEADER:" + withoutHeader + LibraryStatistics.bagReport(headerCounts));
    }

    public void reportMemoryUsage() {
        int elibCount = 0;
        int elibWithHeader = 0;
        int elibOk = 0;
        int toolCount = 0;
        int techCount = 0;
        int primNodeProtoCount = 0;
        int primPortProtoCount = 0;
        int arcProtoCount = 0;
        int nodeProtoCount = 0;
        int nodeInstCount = 0;
        int portProtoCount = 0;
        int arcInstCount = 0;
        int geomCount = 0;
        int cellCount = 0;
        int userBits = 0;
        int viewCount = 0;
        long nameLength = 0L;
        int varNameCount = 0;
        long varNameLength = 0L;
        long bytesRead = 0L;
        long fileLength = 0L;
        Iterator lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = (LibraryName)lit.next();
            Iterator it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = (FileContents)it.next();
                if (!fc.isElib()) continue;
                ++elibCount;
                if (fc.header == null) continue;
                ++elibWithHeader;
                if (!fc.readOk) continue;
                ++elibOk;
                toolCount += fc.toolCount;
                techCount += fc.techCount;
                primNodeProtoCount += fc.primNodeProtoCount;
                primPortProtoCount += fc.primPortProtoCount;
                arcProtoCount += fc.arcProtoCount;
                nodeProtoCount += fc.nodeProtoCount;
                nodeInstCount += fc.nodeInstCount;
                portProtoCount += fc.portProtoCount;
                arcInstCount += fc.arcInstCount;
                geomCount += fc.geomCount;
                cellCount += fc.cellCount;
                userBits |= fc.userBits;
                viewCount += fc.viewCount;
                nameLength += (long)fc.nameLength;
                varNameCount += fc.varNameCount;
                varNameLength += (long)fc.varNameLength;
                bytesRead += (long)fc.bytesRead;
                fileLength += fc.fileLength;
            }
        }
        System.out.println("elibCount=" + elibCount);
        System.out.println("elibWithHeader=" + elibWithHeader);
        System.out.println("elibOk=" + elibOk);
        System.out.println("toolCount=" + toolCount);
        System.out.println("techCount=" + techCount);
        System.out.println("primNodeProtoCount=" + primNodeProtoCount);
        System.out.println("primPortProtoCount=" + primPortProtoCount);
        System.out.println("arcProtoCount=" + arcProtoCount);
        System.out.println("nodeProtoCount=" + nodeProtoCount);
        System.out.println("nodeInstCount=" + nodeInstCount);
        System.out.println("portProtoCount=" + portProtoCount);
        System.out.println("arcInstCount=" + arcInstCount);
        System.out.println("geomCount=" + geomCount);
        System.out.println("cellCount=" + cellCount);
        System.out.println("userBits=" + userBits);
        System.out.println("viewCount=" + viewCount);
        System.out.println("nameLength=" + nameLength);
        System.out.println("varNameCount=" + varNameCount);
        System.out.println("varNameLength=" + varNameLength);
        System.out.println("bytesRead=" + bytesRead);
        System.out.println("fileLength=" + fileLength);
    }

    public void reportJelib(String fileName) {
        if (this.totalLibraryContents == null) {
            return;
        }
        try {
            new StatisticsOutputJelib(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatisticsJelib to " + fileName + " " + e);
        }
    }

    public void reportVariableNames(String fileName) {
        if (this.totalLibraryContents == null) {
            return;
        }
        try {
            new StatisticsOutputVariableNames(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatisticsVariableNames to " + fileName + " " + e);
        }
    }

    public static VarStat readVariableNames(String fileName) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInputVariableNames in = new StatisticsInputVariableNames(fileURL);
            long totalVars = 0L;
            long[] typeCounts = new long[32];
            long[] typeTotals = new long[32];
            TreeMap charCount = new TreeMap();
            TreeMap charTotal = new TreeMap();
            TreeMap bitsCount = new TreeMap();
            TreeMap bitsTotal = new TreeMap();
            Iterator it = ((StatisticsInputVariableNames)in).vs.varBag.values().iterator();
            while (it.hasNext()) {
                VarDesc vd = (VarDesc)it.next();
                Character character = new Character(vd.role.charAt(0));
                GenMath.addToBag(charCount, character);
                GenMath.addToBag(charTotal, character, vd.count);
                VarDesc vd1 = new VarDesc();
                vd1.role = "";
                vd1.varName = "";
                vd1.varBits = Character.isUpperCase(vd.role.charAt(0)) ? vd.varBits & 0xE00001FF : 68;
                vd1.td0 = vd.td0;
                vd1.td1 = vd.td1;
                GenMath.addToBag(bitsCount, vd1);
                GenMath.addToBag(bitsTotal, vd1, vd.count);
                totalVars += (long)vd.count;
                int n = vd.varBits & 0x1F;
                typeCounts[n] = typeCounts[n] + 1L;
                int n2 = vd.varBits & 0x1F;
                typeTotals[n2] = typeTotals[n2] + (long)vd.count;
                if ((vd.varBits & 0x1F) == 7) {
                    System.out.println("VNODEINST " + vd.role + " " + vd.varName);
                }
                if ((vd.varBits & 0x1F) == 8) {
                    System.out.println("VNODEPROTO " + vd.role + " " + vd.varName);
                }
                if ((vd.varBits & 0x20000020) == 0) continue;
                System.out.println(Integer.toOctalString(vd.varBits) + " " + vd.role + " " + vd.varName);
            }
            System.out.println(((StatisticsInputVariableNames)in).vs.varBag.size() + " bag: " + LibraryStatistics.bagReport(charCount));
            System.out.println(totalVars + "bagTotal: " + LibraryStatistics.bagReport(charTotal));
            for (int i = 0; i < 32; ++i) {
                System.out.println(Integer.toOctalString(i) + " " + typeCounts[i] + " " + typeTotals[i]);
            }
            Iterator it2 = bitsCount.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                VarDesc vd = (VarDesc)entry.getKey();
                System.out.println(vd.role + " " + Integer.toOctalString(vd.varBits) + " " + Integer.toOctalString(vd.td0) + " " + Integer.toOctalString(vd.td1) + " " + GenMath.countInBag(bitsCount, vd) + " " + GenMath.countInBag(bitsTotal, vd));
            }
            System.out.println(bitsCount.size() + " variable descriptors");
            return in.vs;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    private static String stripBackup(String libName) {
        int i;
        for (i = libName.length(); i > 0 && Character.isDigit(libName.charAt(i - 1)); --i) {
        }
        if (i == libName.length()) {
            return libName;
        }
        if (i > 3 && libName.charAt(i - 1) == '-' && libName.charAt(i - 2) == '-' && Character.isDigit(libName.charAt(i - 3))) {
            i -= 3;
            while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
                --i;
            }
        }
        if (i < 2 || libName.charAt(i - 1) != '-' || !Character.isDigit(libName.charAt(i - 2))) {
            return libName;
        }
        i -= 2;
        while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
            --i;
        }
        if (i < 2 || libName.charAt(i - 1) != '-' || !Character.isDigit(libName.charAt(i - 2))) {
            return libName;
        }
        i -= 2;
        while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
            --i;
        }
        if (i < 1 || libName.charAt(i - 1) != '-') {
            return libName;
        }
        return libName.substring(0, i - 1);
    }

    static String bagReport(Map bag) {
        String s = "";
        Iterator it = bag.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            GenMath.MutableInteger count = (GenMath.MutableInteger)e.getValue();
            s = s + " " + e.getKey() + ":" + count.intValue();
        }
        return s;
    }

    private class StatisticsOutputVariableNames
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutputVariableNames(String filePath) throws IOException {
            if (this.openBinaryOutputStream(filePath)) {
                throw new IOException("openStatisticsOutputSerialized");
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.dataOutputStream);
                objectOutputStream.writeObject(LibraryStatistics.this.varStat);
                objectOutputStream.close();
                int total = 0;
                Iterator it = LibraryStatistics.this.varStat.varBag.values().iterator();
                while (it.hasNext()) {
                    total += ((VarDesc)it.next()).count;
                }
                System.out.println(LibraryStatistics.this.varStat.varBag.size() + " (" + total + ") variable descriptors");
            }
            finally {
                this.closeBinaryOutputStream();
            }
        }
    }

    private static class StatisticsInputVariableNames
    extends Input {
        private VarStat vs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInputVariableNames(URL url) throws IOException {
            if (this.openBinaryInput(url)) {
                throw new IOException("openStatisticsInputVariableNames");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.dataInputStream);
                try {
                    this.vs = (VarStat)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            finally {
                this.closeInput();
            }
        }
    }

    static class VarStat
    implements Serializable {
        private static final long serialVersionUID = -2536836777200853733L;
        TreeMap varNamePool = new TreeMap();
        TreeMap varBag = new TreeMap();
        TreeMap userBitsBag = new TreeMap();
        transient TreeMap otherStrings = new TreeMap();
        transient VarDesc dummyVarDesc = new VarDesc();
        transient UserBits dummyUserBits = new UserBits();

        VarStat() {
        }

        String getVarName(String name) {
            String v = (String)this.varNamePool.get(name);
            if (v == null) {
                v = name;
                this.varNamePool.put(v, v);
            }
            return v;
        }

        void addVarDesc(String varName, int varBits, int td0, int td1, String role) {
            this.dummyVarDesc.varName = varName;
            this.dummyVarDesc.varBits = varBits;
            this.dummyVarDesc.td0 = td0;
            this.dummyVarDesc.td1 = td1 &= 0xFFC07FFF;
            this.dummyVarDesc.role = role;
            VarDesc v = (VarDesc)this.varBag.get(this.dummyVarDesc);
            if (v == null) {
                v = new VarDesc();
                v.varName = this.getVarName(varName);
                v.varBits = varBits;
                v.td0 = td0;
                v.td1 = td1;
                v.role = (String)this.otherStrings.get(role);
                if (v.role == null) {
                    v.role = role;
                    this.otherStrings.put(role, role);
                }
                this.varBag.put(v, v);
            }
            ++v.count;
        }

        void addUserBits(int userBits, String role) {
            this.dummyUserBits.bits = userBits;
            this.dummyUserBits.role = role;
            UserBits u = (UserBits)this.userBitsBag.get(this.dummyUserBits);
            if (u == null) {
                u = new UserBits();
                u.bits = userBits;
                u.role = (String)this.otherStrings.get(role);
                if (u.role == null) {
                    u.role = role;
                    this.otherStrings.put(role, role);
                }
                this.userBitsBag.put(u, u);
            }
            ++u.count;
        }
    }

    static class UserBits
    implements Serializable,
    Comparable {
        String role;
        int bits;
        int count;

        UserBits() {
        }

        public int compareTo(Object o) {
            UserBits u = (UserBits)o;
            int cmp = this.role.compareTo(u.role);
            if (cmp != 0) {
                return cmp;
            }
            if (this.bits > u.bits) {
                return 1;
            }
            if (this.bits < u.bits) {
                return -1;
            }
            return 0;
        }
    }

    static class VarDesc
    implements Serializable,
    Comparable {
        String role;
        String varName;
        int varBits;
        int td0;
        int td1;
        int count;

        VarDesc() {
        }

        public int compareTo(Object o) {
            VarDesc v = (VarDesc)o;
            int cmp = this.role.compareTo(v.role);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.varName.compareTo(v.varName);
            if (cmp != 0) {
                return cmp;
            }
            if (this.varBits > v.varBits) {
                return 1;
            }
            if (this.varBits < v.varBits) {
                return -1;
            }
            if (this.td0 > v.td0) {
                return 1;
            }
            if (this.td0 < v.td0) {
                return -1;
            }
            if (this.td1 > v.td1) {
                return 1;
            }
            if (this.td1 < v.td1) {
                return -1;
            }
            return 0;
        }
    }

    private class StatisticsOutputJelib
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutputJelib(String filePath) throws IOException {
            if (this.openTextOutputStream(filePath)) {
                throw new IOException("openStatisticsOutputSerialized");
            }
            try {
                LibraryStatistics.this.totalLibraryContents.printJelib(this.printWriter);
            }
            finally {
                this.closeTextOutputStream();
            }
        }
    }

    private class StatisticsOutputSerialized
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutputSerialized(String filePath) throws IOException {
            if (this.openBinaryOutputStream(filePath)) {
                throw new IOException("openStatisticsOutputSerialized");
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.dataOutputStream);
                objectOutputStream.writeObject(LibraryStatistics.this);
                objectOutputStream.close();
            }
            finally {
                this.closeBinaryOutputStream();
            }
        }
    }

    private static class StatisticsInputSerialized
    extends Input {
        private LibraryStatistics stat;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInputSerialized(URL url) throws IOException {
            if (this.openBinaryInput(url)) {
                throw new IOException("openStatisticsInputSerialized");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.dataInputStream);
                try {
                    this.stat = (LibraryStatistics)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            finally {
                this.closeInput();
            }
        }
    }

    private class StatisticsOutput
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutput(String filePath) throws IOException {
            if (this.openTextOutputStream(filePath)) {
                throw new IOException("openStatisticsOutput");
            }
            try {
                Iterator lit = LibraryStatistics.this.getLibraryNames();
                while (lit.hasNext()) {
                    LibraryName libraryName = (LibraryName)lit.next();
                    this.printWriter.println(libraryName.getName());
                    Iterator it = libraryName.getVersions();
                    while (it.hasNext()) {
                        FileContents fc = (FileContents)it.next();
                        Date date = new Date(fc.lastModified);
                        this.printWriter.println("    " + fc.fileLength + " " + Long.toHexString(fc.crc) + " " + TextUtils.formatDatePST(date));
                        Iterator fit = fc.instances.iterator();
                        while (fit.hasNext()) {
                            FileInstance f = (FileInstance)fit.next();
                            date = new Date(f.lastModified);
                            this.printWriter.println("        " + f.fileName + " " + f.lastModified + " " + TextUtils.formatDatePST(date));
                        }
                    }
                }
            }
            finally {
                this.closeTextOutputStream();
            }
        }
    }

    private static class StatisticsInput
    extends Input {
        private LibraryStatistics stat;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInput(URL url) throws IOException {
            block19: {
                if (this.openTextInput(url)) {
                    throw new IOException("openStatisticsInput");
                }
                try {
                    String line;
                    this.stat = new LibraryStatistics();
                    LibraryName libraryName = null;
                    long fileLength = 0L;
                    long crc = 0L;
                    FileContents fc = null;
                    while (true) {
                        if ((line = this.lineReader.readLine()) == null) {
                            break block19;
                        }
                        if (line.length() == 0) continue;
                        if (line.charAt(0) != ' ') {
                            libraryName = this.stat.getLibraryName(line);
                            continue;
                        }
                        if (line.startsWith("        ")) {
                            long lastModified;
                            String timeString;
                            String fileName;
                            int indexElib = line.lastIndexOf(".elib");
                            int indexJelib = line.lastIndexOf(".jelib");
                            if (indexElib >= 0) {
                                fileName = line.substring(8, indexElib + 5);
                                timeString = line.substring(indexElib + 5);
                            } else if (indexJelib >= 0) {
                                fileName = line.substring(8, indexJelib + 6);
                                timeString = line.substring(indexJelib + 6);
                            } else {
                                throw new IOException("Library extension: " + line);
                            }
                            String[] pieces = timeString.split(" +");
                            try {
                                lastModified = Long.parseLong(pieces[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new IOException("lastModified:" + pieces[1]);
                            }
                            FileInstance f = new FileInstance(this.stat, fileName, fileLength, lastModified, crc);
                            if (fc == null) {
                                fc = new FileContents(libraryName, f);
                                continue;
                            }
                            fc.add(f);
                            continue;
                        }
                        if (!line.startsWith("    ")) break;
                        String[] pieces = line.split(" +");
                        try {
                            fileLength = Long.parseLong(pieces[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("fileLength: " + pieces[1]);
                        }
                        try {
                            crc = Long.parseLong(pieces[2], 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("crc: " + pieces[2]);
                        }
                        fc = null;
                    }
                    throw new IOException("bad line:" + line);
                }
                finally {
                    this.closeInput();
                }
            }
        }
    }

    private static class FileInstance
    implements Comparable,
    Serializable {
        private FileContents contents;
        private String fileName;
        private long fileLength;
        private long crc;
        private long lastModified;
        transient String canonicalPath;

        private FileInstance(LibraryStatistics stat, String fileName, long fileLength, long lastModified, long crc) {
            this.fileName = fileName;
            this.fileLength = fileLength;
            this.lastModified = lastModified;
            this.crc = crc;
            File file = new File(fileName);
            stat.getDirectory(file.getParent()).files.put(file.getName(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileInstance(LibraryStatistics stat, String fileName) throws IOException {
            File file = new File(fileName);
            this.fileName = fileName;
            this.canonicalPath = file.getCanonicalPath();
            this.fileLength = file.length();
            this.lastModified = file.lastModified();
            URL fileURL = TextUtils.makeURLToFile(fileName);
            Input in = new Input();
            try {
                if (in.openBinaryInput(fileURL)) {
                    throw new IOException("openBytesInput");
                }
                CheckedInputStream checkedInputStream = new CheckedInputStream(in.dataInputStream, new CRC32());
                if (checkedInputStream.skip(this.fileLength) != this.fileLength) {
                    throw new IOException("skip failed");
                }
                this.crc = checkedInputStream.getChecksum().getValue();
            }
            finally {
                in.closeInput();
            }
            stat.getDirectory(file.getParent()).files.put(file.getName(), this);
        }

        public int compareTo(Object o) {
            FileInstance f = (FileInstance)o;
            if (this.lastModified > f.lastModified) {
                return 1;
            }
            if (this.lastModified < f.lastModified) {
                return -1;
            }
            return this.fileName.compareTo(f.fileName);
        }
    }

    static class FileContents
    implements Serializable {
        LibraryName libraryName;
        long fileLength;
        long crc;
        long lastModified;
        List instances = new ArrayList();
        TreeMap uses = new TreeMap();
        ELIB1.Header header;
        boolean readOk;
        int toolCount;
        int techCount;
        int primNodeProtoCount;
        int primPortProtoCount;
        int arcProtoCount;
        int nodeProtoCount;
        int nodeInstCount;
        int portProtoCount;
        int arcInstCount;
        int geomCount;
        int cellCount;
        int userBits;
        int viewCount;
        int nameLength;
        int varNameCount;
        int varNameLength;
        int bytesRead;
        static final /* synthetic */ boolean $assertionsDisabled;

        private FileContents(LibraryName libraryName, FileInstance f) {
            this.libraryName = libraryName;
            libraryName.versions.add(this);
            this.fileLength = f.fileLength;
            this.crc = f.crc;
            this.lastModified = f.lastModified;
            f.contents = this;
            this.instances.add(f);
        }

        void add(FileInstance f) {
            if (!($assertionsDisabled || f.fileLength == this.fileLength && f.crc == this.crc)) {
                throw new AssertionError();
            }
            f.contents = this;
            this.instances.add(f);
            if (f.lastModified < this.lastModified) {
                this.lastModified = f.lastModified;
            }
        }

        String fileName() {
            return ((FileInstance)this.instances.get(0)).fileName;
        }

        boolean isElib() {
            return this.fileName().endsWith(".elib");
        }

        static {
            $assertionsDisabled = !(class$com$sun$electric$tool$io$input$LibraryStatistics == null ? (class$com$sun$electric$tool$io$input$LibraryStatistics = LibraryStatistics.class$("com.sun.electric.tool.io.input.LibraryStatistics")) : class$com$sun$electric$tool$io$input$LibraryStatistics).desiredAssertionStatus();
        }
    }

    private static class LibraryUse
    implements Serializable {
        Directory dir;
        LibraryName libName;
        String fullName;
        FileContents from;

        private LibraryUse() {
        }
    }

    private static class LibraryName
    implements Serializable {
        String name;
        List versions = new ArrayList();
        TreeMap references;

        LibraryName(LibraryStatistics stat, String name) {
            this.name = name;
            stat.libraryNames.put(name, this);
        }

        String getName() {
            return this.name;
        }

        Iterator getVersions() {
            return this.versions.iterator();
        }
    }

    private static class Directory
    implements Serializable {
        private String dirName;
        private TreeMap files = new TreeMap();

        Directory(LibraryStatistics stat, String dirName) {
            this.dirName = dirName;
            stat.directories.put(dirName, this);
        }

        String getName() {
            return this.dirName;
        }

        Iterator gerFiles() {
            return this.files.values().iterator();
        }
    }
}

