/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/k3s-io/k3s/pkg/apis/k3s.cattle.io/v1"
	k3scattleiov1 "github.com/k3s-io/k3s/pkg/generated/clientset/versioned/typed/k3s.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeAddons implements AddonInterface
type fakeAddons struct {
	*gentype.FakeClientWithList[*v1.Addon, *v1.AddonList]
	Fake *FakeK3sV1
}

func newFakeAddons(fake *FakeK3sV1, namespace string) k3scattleiov1.AddonInterface {
	return &fakeAddons{
		gentype.NewFakeClientWithList[*v1.Addon, *v1.AddonList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("addons"),
			v1.SchemeGroupVersion.WithKind("Addon"),
			func() *v1.Addon { return &v1.Addon{} },
			func() *v1.AddonList { return &v1.AddonList{} },
			func(dst, src *v1.AddonList) { dst.ListMeta = src.ListMeta },
			func(list *v1.AddonList) []*v1.Addon { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.AddonList, items []*v1.Addon) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
