/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.schema.Schema;

public class EscapeExpression
extends Expression {
    private final Expression subexpression;

    public EscapeExpression(Schema schema, Expression subexpression) {
        super(subexpression, Preconditions.checkNotNull(schema));
        this.subexpression = Preconditions.checkNotNull(subexpression);
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public Expression withSubexpression(Expression newSubexpression) {
        return newSubexpression.equals(this.subexpression) ? this : new EscapeExpression(this.getSchema(), newSubexpression);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitEscapeExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof EscapeExpression && this.equals((EscapeExpression)that);
    }

    public boolean equals(EscapeExpression that) {
        return this.equalsExpression(that) && this.getSubexpression().equals(that.getSubexpression());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getSubexpression());
    }
}

