/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.TemplateName;

public class ClassImport
extends Import {
    private final TemplateName.FullyQualified className;

    public ClassImport(SourcePosition sourcePosition, String displayName, TemplateName.FullyQualified className) {
        super(sourcePosition, displayName);
        this.className = Preconditions.checkNotNull(className);
        Preconditions.checkNotNull(className.getPackageName());
    }

    public ClassImport(Node fromNode, TemplateName.FullyQualified className) {
        super(fromNode);
        this.className = Preconditions.checkNotNull(className);
    }

    public TemplateName.FullyQualified getClassName() {
        return this.className;
    }

    @Override
    public <T> T acceptVisitor(ImportVisitor<T> visitor) {
        return visitor.visitClassImport(this);
    }

    @Override
    public String getTarget() {
        return this.getClassName().toString();
    }

    public boolean equals(Object that) {
        return that instanceof ClassImport && this.equals((ClassImport)that);
    }

    public boolean equals(ClassImport that) {
        return this.getClassName().equals(that.getClassName());
    }
}

