/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base;

import com.google.gxp.base.GxpClosure;
import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;

public final class GxpContext {
    private final Locale locale;
    private final boolean useXmlSyntax;
    private final Charset charset;
    private boolean is_top_level_call = true;

    public GxpContext(Locale locale) {
        this(locale, false, Charsets.US_ASCII);
    }

    public GxpContext(Locale locale, boolean useXmlSyntax) {
        this(locale, useXmlSyntax, Charsets.US_ASCII);
    }

    public GxpContext(Locale locale, boolean useXmlSyntax, Charset charset) {
        this.locale = Preconditions.checkNotNull(locale);
        this.useXmlSyntax = useXmlSyntax;
        this.charset = Preconditions.checkNotNull(charset);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isUsingXmlSyntax() {
        return this.useXmlSyntax;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getString(GxpClosure closure) {
        StringBuilder sb = new StringBuilder();
        try {
            closure.write(sb, this);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public boolean isEmptyOrWhitespace(GxpClosure closure) {
        if (closure != null) {
            for (char c : this.getString(closure).toCharArray()) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTopLevelCall() {
        boolean result = this.is_top_level_call;
        this.is_top_level_call = false;
        return result;
    }
}

