/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base;

import com.google.gxp.base.GxpContext;
import com.google.gxp.base.MarkupClosure;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class GxpAttrBundle<T extends MarkupClosure> {
    private final ImmutableMap<String, T> attrs;
    private final ImmutableSet<String> booleanAttrs;

    GxpAttrBundle(Map<String, T> attrs, Set<String> booleanAttrs) {
        this.attrs = ImmutableMap.copyOf(attrs);
        this.booleanAttrs = ImmutableSet.copyOf(booleanAttrs);
    }

    public void write(Appendable out, GxpContext gxpContext) throws IOException {
        for (Map.Entry attr : this.attrs.entrySet()) {
            out.append(' ');
            out.append((CharSequence)attr.getKey());
            out.append("=\"");
            ((MarkupClosure)attr.getValue()).write(out, gxpContext);
            out.append('\"');
        }
        for (String booleanAttr : this.booleanAttrs) {
            out.append(' ');
            out.append(booleanAttr);
            if (!gxpContext.isUsingXmlSyntax()) continue;
            out.append("=\"");
            out.append(booleanAttr);
            out.append('\"');
        }
    }

    private Map<String, T> getAttrs() {
        return this.attrs;
    }

    private Set<String> getBooleanAttrs() {
        return this.booleanAttrs;
    }

    public static class Builder<T extends MarkupClosure> {
        private final ImmutableSet<String> includeAttrs;
        private final Map<String, T> attrs = Maps.newLinkedHashMap();
        private final Set<String> booleanAttrs = Sets.newLinkedHashSet();

        public Builder() {
            this.includeAttrs = null;
        }

        public Builder(String ... includeAttrs) {
            this.includeAttrs = ImmutableSet.of(includeAttrs);
        }

        public Builder<T> attr(String name, T value, boolean cond) {
            return cond ? this.attr(name, value) : this;
        }

        public Builder<T> attr(String name, T value) {
            this.attrs.put(name, value);
            return this;
        }

        public Builder<T> attr(String name, boolean include, boolean cond) {
            return cond ? this.attr(name, include) : this;
        }

        public Builder<T> attr(String name, boolean include) {
            if (include) {
                this.booleanAttrs.add(name);
            }
            return this;
        }

        public Builder<T> addBundle(GxpAttrBundle<T> bundle) {
            if (this.includeAttrs == null) {
                this.attrs.putAll(((GxpAttrBundle)bundle).getAttrs());
                this.booleanAttrs.addAll(((GxpAttrBundle)bundle).getBooleanAttrs());
            } else {
                for (Map.Entry entry : ((GxpAttrBundle)bundle).getAttrs().entrySet()) {
                    if (!this.includeAttrs.contains(entry.getKey())) continue;
                    this.attrs.put((String)entry.getKey(), (T)entry.getValue());
                }
                for (String string : ((GxpAttrBundle)bundle).getBooleanAttrs()) {
                    if (!this.includeAttrs.contains(string)) continue;
                    this.booleanAttrs.add(string);
                }
            }
            return this;
        }

        public GxpAttrBundle<T> build() {
            return new GxpAttrBundle<T>(this.attrs, this.booleanAttrs);
        }
    }
}

