/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.Collection;
import net.sf.oval.internal.util.StringUtils;

public final class Assert {
    private static RuntimeException _adjustStacktrace(RuntimeException ex) {
        StackTraceElement[] stack = ex.getStackTrace();
        StackTraceElement[] newStack = new StackTraceElement[stack.length - 1];
        System.arraycopy(stack, 1, newStack, 0, stack.length - 1);
        ex.setStackTrace(newStack);
        return ex;
    }

    public static void argumentNotBlank(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be null"));
        }
        if (value.length() == 0) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be empty"));
        }
        if (StringUtils.isBlank(value)) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be blank"));
        }
    }

    public static <T> void argumentNotEmpty(String name, Collection<T> value) throws IllegalArgumentException {
        if (value == null) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be null"));
        }
        if (value.isEmpty()) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be empty"));
        }
    }

    public static <T> void argumentNotEmpty(String name, T[] value) throws IllegalArgumentException {
        if (value == null) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be null"));
        }
        if (value.length == 0) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be empty"));
        }
    }

    public static void argumentNotNull(String name, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw Assert._adjustStacktrace(new IllegalArgumentException("[" + name + "] must not be null"));
        }
    }

    private Assert() {
    }
}

