/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import net.sf.oval.Validator;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.guard.ParameterNameResolver;

public class ParameterNameResolverEnumerationImpl
implements ParameterNameResolver {
    private final ConcurrentMap<AccessibleObject, String[]> parameterNamesCache = Validator.getCollectionFactory().createConcurrentMap();

    @Override
    public String[] getParameterNames(Constructor<?> constructor) throws ReflectionException {
        String[] parameterNames = (String[])this.parameterNamesCache.get(constructor);
        if (parameterNames == null) {
            int parameterCount = constructor.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "arg" + i;
                ++i;
            }
            this.parameterNamesCache.put(constructor, parameterNames);
        }
        return parameterNames;
    }

    @Override
    public String[] getParameterNames(Method method) throws ReflectionException {
        String[] parameterNames = (String[])this.parameterNamesCache.get(method);
        if (parameterNames == null) {
            int parameterCount = method.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "arg" + i;
                ++i;
            }
            this.parameterNamesCache.put(method, parameterNames);
        }
        return parameterNames;
    }
}

