/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Future;

public class FutureCheck
extends AbstractAnnotationCheck<Future> {
    private static final long serialVersionUID = 1L;
    private long tolerance = 0L;

    @Override
    public void configure(Future constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setTolerance(constraintAnnotation.tolerance());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public long getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        long now = System.currentTimeMillis() - this.tolerance;
        if (valueToValidate instanceof Date) {
            return ((Date)valueToValidate).getTime() > now;
        }
        if (valueToValidate instanceof Calendar) {
            return ((Calendar)valueToValidate).getTimeInMillis() > now;
        }
        if (valueToValidate instanceof LocalDate) {
            return ((LocalDate)valueToValidate).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now;
        }
        if (valueToValidate instanceof LocalTime) {
            return ((LocalTime)valueToValidate).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now;
        }
        if (valueToValidate instanceof LocalDateTime) {
            return ((LocalDateTime)valueToValidate).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > now;
        }
        if (valueToValidate instanceof OffsetTime) {
            return ((OffsetTime)valueToValidate).atDate(LocalDate.now()).toInstant().toEpochMilli() > now;
        }
        if (valueToValidate instanceof OffsetDateTime) {
            return ((OffsetDateTime)valueToValidate).toInstant().toEpochMilli() > now;
        }
        if (valueToValidate instanceof ZonedDateTime) {
            return ((ZonedDateTime)valueToValidate).toInstant().toEpochMilli() > now;
        }
        String stringValue = valueToValidate.toString();
        try {
            return DateFormat.getDateTimeInstance().parse(stringValue).getTime() > now;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }
}

