/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedClientScanner
extends ClientScanner {
    public ReversedClientScanner(Configuration conf, Scan scan, Scan scanForMetrics, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int scanReadRpcTimeout, int scannerTimeout, int primaryOperationTimeout, ConnectionConfiguration connectionConfiguration, Map<String, byte[]> requestAttributes) throws IOException {
        super(conf, scan, scanForMetrics, tableName, connection, rpcFactory, controllerFactory, pool, scanReadRpcTimeout, scannerTimeout, primaryOperationTimeout, connectionConfiguration, requestAttributes);
    }

    @Override
    protected boolean setNewStartKey() {
        if (ConnectionUtils.noMoreResultsForReverseScan(this.scan, this.currentRegion)) {
            return false;
        }
        this.scan.withStartRow(this.currentRegion.getStartKey(), false);
        return true;
    }

    @Override
    protected ReversedScannerCallable createScannerCallable() {
        return new ReversedScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory, this.getScanReplicaId(), this.requestAttributes);
    }
}

