/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;

class MessageBatch
implements INettySerializable {
    private final int bufferSize;
    private final ArrayList<TaskMessage> msgs;
    private int encodedLength;

    MessageBatch(int bufferSize) {
        this.bufferSize = bufferSize;
        this.msgs = new ArrayList();
        this.encodedLength = ControlMessage.EOB_MESSAGE.encodeLength();
    }

    void add(TaskMessage msg) {
        if (msg == null) {
            throw new RuntimeException("null object forbidden in message batch");
        }
        this.msgs.add(msg);
        this.encodedLength += this.msgEncodeLength(msg);
    }

    private int msgEncodeLength(TaskMessage taskMsg) {
        if (taskMsg == null) {
            return 0;
        }
        int size = 6;
        if (taskMsg.message() != null) {
            size += taskMsg.message().length;
        }
        return size;
    }

    boolean isFull() {
        return this.encodedLength >= this.bufferSize;
    }

    boolean isEmpty() {
        return this.msgs.isEmpty();
    }

    int size() {
        return this.msgs.size();
    }

    @Override
    public int encodeLength() {
        return this.encodedLength;
    }

    @Override
    public void write(ByteBuf dest) {
        for (TaskMessage msg : this.msgs) {
            this.writeTaskMessage(dest, msg);
        }
        ControlMessage.EOB_MESSAGE.write(dest);
    }

    private void writeTaskMessage(ByteBuf buf, TaskMessage message) {
        int taskId;
        int payloadLen = 0;
        if (message.message() != null) {
            payloadLen = message.message().length;
        }
        if ((taskId = message.task()) > Short.MAX_VALUE) {
            throw new RuntimeException("Task ID should not exceed 32767");
        }
        buf.writeShort((int)((short)taskId));
        buf.writeInt(payloadLen);
        if (payloadLen > 0) {
            buf.writeBytes(message.message());
        }
    }
}

