/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.messaging.IConnectionCallback;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.serialization.KryoTupleDeserializer;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ObjectReader;

public class DeserializingConnectionCallback
implements IConnectionCallback,
IMetric {
    private final WorkerState.ILocalTransferCallback cb;
    private final Map<String, Object> conf;
    private final GeneralTopologyContext context;
    private final ThreadLocal<KryoTupleDeserializer> des = new ThreadLocal<KryoTupleDeserializer>(){

        @Override
        protected KryoTupleDeserializer initialValue() {
            return new KryoTupleDeserializer(DeserializingConnectionCallback.this.conf, DeserializingConnectionCallback.this.context);
        }
    };
    private final boolean sizeMetricsEnabled;
    private final ConcurrentHashMap<String, AtomicLong> byteCounts = new ConcurrentHashMap();

    public DeserializingConnectionCallback(Map<String, Object> conf, GeneralTopologyContext context, WorkerState.ILocalTransferCallback callback) {
        this.conf = conf;
        this.context = context;
        this.cb = callback;
        this.sizeMetricsEnabled = ObjectReader.getBoolean(conf.get("topology.serialized.message.size.metrics"), false);
    }

    @Override
    public void recv(List<TaskMessage> batch) {
        KryoTupleDeserializer des = this.des.get();
        ArrayList<AddressedTuple> ret = new ArrayList<AddressedTuple>(batch.size());
        for (TaskMessage message : batch) {
            TupleImpl tuple = des.deserialize(message.message());
            AddressedTuple addrTuple = new AddressedTuple(message.task(), tuple);
            this.updateMetrics(tuple.getSourceTask(), message);
            ret.add(addrTuple);
        }
        this.cb.transfer(ret);
    }

    @Override
    public Object getValueAndReset() {
        if (!this.sizeMetricsEnabled) {
            return null;
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> ent : this.byteCounts.entrySet()) {
            AtomicLong count = ent.getValue();
            if (count.get() <= 0L) continue;
            outMap.put(ent.getKey(), count.getAndSet(0L));
        }
        return outMap;
    }

    protected void updateMetrics(int sourceTaskId, TaskMessage message) {
        if (this.sizeMetricsEnabled) {
            int dest = message.task();
            int len = message.message().length;
            String key = Integer.toString(sourceTaskId) + "-" + Integer.toString(dest);
            this.byteCounts.computeIfAbsent(key, k -> new AtomicLong(0L)).addAndGet(len);
        }
    }
}

