/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.common;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.security.Credentials;
import org.apache.storm.common.CredentialKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HadoopCredentialUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopCredentialUtil.class);

    private HadoopCredentialUtil() {
    }

    static Set<Pair<String, Credentials>> getCredential(CredentialKeyProvider provider, Map<String, String> credentials, Collection<String> configKeys) {
        HashSet<Pair<String, Credentials>> res = new HashSet<Pair<String, Credentials>>();
        if (!configKeys.isEmpty()) {
            for (String configKey : configKeys) {
                Credentials cred = HadoopCredentialUtil.doGetCredentials(provider, credentials, configKey);
                if (cred == null) continue;
                res.add((Pair<String, Credentials>)new Pair((Object)configKey, (Object)cred));
            }
        } else {
            Credentials cred = HadoopCredentialUtil.doGetCredentials(provider, credentials, "");
            if (cred != null) {
                res.add((Pair<String, Credentials>)new Pair((Object)"", (Object)cred));
            }
        }
        return res;
    }

    private static Credentials doGetCredentials(CredentialKeyProvider provider, Map<String, String> credentials, String configKey) {
        Credentials credential = null;
        String credentialKey = provider.getCredentialKey(configKey);
        if (credentials != null && credentials.containsKey(credentialKey)) {
            try {
                byte[] credBytes = DatatypeConverter.parseBase64Binary((String)credentialKey);
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(credBytes));
                credential = new Credentials();
                credential.readFields((DataInput)in);
            }
            catch (Exception e) {
                LOG.error("Could not obtain credentials from credentials map.", (Throwable)e);
            }
        }
        return credential;
    }
}

