/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder;

import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.SitemapException;
import org.apache.sling.sitemap.builder.Extension;
import org.apache.sling.sitemap.builder.Url;
import org.apache.sling.sitemap.impl.builder.ExtensionWriter;
import org.apache.sling.sitemap.impl.builder.StringWriter;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionFactory;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionProviderManager;
import org.apache.sling.sitemap.spi.builder.AbstractExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlImpl
implements Url {
    private static final Logger LOG = LoggerFactory.getLogger(UrlImpl.class);
    private final String location;
    private final Writer out;
    private final XMLOutputFactory xmlWriterFactory;
    private final ExtensionProviderManager extensionProviderManager;
    private boolean written = false;
    private Url.ChangeFrequency changeFrequency;
    private Instant lastModified;
    private Double priority;
    private List<ExtensionMeta> extensions;

    UrlImpl(String location, Writer out, XMLOutputFactory xmlWriterFactory, ExtensionProviderManager extensionProviderManager) {
        this.location = location;
        this.out = out;
        this.xmlWriterFactory = xmlWriterFactory;
        this.extensionProviderManager = extensionProviderManager;
    }

    @Override
    @NotNull
    public Url setChangeFrequency(@NotNull Url.ChangeFrequency changeFrequency) {
        this.ensureNotWritten();
        this.changeFrequency = changeFrequency;
        return this;
    }

    @Override
    @NotNull
    public Url setLastModified(@NotNull Instant pointInTime) {
        this.ensureNotWritten();
        this.lastModified = pointInTime;
        return this;
    }

    @Override
    @NotNull
    public Url setPriority(double priority) {
        this.ensureNotWritten();
        this.priority = priority;
        return this;
    }

    @Override
    @Nullable
    public <T extends Extension> T addExtension(Class<T> extensionInterface) {
        this.ensureNotWritten();
        ExtensionFactory extensionFactory = this.extensionProviderManager.getExtensionFactory(extensionInterface);
        if (extensionFactory == null) {
            return null;
        }
        AbstractExtension extension = extensionFactory.newExtension();
        if (!extensionInterface.isInstance(extension)) {
            LOG.warn("Extension registered by factory for type '{}' is of incompatible type: {}", (Object)extensionInterface.getName(), (Object)extension.getClass().getName());
            return null;
        }
        if (this.extensions == null) {
            this.extensions = new LinkedList<ExtensionMeta>();
        }
        this.extensions.add(new ExtensionMeta(extension, extensionFactory.getNamespace(), extensionFactory.getPrefix(), extensionFactory.getLocalName(), extensionFactory.isEmptyTag()));
        return (T)((Extension)extensionInterface.cast(extension));
    }

    void write() throws SitemapException {
        this.ensureNotWritten();
        this.written = true;
        try {
            StringWriter urlChunk = new StringWriter();
            XMLStreamWriter urlWriter = this.xmlWriterFactory.createXMLStreamWriter(urlChunk);
            urlWriter.setPrefix("", "http://www.sitemaps.org/schemas/sitemap/0.9");
            urlWriter.writeStartElement("", "url", "http://www.sitemaps.org/schemas/sitemap/0.9");
            urlWriter.writeStartElement("", "loc", "http://www.sitemaps.org/schemas/sitemap/0.9");
            urlWriter.writeCharacters(this.location);
            urlWriter.writeEndElement();
            if (this.lastModified != null) {
                urlWriter.writeStartElement("", "lastmod", "http://www.sitemaps.org/schemas/sitemap/0.9");
                urlWriter.writeCharacters(this.lastModified.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
                urlWriter.writeEndElement();
            }
            if (this.changeFrequency != null) {
                urlWriter.writeStartElement("", "changefreq", "http://www.sitemaps.org/schemas/sitemap/0.9");
                urlWriter.writeCharacters(this.changeFrequency.name().toLowerCase(Locale.ROOT));
                urlWriter.writeEndElement();
            }
            if (this.priority != null) {
                urlWriter.writeStartElement("", "priority", "http://www.sitemaps.org/schemas/sitemap/0.9");
                urlWriter.writeCharacters(String.valueOf(Math.max(Math.min(this.priority, 1.0), 0.0)));
                urlWriter.writeEndElement();
            }
            urlWriter.flush();
            if (this.extensions != null) {
                try (StringWriter extensionChunk = new StringWriter();){
                    for (ExtensionMeta extension : this.extensions) {
                        this.writeExtension(extensionChunk, extension);
                        urlChunk.append(extensionChunk.asCharSequence());
                        extensionChunk.reset();
                    }
                }
            }
            urlWriter.writeEndElement();
            urlWriter.flush();
            this.out.append(urlChunk.asCharSequence());
        }
        catch (XMLStreamException ex) {
            LOG.warn("Failed to serialize url", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SitemapException(ex);
        }
    }

    private void ensureNotWritten() {
        if (this.written) {
            throw new IllegalStateException("Url already written");
        }
    }

    private void writeExtension(StringWriter out, ExtensionMeta extension) {
        try {
            XMLStreamWriter extensionWriter = this.xmlWriterFactory.createXMLStreamWriter(out);
            extensionWriter.setPrefix(extension.prefix, extension.namespace);
            if (extension.emptyTag) {
                extensionWriter.writeEmptyElement(extension.prefix, extension.localName, extension.namespace);
            } else {
                extensionWriter.writeStartElement(extension.prefix, extension.localName, extension.namespace);
            }
            extension.extension.writeTo(new ExtensionWriter(extensionWriter, extension.namespace));
            if (!extension.emptyTag) {
                extensionWriter.writeEndElement();
            } else {
                extensionWriter.writeCharacters("");
            }
            extensionWriter.flush();
        }
        catch (XMLStreamException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Failed to serialize extension {}", (Object)extension.extension.getClass().getName(), (Object)ex);
            } else {
                LOG.warn("Failed to serialize extension {}: {}", (Object)extension.extension.getClass().getName(), (Object)ex.getMessage());
            }
            out.reset();
        }
    }

    private static class ExtensionMeta {
        private final AbstractExtension extension;
        private final String namespace;
        private final String prefix;
        private final String localName;
        private final boolean emptyTag;

        public ExtensionMeta(AbstractExtension extension, String namespace, String prefix, String localName, boolean emptyTag) {
            this.extension = extension;
            this.namespace = namespace;
            this.prefix = prefix;
            this.localName = localName;
            this.emptyTag = emptyTag;
        }
    }
}

