/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapScheduler.class, Runnable.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"scheduler.concurrent:Boolean=false", "scheduler.runOn=SINGLE", "scheduler.threadPool=org-apache-sling-sitemap"})
@Designate(ocd=Configuration.class, factory=true)
public class SitemapScheduler
implements Runnable {
    public static final String THREADPOOL_NAME = "org-apache-sling-sitemap";
    private Logger log;
    private static final Map<String, Object> AUTH = Collections.singletonMap("sling.service.subservice", "sitemap-reader");
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference(target="(subServiceName=sitemap-reader)")
    private ServiceUserMapped serviceUserMapped;
    private Set<String> names;
    private Set<String> includeGenerators;
    private Set<String> excludeGenerators;
    private String searchPath;
    private PathSet includePaths;
    private PathSet excludePaths;

    @Activate
    protected void activate(Configuration configuration) {
        this.log = LoggerFactory.getLogger((String)(SitemapScheduler.class.getName() + '~' + configuration.scheduler_name()));
        this.includeGenerators = SitemapScheduler.asSet(configuration.includeGenerators());
        this.excludeGenerators = SitemapScheduler.asSet(configuration.excludeGenerators());
        this.names = SitemapScheduler.asSet(configuration.names());
        this.searchPath = configuration.searchPath();
        if (configuration.includePaths().length > 0) {
            this.includePaths = PathSet.fromStringCollection(Arrays.asList(configuration.includePaths()));
        }
        if (configuration.excludePaths().length > 0) {
            this.excludePaths = PathSet.fromStringCollection(Arrays.asList(configuration.excludePaths()));
        }
    }

    @Override
    public void run() {
        this.schedule(null);
    }

    public void schedule(@Nullable Collection<String> includeNames) {
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Iterator<Resource> sitemapRoots = SitemapUtil.findSitemapRoots(resolver, this.searchPath);
            while (sitemapRoots.hasNext()) {
                this.schedule(sitemapRoots.next(), includeNames);
            }
        }
        catch (LoginException ex) {
            this.log.warn("Failed start sitemap jobs: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void schedule(Resource sitemapRoot, @Nullable Collection<String> includeNames) {
        if (this.isExcluded(sitemapRoot)) {
            return;
        }
        Set<String> configuredNames = this.getApplicableNames(sitemapRoot);
        if (includeNames != null) {
            configuredNames.retainAll(includeNames);
        }
        for (String applicableName : configuredNames) {
            this.addJob(sitemapRoot.getPath(), applicableName);
        }
    }

    public Set<String> getApplicableNames(Resource sitemapRoot) {
        if (this.isExcluded(sitemapRoot)) {
            return Collections.emptySet();
        }
        Set<String> onDemandNames = this.generatorManager.getOnDemandNames(sitemapRoot);
        Set<String> toSchedule = this.generatorManager.getGenerators(sitemapRoot).entrySet().stream().filter(entry -> this.includeGenerators == null || this.includeGenerators.contains(((SitemapGenerator)entry.getValue()).getClass().getName())).filter(entry -> this.excludeGenerators == null || !this.excludeGenerators.contains(((SitemapGenerator)entry.getValue()).getClass().getName())).filter(entry -> !onDemandNames.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (this.names != null) {
            toSchedule.retainAll(this.names);
        }
        return toSchedule;
    }

    protected boolean isExcluded(Resource sitemapRoot) {
        if (!sitemapRoot.getPath().equals(this.searchPath) && !sitemapRoot.getPath().startsWith(this.searchPath + "/")) {
            this.log.debug("Exclude sitemap root outside of the configured search path '{}': {}", (Object)this.searchPath, (Object)sitemapRoot.getPath());
            return true;
        }
        if (this.includePaths != null && this.includePaths.matches(sitemapRoot.getPath()) == null) {
            this.log.debug("Sitemap root is not included: {}", (Object)sitemapRoot.getPath());
            return true;
        }
        if (this.excludePaths != null && this.excludePaths.matches(sitemapRoot.getPath()) != null) {
            this.log.debug("Sitemap root is explicitly excluded: {}", (Object)sitemapRoot.getPath());
            return true;
        }
        return false;
    }

    protected void addJob(String sitemapRoot, String applicableName) {
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        jobProperties.put("sitemap.name", applicableName);
        jobProperties.put("sitemap.root", sitemapRoot);
        Job job = this.jobManager.addJob("org/apache/sling/sitemap/build", jobProperties);
        this.log.debug("Added job {}", (Object)job.getId());
    }

    @Nullable
    private static Set<String> asSet(@Nullable String[] configuration) {
        if (configuration == null || configuration.length == 0) {
            return null;
        }
        Set<String> result = Arrays.stream(configuration).filter(Objects::nonNull).filter(entry -> !"".equals(entry.trim())).collect(Collectors.toSet());
        return result.isEmpty() ? null : result;
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Scheduler")
    static @interface Configuration {
        @AttributeDefinition(name="Name", description="The name of the scheduler configuration")
        public String scheduler_name();

        @AttributeDefinition(name="Schedule", description="A cron expression defining the schedule at which the sitemap generation jobs will be scheduled.")
        public String scheduler_expression();

        @AttributeDefinition(name="Include Generators", description="A list of full qualified class names of SitemapGenerator implementations. If set only the listed SitemapGenerators will be called. If left empty all will be called.")
        public String[] includeGenerators() default {};

        @AttributeDefinition(name="Exclude Generators", description="A list of full qualified class names of SitemapGenerator implementations. If set the listed SitemapGenerators will not be called. If left empty all will be called.")
        public String[] excludeGenerators() default {};

        @AttributeDefinition(name="Names", description="A list of names. If set only sitemaps for the given names will be generated by. If left empty all will be generated.")
        public String[] names() default {};

        @AttributeDefinition(name="Search Path", description="The path under which sitemap roots should be searched for")
        public String searchPath() default "/content";

        @AttributeDefinition(name="Include Paths", description="A list of paths that should be included by the scheduler. If left empty, all sitemap roots in the configured search path will be included. Absolute paths and glob patterns are supported.")
        public String[] includePaths() default {};

        @AttributeDefinition(name="Exclude Paths", description="A list of paths that should be excluded by the scheduler. If left empty, no sitemap roots in the configured search path will be excluded. Absolute paths and glob patterns are supported.")
        public String[] excludePaths() default {};
    }
}

