/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.resolver.internal.SlingServletResolver;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.WeightedResource;

public class ResourceCollector
extends AbstractResourceCollector {
    protected static final int WEIGHT_NO_MATCH = Integer.MIN_VALUE;
    private final String methodName;
    private final String[] requestSelectors;
    private final int numRequestSelectors;
    private final boolean isGet;
    private final boolean isDefaultExtension;
    private final String suffExt;
    private final String suffMethod;
    private final String suffExtMethod;

    public static ResourceCollector create(SlingJakartaHttpServletRequest request, String[] executionPaths, Collection<String> defaultExtensions, boolean UseResourceCaching) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        boolean isDefaultExtension = requestPathInfo.getExtension() != null && defaultExtensions.contains(requestPathInfo.getExtension());
        return new ResourceCollector(request.getResource(), requestPathInfo.getExtension(), executionPaths, isDefaultExtension, request.getMethod(), requestPathInfo.getSelectors(), UseResourceCaching);
    }

    public static ResourceCollector create(Resource resource, String extension, String[] executionPaths, Collection<String> defaultExtensions, String methodName, String[] selectors, boolean useResourceCaching) {
        boolean isDefaultExtension = extension != null && defaultExtensions.contains(extension);
        return new ResourceCollector(resource, extension, executionPaths, isDefaultExtension, methodName, selectors, useResourceCaching);
    }

    @Deprecated
    public ResourceCollector(String methodName, String baseResourceType, Resource resource, String[] executionPaths) {
        this(methodName, baseResourceType, resource, null, executionPaths, false);
    }

    public ResourceCollector(String methodName, String baseResourceType, Resource resource, String extension, String[] executionPaths, boolean useResourceCaching) {
        super(baseResourceType != null ? baseResourceType : "sling/servlet/default", resource.getResourceType(), resource.getResourceSuperType(), extension, executionPaths, useResourceCaching);
        this.methodName = methodName;
        this.requestSelectors = new String[0];
        this.numRequestSelectors = 0;
        this.isGet = false;
        this.isDefaultExtension = false;
        this.suffExt = "." + extension;
        this.suffMethod = "." + methodName;
        this.suffExtMethod = this.suffExt + this.suffMethod;
        String key = methodName + ":" + baseResourceType + ":" + extension + "::" + (this.resourceType == null ? "" : this.resourceType) + ":" + (this.resourceSuperType == null ? "" : this.resourceSuperType);
        this.hashCode = key.hashCode();
    }

    private ResourceCollector(Resource resource, String extension, String[] executionPaths, boolean isDefaultExtension, String methodName, String[] selectors, boolean useResourceCaching) {
        super("sling/servlet/default", resource.getResourceType(), resource.getResourceSuperType(), extension, executionPaths, useResourceCaching);
        this.methodName = methodName;
        this.suffExt = "." + extension;
        this.suffMethod = "." + methodName;
        this.suffExtMethod = this.suffExt + this.suffMethod;
        this.requestSelectors = selectors;
        this.numRequestSelectors = this.requestSelectors.length;
        this.isGet = "GET".equals(methodName) || "HEAD".equals(methodName);
        this.isDefaultExtension = isDefaultExtension;
        String key = methodName + ":" + this.baseResourceType + ":" + extension + ":" + String.join((CharSequence)".", this.requestSelectors) + ":" + (this.resourceType == null ? "" : this.resourceType) + ":" + (this.resourceSuperType == null ? "" : this.resourceSuperType);
        this.hashCode = key.hashCode();
    }

    @Override
    protected void getWeightedResources(Set<WeightedResource> resources, Resource location) {
        String selector;
        ResourceResolver resolver = location.getResourceResolver();
        Resource current = location;
        String parentName = current.getName();
        int selIdx = 0;
        do {
            selector = selIdx < this.numRequestSelectors ? this.requestSelectors[selIdx] : null;
            List<Resource> children = ResourceCollector.getChildrenList(current, this.isDefaultExtension);
            for (Resource child : children) {
                String scriptName;
                int lastDot;
                if (!SlingServletResolver.isPathAllowed(child.getPath(), this.executionPaths) || (lastDot = (scriptName = child.getName()).lastIndexOf(46)) < 0) continue;
                scriptName = scriptName.substring(0, lastDot);
                if (this.isGet && this.checkScriptName(scriptName, selector, parentName, this.suffExt, null, resources, child, selIdx) || this.checkScriptName(scriptName, selector, parentName, this.suffExtMethod, this.suffMethod, resources, child, selIdx)) continue;
                if (selector != null && this.matches(scriptName, selector, this.suffMethod)) {
                    this.addWeightedResource(resources, child, selIdx + 1, 0);
                    continue;
                }
                if (!scriptName.equals(this.methodName)) continue;
                this.addWeightedResource(resources, child, selIdx, 0);
            }
            if (selector == null) continue;
            current = resolver.getResource(current, selector);
            parentName = selector;
            ++selIdx;
        } while (selector != null && current != null);
        this.addLocationServlet(resources, location);
    }

    private boolean checkScriptName(String scriptName, String selector, String parentName, String suffix, String htmlSuffix, Set<WeightedResource> resources, Resource child, int selIdx) {
        if (selector != null && this.matches(scriptName, selector, suffix)) {
            this.addWeightedResource(resources, child, selIdx + 1, 2);
            return true;
        }
        if (this.matches(scriptName, parentName, suffix)) {
            this.addWeightedResource(resources, child, selIdx, 3 + (htmlSuffix != null ? 1 : 0));
            return true;
        }
        if (suffix != null && !suffix.isEmpty() && scriptName.equals(suffix.substring(1))) {
            this.addWeightedResource(resources, child, selIdx, 2 + (htmlSuffix != null ? 1 : 0));
            return true;
        }
        if (this.isDefaultExtension) {
            if (selector != null && this.matches(scriptName, selector, htmlSuffix)) {
                this.addWeightedResource(resources, child, selIdx + 1, 0);
                return true;
            }
            if (this.matches(scriptName, parentName, htmlSuffix)) {
                this.addWeightedResource(resources, child, selIdx, 1);
                return true;
            }
        }
        return false;
    }

    private boolean matches(String scriptName, String name, String suffix) {
        if (suffix == null) {
            return scriptName.equals(name);
        }
        int lenScriptName = scriptName.length();
        int lenName = name.length();
        int lenSuffix = suffix.length();
        return scriptName.regionMatches(0, name, 0, lenName) && scriptName.regionMatches(lenName, suffix, 0, lenSuffix) && lenScriptName == lenName + lenSuffix;
    }

    private void addLocationServlet(Set<WeightedResource> resources, Resource location) {
        Resource servlet;
        String path = location.getPath() + ".servlet";
        if (SlingServletResolver.isPathAllowed(path, this.executionPaths) && (servlet = location.getResourceResolver().getResource(path)) != null) {
            this.addWeightedResource(resources, servlet, 0, -1);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isDefaultExtension ? 1231 : 1237);
        result = 31 * result + (this.isGet ? 1231 : 1237);
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + this.numRequestSelectors;
        result = 31 * result + Arrays.hashCode(this.requestSelectors);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceCollector other = (ResourceCollector)obj;
        if (this.isDefaultExtension != other.isDefaultExtension) {
            return false;
        }
        if (this.isGet != other.isGet) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.numRequestSelectors != other.numRequestSelectors) {
            return false;
        }
        return Arrays.equals(this.requestSelectors, other.requestSelectors);
    }
}

