<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
## Updating example.asn file

The unit tests and generated sources rely on the definition of `example.asn` file. When you update the file to fix/update/add unit tests, perform following operations to update derived resources.

1. Generate source files for unit test:

    ```
    $ jasn1/bin/jasn1-compiler -f nifi-nar-bundles/nifi-asn1-bundle/nifi-asn1-services/src/test/resources/example.asn -o nifi-nar-bundles/nifi-asn1-bundle/nifi-asn1-services/src/test/java
    ```

2. To generate 'test/resources/examples/*.dat' files, execute `ExampleDataGenerator`.

## Generating model JAR file

In order to test JASN1Reader running in a NiFi flow, a JAR file containing model classes that are generated by jASN1 compiler mentioned above. Such a JAR file can be created by the following command:

```
$ jar -cvf /tmp/jasn1-examples.jar -C nifi-nar-bundles/nifi-asn1-bundle/nifi-asn1-services/target/test-classes/ .
``` 

## NiFi flow template for test

The `ASN1.xml` is a NiFi flow template contains JASN1Reader and other processors to test the component.