/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.ExpressionTreeBuilder;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExplainModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.LowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlParser {
    public static final int MAX_ORDER_BY_COLUMNS = 1560;
    private static final ExpressionNode ONE = ExpressionNode.FACTORY.newInstance().of(2, "1", 0, 0);
    private static final ExpressionNode ZERO_OFFSET = ExpressionNode.FACTORY.newInstance().of(2, "'00:00'", 0, 0);
    private static final LowerCaseAsciiCharSequenceHashSet columnAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet groupByStopSet = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceIntHashMap joinStartSet = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final LowerCaseAsciiCharSequenceHashSet setOperations = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet tableAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private final ObjectPool<AnalyticColumn> analyticColumnPool;
    private final CharacterStore characterStore;
    private final ObjectPool<ColumnCastModel> columnCastModelPool;
    private final CairoConfiguration configuration;
    private final ObjectPool<CopyModel> copyModelPool;
    private final ObjectPool<CreateTableModel> createTableModelPool;
    private final ObjectPool<ExplainModel> explainModelPool;
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final ExpressionParser expressionParser;
    private final ExpressionTreeBuilder expressionTreeBuilder;
    private final ObjectPool<InsertModel> insertModelPool;
    private final SqlOptimiser optimiser;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final ObjectPool<RenameTableModel> renameTableModelPool;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteConcat0Ref = this::rewriteConcat0;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCount0Ref = this::rewriteCount0;
    private final PostOrderTreeTraversalAlgo.Visitor rewritePgCast0Ref = this::rewritePgCast0;
    private final ObjList<ExpressionNode> tempExprNodes = new ObjList();
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCase0Ref = this::rewriteCase0;
    private final LowerCaseCharSequenceObjHashMap<WithClauseModel> topLevelWithModel = new LowerCaseCharSequenceObjHashMap();
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private final ObjectPool<WithClauseModel> withClauseModelPool;
    private boolean subQueryMode = false;

    SqlParser(CairoConfiguration configuration, SqlOptimiser optimiser, CharacterStore characterStore, ObjectPool<ExpressionNode> expressionNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo) {
        this.expressionNodePool = expressionNodePool;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.expressionTreeBuilder = new ExpressionTreeBuilder();
        this.analyticColumnPool = new ObjectPool<AnalyticColumn>(AnalyticColumn.FACTORY, configuration.getAnalyticColumnPoolCapacity());
        this.createTableModelPool = new ObjectPool<CreateTableModel>(CreateTableModel.FACTORY, configuration.getCreateTableModelPoolCapacity());
        this.columnCastModelPool = new ObjectPool<ColumnCastModel>(ColumnCastModel.FACTORY, configuration.getColumnCastModelPoolCapacity());
        this.renameTableModelPool = new ObjectPool<RenameTableModel>(RenameTableModel.FACTORY, configuration.getRenameTableModelPoolCapacity());
        this.withClauseModelPool = new ObjectPool<WithClauseModel>(WithClauseModel.FACTORY, configuration.getWithClauseModelPoolCapacity());
        this.insertModelPool = new ObjectPool<InsertModel>(InsertModel.FACTORY, configuration.getInsertPoolCapacity());
        this.copyModelPool = new ObjectPool<CopyModel>(CopyModel.FACTORY, configuration.getCopyPoolCapacity());
        this.explainModelPool = new ObjectPool<ExplainModel>(ExplainModel.FACTORY, configuration.getExplainPoolCapacity());
        this.configuration = configuration;
        this.traversalAlgo = traversalAlgo;
        this.characterStore = characterStore;
        this.optimiser = optimiser;
        this.expressionParser = new ExpressionParser(expressionNodePool, this, characterStore);
    }

    public static boolean isFullSampleByPeriod(ExpressionNode n) {
        return n != null && (n.type == 2 || n.type == 4 && SqlParser.isValidSampleByPeriodLetter(n.token));
    }

    private static SqlException err(GenericLexer lexer, @Nullable CharSequence tok, @NotNull String msg) {
        return SqlException.parserErr(lexer.lastTokenPosition(), tok, msg);
    }

    private static SqlException errUnexpected(GenericLexer lexer, CharSequence token) {
        return SqlException.unexpectedToken(lexer.lastTokenPosition(), token);
    }

    private static boolean isValidSampleByPeriodLetter(CharSequence token) {
        if (token.length() != 1) {
            return false;
        }
        switch (token.charAt(0)) {
            case 'M': 
            case 'T': 
            case 'U': 
            case 'd': 
            case 'h': 
            case 'm': 
            case 's': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private void addConcatArgs(ObjList<ExpressionNode> args, ExpressionNode leaf) {
        if (leaf.type != 8 || !SqlKeywords.isConcatKeyword(leaf.token)) {
            args.add(leaf);
            return;
        }
        if (leaf.args.size() > 0) {
            args.addAll(leaf.args);
        } else {
            args.add(leaf.rhs);
            args.add(leaf.lhs);
        }
    }

    private void assertNotDot(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (Chars.indexOf(tok, '.') != -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "'.' is not allowed here");
        }
    }

    private void checkSupportedJoinType(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && (SqlKeywords.isFullKeyword(tok) || SqlKeywords.isRightKeyword(tok))) {
            throw SqlException.$(lexer.lastTokenPosition(), "unsupported join type");
        }
    }

    private CharSequence createColumnAlias(ExpressionNode node, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, GenericLexer.unquote(node.token), Chars.indexOf(node.token, '.'), model.getAliasToColumnMap(), node.type != 4);
    }

    private void expectBy(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isByKeyword(this.tok(lexer, "'by'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'by' expected");
    }

    private ExpressionNode expectExpr(GenericLexer lexer) throws SqlException {
        ExpressionNode n = this.expr(lexer, (QueryModel)null);
        if (n != null) {
            return n;
        }
        throw SqlException.$(lexer.hasUnparsed() ? lexer.lastTokenPosition() : lexer.getPosition(), "Expression expected");
    }

    private int expectInt(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "integer");
        } else {
            negative = false;
        }
        try {
            int result = Numbers.parseInt(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, tok, "bad integer");
        }
    }

    private ExpressionNode expectLiteral(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "literal");
        int pos = lexer.lastTokenPosition();
        this.validateLiteral(pos, tok);
        return this.nextLiteral(GenericLexer.immutableOf(GenericLexer.unquote(tok)), pos);
    }

    private long expectLong(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "long integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "long integer");
        } else {
            negative = false;
        }
        try {
            long result = Numbers.parseLong(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, tok, "bad long integer");
        }
    }

    private void expectObservation(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isObservationKeyword(this.tok(lexer, "'observation'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'observation' expected");
    }

    private void expectOffset(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isOffsetKeyword(this.tok(lexer, "'offset'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'offset' expected");
    }

    private void expectSample(GenericLexer lexer, QueryModel model) throws SqlException {
        ExpressionNode n = this.expr(lexer, (QueryModel)null);
        if (SqlParser.isFullSampleByPeriod(n)) {
            model.setSampleBy(n);
            return;
        }
        ExpressionNode periodUnit = this.expectLiteral(lexer);
        if (periodUnit == null || periodUnit.type != 4 || !SqlParser.isValidSampleByPeriodLetter(periodUnit.token)) {
            int lexerPosition = lexer.hasUnparsed() ? lexer.lastTokenPosition() : lexer.getPosition();
            throw SqlException.$(periodUnit != null ? periodUnit.position : lexerPosition, "one letter sample by period unit expected");
        }
        model.setSampleBy(n, periodUnit);
    }

    private CharSequence expectTableNameOrSubQuery(GenericLexer lexer) throws SqlException {
        return this.tok(lexer, "table name or sub-query");
    }

    private void expectTo(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isToKeyword(this.tok(lexer, "'to'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'to' expected");
    }

    private void expectTok(GenericLexer lexer, CharSequence tok, CharSequence expected) throws SqlException {
        if (tok == null || !Chars.equalsLowerCaseAscii(tok, expected)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(expected).put("' expected");
        }
    }

    private void expectTok(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(lexer, tok, expected);
    }

    private void expectTok(GenericLexer lexer, char expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(tok, lexer.lastTokenPosition(), expected);
    }

    private void expectTok(CharSequence tok, int pos, char expected) throws SqlException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw SqlException.position(pos).put('\'').put(expected).put("' expected");
        }
    }

    private void expectZone(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isZoneKeyword(this.tok(lexer, "'zone'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'zone' expected");
    }

    private int getCreateTableColumnIndex(CreateTableModel model, CharSequence columnName, int position) throws SqlException {
        int index = model.getColumnIndex(columnName);
        if (index == -1) {
            throw SqlException.invalidColumn(position, columnName);
        }
        return index;
    }

    private boolean isFieldTerm(CharSequence tok) {
        return Chars.equals(tok, ')') || Chars.equals(tok, ',');
    }

    private ExpressionNode literal(GenericLexer lexer, CharSequence name) {
        return this.literal(name, lexer.lastTokenPosition());
    }

    private ExpressionNode literal(CharSequence name, int position) {
        return this.expressionNodePool.next().of(4, GenericLexer.unquote(name), 0, position);
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.expressionNodePool, token, position);
    }

    private CharSequence notTermTok(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "')' or ','");
        if (this.isFieldTerm(tok)) {
            throw SqlParser.err(lexer, tok, "missing column definition");
        }
        return tok;
    }

    private CharSequence optTok(GenericLexer lexer) {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || this.subQueryMode && Chars.equals(tok, ')')) {
            return null;
        }
        return tok;
    }

    private QueryModel parseAsSubQueryAndExpectClosingBrace(GenericLexer lexer, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel model = this.parseAsSubQuery(lexer, withClauses);
        this.expectTok(lexer, ')');
        return model;
    }

    private ExecutionModel parseCopy(GenericLexer lexer) throws SqlException {
        if (Chars.isBlank(this.configuration.getSqlCopyInputRoot())) {
            throw SqlException.$(lexer.lastTokenPosition(), "COPY is disabled ['cairo.sql.copy.root' is not set?]");
        }
        ExpressionNode target = this.expectExpr(lexer);
        CharSequence tok = this.tok(lexer, "'from' or 'to' or 'cancel'");
        if (SqlKeywords.isCancelKeyword(tok)) {
            CopyModel model = this.copyModelPool.next();
            model.setCancel(true);
            model.setTarget(target);
            return model;
        }
        if (SqlKeywords.isFromKeyword(tok)) {
            ExpressionNode fileName = this.expectExpr(lexer);
            if (fileName.token.length() < 3 && Chars.startsWith(fileName.token, '\'')) {
                throw SqlException.$(fileName.position, "file name expected");
            }
            CopyModel model = this.copyModelPool.next();
            model.setTarget(target);
            model.setFileName(fileName);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                tok = this.tok(lexer, "copy option");
                while (tok != null && !SqlKeywords.isSemicolon(tok)) {
                    if (SqlKeywords.isHeaderKeyword(tok)) {
                        model.setHeader(SqlKeywords.isTrueKeyword(this.tok(lexer, "'true' or 'false'")));
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        tok = this.tok(lexer, "year month day hour");
                        int partitionBy = PartitionBy.fromString(tok);
                        if (partitionBy == -1) {
                            throw SqlException.$(lexer.getPosition(), "'NONE', 'HOUR', 'DAY', 'MONTH' or 'YEAR' expected");
                        }
                        model.setPartitionBy(partitionBy);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isTimestampKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp column name expected");
                        CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                            throw SqlException.$(lexer.getPosition(), "timestamp column name contains invalid characters");
                        }
                        model.setTimestampColumnName(columnName);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isFormatKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp format expected");
                        CharSequence format = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        model.setTimestampFormat(format);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isOnKeyword(tok)) {
                        this.expectTok(lexer, "error");
                        tok = this.tok(lexer, "skip_column skip_row abort");
                        if (Chars.equalsIgnoreCase(tok, "skip_column")) {
                            model.setAtomicity(2);
                        } else if (Chars.equalsIgnoreCase(tok, "skip_row")) {
                            model.setAtomicity(1);
                        } else if (Chars.equalsIgnoreCase(tok, "abort")) {
                            model.setAtomicity(0);
                        } else {
                            throw SqlException.$(lexer.getPosition(), "invalid 'on error' copy option found");
                        }
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isDelimiterKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp character expected");
                        CharSequence delimiter = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        if (delimiter == null || delimiter.length() != 1) {
                            throw SqlException.$(lexer.getPosition(), "delimiter is empty or contains more than 1 character");
                        }
                        char delimiterChar = delimiter.charAt(0);
                        if (delimiterChar > '\u007f') {
                            throw SqlException.$(lexer.getPosition(), "delimiter is not an ascii character");
                        }
                        model.setDelimiter((byte)delimiterChar);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    throw SqlException.$(lexer.lastTokenPosition(), "unexpected option");
                }
            } else if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                throw SqlException.$(lexer.lastTokenPosition(), "'with' expected");
            }
            return model;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'from' expected");
    }

    private ExecutionModel parseCreateStatement(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, "table");
        return this.parseCreateTable(lexer, executionContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutionModel parseCreateTable(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tableName;
        CreateTableModel model = this.createTableModelPool.next();
        CharSequence tok = this.tok(lexer, "table name or 'if'");
        if (SqlKeywords.isIfKeyword(tok)) {
            if (!SqlKeywords.isNotKeyword(this.tok(lexer, "'not'")) || !SqlKeywords.isExistsKeyword(this.tok(lexer, "'exists'"))) throw SqlException.$(lexer.lastTokenPosition(), "'if not exists' expected");
            model.setIgnoreIfExists(true);
            tableName = this.tok(lexer, "table name");
        } else {
            tableName = tok;
        }
        model.setName(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tableName), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "'(' or 'as'");
        if (Chars.equals(tok, '(')) {
            tok = this.tok(lexer, "like");
            if (SqlKeywords.isLikeKeyword(tok)) {
                this.parseLikeTableName(lexer, model);
                return model;
            }
            lexer.unparseLast();
            this.parseCreateTableColumns(lexer, model);
        } else {
            if (!SqlKeywords.isAsKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            this.parseCreateTableAsSelect(lexer, model, executionContext);
        }
        while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ',')) {
            tok = this.tok(lexer, "'index' or 'cast'");
            if (SqlKeywords.isIndexKeyword(tok)) {
                this.parseCreateTableIndexDef(lexer, model);
                continue;
            }
            if (!SqlKeywords.isCastKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            this.parseCreateTableCastDef(lexer, model);
        }
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            int timestampIdx = this.getCreateTableColumnIndex(model, timestamp.token, timestamp.position);
            int timestampType = model.getColumnType(timestampIdx);
            if (timestampType != 8 && timestampType != -1) {
                throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(timestampType)).put(']');
            }
            model.setTimestamp(timestamp);
            tok = this.optTok(lexer);
        }
        int maxUncommittedRows = this.configuration.getMaxUncommittedRows();
        long o3MaxLag = this.configuration.getO3MaxLag();
        int walSetting = -1;
        ExpressionNode partitionBy = this.parseCreateTablePartition(lexer, tok);
        if (partitionBy != null) {
            if (model.getTimestamp() == null) {
                throw SqlException.$(partitionBy.position, "partitioning is possible only on tables with designated timestamps");
            }
            if (PartitionBy.fromString(partitionBy.token) == -1) {
                throw SqlException.$(partitionBy.position, "'NONE', 'HOUR', 'DAY', 'MONTH' or 'YEAR' expected");
            }
            model.setPartitionBy(partitionBy);
            tok = this.optTok(lexer);
            if (tok != null) {
                if (SqlKeywords.isWalKeyword(tok)) {
                    if (!PartitionBy.isPartitioned(model.getPartitionBy())) {
                        throw SqlException.position(lexer.lastTokenPosition()).put("WAL Write Mode can only be used on partitioned tables");
                    }
                    walSetting = 1;
                    tok = this.optTok(lexer);
                } else if (SqlKeywords.isBypassKeyword(tok)) {
                    tok = this.optTok(lexer);
                    if (tok == null || !SqlKeywords.isWalKeyword(tok)) throw SqlException.position(tok == null ? lexer.getPosition() : lexer.lastTokenPosition()).put(" invalid syntax, should be BYPASS WAL but was BYPASS ").put(tok != null ? tok : "");
                    walSetting = 0;
                    tok = this.optTok(lexer);
                }
            }
            if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                ExpressionNode expr;
                while ((expr = this.expr(lexer, (QueryModel)null)) != null) {
                    if (!Chars.equals(expr.token, '=')) throw SqlException.position(lexer.getPosition()).put(" expected parameter after WITH");
                    if (SqlKeywords.isMaxUncommittedRowsKeyword(expr.lhs.token)) {
                        try {
                            maxUncommittedRows = Numbers.parseInt(expr.rhs.token);
                        }
                        catch (NumericException e) {
                            throw SqlException.position(lexer.getPosition()).put(" could not parse maxUncommittedRows value \"").put(expr.rhs.token).put('\"');
                        }
                    } else {
                        if (!SqlKeywords.isO3MaxLagKeyword(expr.lhs.token)) throw SqlException.position(lexer.getPosition()).put(" unrecognized ").put(expr.lhs.token).put(" after WITH");
                        o3MaxLag = SqlUtil.expectMicros(expr.rhs.token, lexer.getPosition());
                    }
                    tok = this.optTok(lexer);
                    if (null == tok || !Chars.equals(tok, ',')) break;
                }
            }
        }
        model.setMaxUncommittedRows(maxUncommittedRows);
        model.setO3MaxLag(o3MaxLag);
        boolean isWalEnabled = this.configuration.isWalSupported() && PartitionBy.isPartitioned(model.getPartitionBy()) && (walSetting == -1 && this.configuration.getWalEnabledDefault() || walSetting == 1);
        model.setWalEnabled(isWalEnabled);
        if (tok != null && !Chars.equals(tok, ';')) throw SqlParser.errUnexpected(lexer, tok);
        return model;
    }

    private void parseCreateTableAsSelect(GenericLexer lexer, CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, '(');
        QueryModel queryModel = this.optimiser.optimise(this.parseDml(lexer, null, lexer.getPosition()), executionContext);
        ObjList<QueryColumn> columns = queryModel.getBottomUpColumns();
        assert (columns.size() > 0);
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            model.addColumn(columns.getQuick(i).getName(), -1, this.configuration.getDefaultSymbolCapacity());
        }
        model.setQueryModel(queryModel);
        this.expectTok(lexer, ')');
    }

    private void parseCreateTableCastDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        if (model.getQueryModel() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "cast is only supported in 'create table as ...' context");
        }
        this.expectTok(lexer, '(');
        ColumnCastModel columnCastModel = this.columnCastModelPool.next();
        ExpressionNode columnName = this.expectLiteral(lexer);
        columnCastModel.setName(columnName);
        this.expectTok(lexer, "as");
        ExpressionNode columnType = this.expectLiteral(lexer);
        int type = this.toColumnType(lexer, columnType.token);
        columnCastModel.setType(type, columnName.position, columnType.position);
        if (ColumnType.isSymbol(type)) {
            boolean cached;
            int symbolCapacity;
            int capacityPosition;
            CharSequence tok = this.tok(lexer, "'capacity', 'nocache', 'cache' or ')'");
            if (SqlKeywords.isCapacityKeyword(tok)) {
                capacityPosition = lexer.getPosition();
                symbolCapacity = this.parseSymbolCapacity(lexer);
                columnCastModel.setSymbolCapacity(symbolCapacity);
                tok = this.tok(lexer, "'nocache', 'cache' or ')'");
            } else {
                columnCastModel.setSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
                symbolCapacity = -1;
                capacityPosition = -1;
            }
            if (SqlKeywords.isNoCacheKeyword(tok)) {
                cached = false;
            } else if (SqlKeywords.isCacheKeyword(tok)) {
                cached = true;
            } else {
                cached = this.configuration.getDefaultSymbolCacheFlag();
                lexer.unparseLast();
            }
            columnCastModel.setSymbolCacheFlag(cached);
            if (cached && symbolCapacity != -1) {
                assert (capacityPosition != -1);
                TableUtils.validateSymbolCapacityCached(true, symbolCapacity, capacityPosition);
            }
            columnCastModel.setIndexed(false);
        }
        this.expectTok(lexer, ')');
        if (!model.addColumnCastModel(columnCastModel)) {
            throw SqlException.$(columnCastModel.getName().position, "duplicate cast");
        }
    }

    private void parseCreateTableColumns(GenericLexer lexer, CreateTableModel model) throws SqlException {
        block15: {
            CharSequence tok;
            do {
                int position = lexer.lastTokenPosition();
                CharSequence name = GenericLexer.immutableOf(GenericLexer.unquote(this.notTermTok(lexer)));
                int type = this.toColumnType(lexer, this.notTermTok(lexer));
                if (!TableUtils.isValidColumnName(name, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(position, " new column name contains invalid characters");
                }
                model.addColumn(position, name, type, this.configuration.getDefaultSymbolCapacity());
                if (ColumnType.isSymbol(type)) {
                    boolean cached;
                    int symbolCapacity;
                    tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        symbolCapacity = this.parseSymbolCapacity(lexer);
                        model.symbolCapacity(symbolCapacity);
                        tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
                    } else {
                        symbolCapacity = -1;
                    }
                    if (SqlKeywords.isNoCacheKeyword(tok)) {
                        cached = false;
                    } else if (SqlKeywords.isCacheKeyword(tok)) {
                        cached = true;
                    } else {
                        cached = this.configuration.getDefaultSymbolCacheFlag();
                        lexer.unparseLast();
                    }
                    model.cached(cached);
                    if (cached && symbolCapacity != -1) {
                        TableUtils.validateSymbolCapacityCached(true, symbolCapacity, lexer.lastTokenPosition());
                    }
                    tok = this.parseCreateTableInlineIndexDef(lexer, model);
                } else {
                    tok = null;
                }
                if (tok == null) {
                    tok = this.tok(lexer, "',' or ')'");
                }
                if (SqlKeywords.isPrecisionKeyword(tok)) {
                    tok = this.tok(lexer, "'NOT' or 'NULL' or ',' or ')'");
                }
                if (SqlKeywords.isNotKeyword(tok)) {
                    tok = this.tok(lexer, "'NULL'");
                }
                if (SqlKeywords.isNullKeyword(tok)) {
                    tok = this.tok(lexer, "','");
                }
                if (Chars.equals(tok, ')')) break block15;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, tok, "',' or ')' expected");
        }
    }

    private void parseCreateTableIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        this.expectTok(lexer, '(');
        CharSequence columnName = this.expectLiteral((GenericLexer)lexer).token;
        int position = lexer.lastTokenPosition();
        int columnIndex = this.getCreateTableColumnIndex(model, columnName, position);
        int columnType = model.getColumnType(columnIndex);
        if (columnType > -1 && !ColumnType.isSymbol(columnType)) {
            throw SqlException.$(position, "indexes are supported only for SYMBOL columns: ").put(columnName);
        }
        if (SqlKeywords.isCapacityKeyword(this.tok(lexer, "'capacity'"))) {
            int errorPosition = lexer.getPosition();
            int indexValueBlockSize = this.expectInt(lexer);
            TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
            model.setIndexFlags(columnIndex, true, Numbers.ceilPow2(indexValueBlockSize));
        } else {
            model.setIndexFlags(columnIndex, true, this.configuration.getIndexValueBlockSize());
            lexer.unparseLast();
        }
        this.expectTok(lexer, ')');
    }

    private CharSequence parseCreateTableInlineIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "')', or 'index'");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(false, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "index");
        tok = this.tok(lexer, ") | , expected");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(true, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "capacity");
        int errorPosition = lexer.getPosition();
        int indexValueBlockSize = this.expectInt(lexer);
        TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
        model.setIndexFlags(true, Numbers.ceilPow2(indexValueBlockSize));
        return null;
    }

    private ExpressionNode parseCreateTablePartition(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
            this.expectTok(lexer, "by");
            return this.expectLiteral(lexer);
        }
        return null;
    }

    private QueryModel parseDml(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses, int modelPosition) throws SqlException {
        QueryModel model = null;
        QueryModel prevModel = null;
        while (true) {
            LowerCaseCharSequenceObjHashMap<WithClauseModel> parentWithClauses = prevModel != null ? prevModel.getWithClauses() : withClauses;
            LowerCaseCharSequenceObjHashMap<WithClauseModel> topWithClauses = model == null ? this.topLevelWithModel : null;
            QueryModel unionModel = this.parseDml0(lexer, parentWithClauses, topWithClauses, modelPosition);
            if (prevModel == null) {
                prevModel = model = unionModel;
            } else {
                prevModel.setUnionModel(unionModel);
                prevModel = unionModel;
            }
            CharSequence tok = this.optTok(lexer);
            if (tok == null || Chars.equals(tok, ';') || setOperations.excludes(tok)) {
                lexer.unparseLast();
                return model;
            }
            if (prevModel.getNestedModel() != null) {
                if (prevModel.getNestedModel().getOrderByPosition() > 0) {
                    throw SqlException.$(prevModel.getNestedModel().getOrderByPosition(), "unexpected token 'order'");
                }
                if (prevModel.getNestedModel().getLimitPosition() > 0) {
                    throw SqlException.$(prevModel.getNestedModel().getLimitPosition(), "unexpected token 'limit'");
                }
            }
            if (SqlKeywords.isUnionKeyword(tok)) {
                tok = this.tok(lexer, "all or select");
                if (SqlKeywords.isAllKeyword(tok)) {
                    prevModel.setSetOperationType(0);
                    modelPosition = lexer.getPosition();
                    continue;
                }
                prevModel.setSetOperationType(1);
                lexer.unparseLast();
                modelPosition = lexer.lastTokenPosition();
                continue;
            }
            if (SqlKeywords.isExceptKeyword(tok)) {
                prevModel.setSetOperationType(2);
                continue;
            }
            if (!SqlKeywords.isIntersectKeyword(tok)) continue;
            prevModel.setSetOperationType(3);
        }
    }

    @NotNull
    private QueryModel parseDml0(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> parentWithClauses, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> topWithClauses, int modelPosition) throws SqlException {
        CharSequence tok;
        QueryModel model = this.queryModelPool.next();
        model.setModelPosition(modelPosition);
        if (parentWithClauses != null) {
            model.getWithClauses().putAll(parentWithClauses);
        }
        if (SqlKeywords.isWithKeyword(tok = this.tok(lexer, "'select', 'with' or table name expected"))) {
            this.parseWithClauses(lexer, model.getWithClauses());
            tok = this.tok(lexer, "'select' or table name expected");
        } else if (topWithClauses != null) {
            model.getWithClauses().putAll(topWithClauses);
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            this.parseSelectClause(lexer, model);
            tok = this.optTok(lexer);
            if (tok != null && setOperations.contains(tok)) {
                tok = null;
            }
            if (tok == null || Chars.equals(tok, ';')) {
                QueryModel nestedModel = this.queryModelPool.next();
                nestedModel.setModelPosition(modelPosition);
                ExpressionNode func = this.expressionNodePool.next().of(8, "long_sequence", 0, lexer.lastTokenPosition());
                func.paramCount = 1;
                func.rhs = ONE;
                nestedModel.setTableNameExpr(func);
                model.setSelectModelType(2);
                model.setNestedModel(nestedModel);
                lexer.unparseLast();
                return model;
            }
        } else {
            lexer.unparseLast();
            SqlUtil.addSelectStar(model, this.queryColumnPool, this.expressionNodePool);
        }
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setModelPosition(modelPosition);
        this.parseFromClause(lexer, nestedModel, model);
        if (nestedModel.getLimitHi() != null || nestedModel.getLimitLo() != null) {
            model.setLimit(nestedModel.getLimitLo(), nestedModel.getLimitHi());
            nestedModel.setLimit(null, null);
        }
        model.setSelectModelType(1);
        model.setNestedModel(nestedModel);
        ExpressionNode n = nestedModel.getAlias();
        if (n != null) {
            model.setAlias(n);
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryModel parseDmlUpdate(GenericLexer lexer) throws SqlException {
        int modelPosition = lexer.getPosition();
        QueryModel updateQueryModel = this.queryModelPool.next();
        updateQueryModel.setModelType(6);
        updateQueryModel.setModelPosition(modelPosition);
        QueryModel fromModel = this.queryModelPool.next();
        fromModel.setModelPosition(modelPosition);
        updateQueryModel.setIsUpdate(true);
        fromModel.setIsUpdate(true);
        CharSequence tok = this.tok(lexer, "UPDATE, WITH or table name expected");
        if (!SqlKeywords.isUpdateKeyword(tok)) return updateQueryModel;
        this.parseUpdateClause(lexer, updateQueryModel, fromModel);
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setTableNameExpr(fromModel.getTableNameExpr());
        nestedModel.setAlias(updateQueryModel.getAlias());
        nestedModel.setIsUpdate(true);
        fromModel.setTableNameExpr(null);
        fromModel.setNestedModel(nestedModel);
        fromModel.getWithClauses().putAll(this.topLevelWithModel);
        tok = this.optTok(lexer);
        if (tok != null && SqlKeywords.isFromKeyword(tok)) {
            int joinType;
            tok = ",";
            int i = 0;
            while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
                if (i++ == 1) {
                    throw SqlException.$(lexer.lastTokenPosition(), "JOIN is not supported on UPDATE statement");
                }
                nestedModel.addJoinModel(this.parseJoin(lexer, tok, joinType, this.topLevelWithModel));
                tok = this.optTok(lexer);
            }
        } else if (tok != null && SqlKeywords.isSemicolon(tok)) {
            tok = null;
        } else if (tok != null && !SqlKeywords.isWhereKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "FROM, WHERE or EOF expected");
        }
        if (tok != null && SqlKeywords.isWhereKeyword(tok)) {
            ExpressionNode expr = this.expr(lexer, fromModel);
            if (expr == null) throw SqlException.$(lexer.lastTokenPosition(), "empty where clause");
            nestedModel.setWhereClause(expr);
        } else if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlParser.errUnexpected(lexer, tok);
        }
        updateQueryModel.setNestedModel(fromModel);
        return updateQueryModel;
    }

    private ExecutionModel parseExplain(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'format', 'insert', 'update', 'select' or 'with'");
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer);
        }
        if (SqlKeywords.isCreateKeyword(tok)) {
            return this.parseCreateStatement(lexer, executionContext);
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer);
        }
        if (SqlKeywords.isWithKeyword(tok)) {
            return this.parseWith(lexer);
        }
        return this.parseSelect(lexer);
    }

    private int parseExplainOptions(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'insert', 'update', 'select', 'with' or '('");
        if (Chars.equals(tok, '(')) {
            tok = this.tok(lexer, "'format'");
            if (SqlKeywords.isFormatKeyword(tok)) {
                tok = this.tok(lexer, "'text' or 'json'");
                if (SqlKeywords.isTextKeyword(tok) || SqlKeywords.isJsonKeyword(tok)) {
                    int format = SqlKeywords.isJsonKeyword(tok) ? 2 : 1;
                    tok = this.tok(lexer, "')'");
                    if (!Chars.equals(tok, ')')) {
                        throw SqlException.$(lexer.lastTokenPosition(), "unexpected explain option found");
                    }
                    return format;
                }
                throw SqlException.$(lexer.lastTokenPosition(), "unexpected explain format found");
            }
            throw SqlException.$(lexer.lastTokenPosition(), "unexpected explain option found");
        }
        lexer.unparseLast();
        return 1;
    }

    private void parseFromClause(GenericLexer lexer, QueryModel model, QueryModel masterModel) throws SqlException {
        ExpressionNode n;
        int joinType;
        CharSequence tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            QueryModel proposedNested = this.parseAsSubQueryAndExpectClosingBrace(lexer, masterModel.getWithClauses());
            tok = this.optTok(lexer);
            if (tok == null || tableAliasStop.contains(tok) && !SqlKeywords.isTimestampKeyword(tok)) {
                QueryModel target = proposedNested.getNestedModel();
                if (proposedNested.isArtificialStar() && proposedNested.getUnionModel() == null && target.getWhereClause() == null && target.getOrderBy().size() == 0 && target.getLatestBy().size() == 0 && target.getNestedModel() == null && target.getSampleBy() == null && target.getGroupBy().size() == 0 && proposedNested.getLimitLo() == null && proposedNested.getLimitHi() == null) {
                    model.setTableNameExpr(target.getTableNameExpr());
                    model.setAlias(target.getAlias());
                    model.setTimestamp(target.getTimestamp());
                    int n2 = target.getJoinModels().size();
                    for (int i = 1; i < n2; ++i) {
                        model.addJoinModel(target.getJoinModels().getQuick(i));
                    }
                    proposedNested = null;
                } else {
                    lexer.unparseLast();
                }
            } else {
                lexer.unparseLast();
            }
            if (proposedNested != null) {
                model.setNestedModel(proposedNested);
                model.setNestedModelIsSubQuery(true);
                tok = this.setModelAliasAndTimestamp(lexer, model);
            }
        } else {
            lexer.unparseLast();
            this.parseSelectFrom(lexer, model, masterModel.getWithClauses());
            tok = this.setModelAliasAndTimestamp(lexer, model);
            if (tok != null && SqlKeywords.isLatestKeyword(tok)) {
                this.parseLatestBy(lexer, model);
                tok = this.optTok(lexer);
            }
        }
        while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
            model.addJoinModel(this.parseJoin(lexer, tok, joinType, masterModel.getWithClauses()));
            tok = this.optTok(lexer);
        }
        this.checkSupportedJoinType(lexer, tok);
        if (tok != null && SqlKeywords.isWhereKeyword(tok)) {
            if (model.getLatestByType() == 2) {
                throw SqlException.$(lexer.lastTokenPosition(), "unexpected where clause after 'latest on'");
            }
            ExpressionNode expr = this.expr(lexer, model);
            if (expr != null) {
                model.setWhereClause(expr);
                tok = this.optTok(lexer);
            } else {
                throw SqlException.$(lexer.lastTokenPosition(), "empty where clause");
            }
        }
        if (tok != null && SqlKeywords.isLatestKeyword(tok)) {
            if (model.getLatestByType() == 1) {
                throw SqlException.$(lexer.lastTokenPosition(), "mix of new and deprecated 'latest by' syntax");
            }
            this.expectTok(lexer, "on");
            this.parseLatestByNew(lexer, model);
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isSampleKeyword(tok)) {
            this.expectBy(lexer);
            this.expectSample(lexer, model);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isFillKeyword(tok)) {
                this.expectTok(lexer, '(');
                while (true) {
                    ExpressionNode fillNode;
                    if ((fillNode = this.expr(lexer, model)) == null) {
                        throw SqlException.$(lexer.lastTokenPosition(), "'none', 'prev', 'mid', 'null' or number expected");
                    }
                    model.addSampleByFill(fillNode);
                    tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                    if (Chars.equals(tok, ')')) break;
                    this.expectTok(tok, lexer.lastTokenPosition(), ',');
                }
                tok = this.optTok(lexer);
            }
            if (tok != null && SqlKeywords.isAlignKeyword(tok)) {
                this.expectTo(lexer);
                tok = this.tok(lexer, "'calendar' or 'first observation'");
                if (SqlKeywords.isCalendarKeyword(tok)) {
                    tok = this.optTok(lexer);
                    if (tok == null) {
                        model.setSampleByTimezoneName(null);
                        model.setSampleByOffset(ZERO_OFFSET);
                    } else if (SqlKeywords.isTimeKeyword(tok)) {
                        this.expectZone(lexer);
                        model.setSampleByTimezoneName(this.expectExpr(lexer));
                        tok = this.optTok(lexer);
                        if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                            tok = this.parseWithOffset(lexer, model);
                        } else {
                            model.setSampleByOffset(ZERO_OFFSET);
                        }
                    } else if (SqlKeywords.isWithKeyword(tok)) {
                        tok = this.parseWithOffset(lexer, model);
                    } else {
                        model.setSampleByTimezoneName(null);
                        model.setSampleByOffset(ZERO_OFFSET);
                    }
                } else if (SqlKeywords.isFirstKeyword(tok)) {
                    this.expectObservation(lexer);
                    model.setSampleByTimezoneName(null);
                    model.setSampleByOffset(null);
                    tok = this.optTok(lexer);
                } else {
                    throw SqlException.$(lexer.lastTokenPosition(), "'calendar' or 'first observation' expected");
                }
            }
        }
        if (tok != null && SqlKeywords.isGroupKeyword(tok)) {
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparseLast();
                n = this.expr(lexer, model);
                if (n == null || n.type != 4 && n.type != 2 && n.type != 8 && n.type != 1) {
                    throw SqlException.$(n == null ? lexer.lastTokenPosition() : n.position, "literal expected");
                }
                model.addGroupBy(n);
            } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isOrderKeyword(tok)) {
            model.setOrderByPosition(lexer.lastTokenPosition());
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparseLast();
                n = this.expr(lexer, model);
                if (n == null || n.type == 65 || n.type == 32) {
                    throw SqlException.$(lexer.lastTokenPosition(), "literal or expression expected");
                }
                tok = this.optTok(lexer);
                if (tok != null && SqlKeywords.isDescKeyword(tok)) {
                    model.addOrderBy(n, 1);
                    tok = this.optTok(lexer);
                } else {
                    model.addOrderBy(n, 0);
                    if (tok != null && SqlKeywords.isAscKeyword(tok)) {
                        tok = this.optTok(lexer);
                    }
                }
                if (model.getOrderBy().size() < 1560) continue;
                throw SqlParser.err(lexer, tok, "Too many columns");
            } while (tok != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isLimitKeyword(tok)) {
            model.setLimitPosition(lexer.lastTokenPosition());
            ExpressionNode lo = this.expr(lexer, model);
            ExpressionNode hi = null;
            tok = this.optTok(lexer);
            if (tok != null && Chars.equals(tok, ',')) {
                hi = this.expr(lexer, model);
            } else {
                lexer.unparseLast();
            }
            model.setLimit(lo, hi);
        } else {
            lexer.unparseLast();
        }
    }

    private ExecutionModel parseInsert(GenericLexer lexer) throws SqlException {
        InsertModel model = this.insertModelPool.next();
        CharSequence tok = this.tok(lexer, "into or batch");
        if (SqlKeywords.isBatchKeyword(tok)) {
            long val = this.expectLong(lexer);
            if (val <= 0L) {
                throw SqlException.$(lexer.lastTokenPosition(), "batch size must be positive integer");
            }
            model.setBatchSize(val);
            tok = this.tok(lexer, "into or o3MaxLag");
            if (SqlKeywords.isO3MaxLagKeyword(tok)) {
                int pos = lexer.getPosition();
                model.setO3MaxLag(SqlUtil.expectMicros(this.tok(lexer, "lag value"), pos));
                this.expectTok(lexer, "into");
            }
        }
        if (!SqlKeywords.isIntoKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "'into' expected");
        }
        tok = this.tok(lexer, "table name");
        model.setTableName(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "'(' or 'select'");
        if (Chars.equals(tok, '(')) {
            do {
                if (Chars.equals(tok = this.tok(lexer, "column"), ')')) {
                    throw SqlParser.err(lexer, tok, "missing column name");
                }
                model.addColumn(GenericLexer.unquote(tok), lexer.lastTokenPosition());
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            tok = this.optTok(lexer);
        }
        if (tok == null) {
            throw SqlException.$(lexer.getPosition(), "'select' or 'values' expected");
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            model.setSelectKeywordPosition(lexer.lastTokenPosition());
            lexer.unparseLast();
            QueryModel queryModel = this.parseDml(lexer, null, lexer.lastTokenPosition());
            model.setQueryModel(queryModel);
            return model;
        }
        if (SqlKeywords.isValuesKeyword(tok)) {
            while (true) {
                this.expectTok(lexer, '(');
                ObjList<ExpressionNode> rowValues = new ObjList<ExpressionNode>();
                do {
                    rowValues.add(this.expectExpr(lexer));
                } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
                this.expectTok(tok, lexer.lastTokenPosition(), ')');
                model.addRowTupleValues(rowValues);
                model.addEndOfRowTupleValuesPosition(lexer.lastTokenPosition());
                tok = this.optTok(lexer);
                if (tok == null || Chars.equals(tok, ';')) {
                    return model;
                }
                this.expectTok(tok, lexer.lastTokenPosition(), ',');
            }
        }
        throw SqlParser.err(lexer, tok, "'select' or 'values' expected");
    }

    private QueryModel parseJoin(GenericLexer lexer, CharSequence tok, int joinType, LowerCaseCharSequenceObjHashMap<WithClauseModel> parent) throws SqlException {
        QueryModel joinModel = this.queryModelPool.next();
        int errorPos = lexer.lastTokenPosition();
        if (SqlKeywords.isNotJoinKeyword(tok) && !Chars.equals(tok, ',')) {
            if (SqlKeywords.isLeftKeyword(tok)) {
                tok = this.tok(lexer, "join");
                joinType = 2;
                if (SqlKeywords.isOuterKeyword(tok)) {
                    tok = this.tok(lexer, "join");
                }
            } else {
                tok = this.tok(lexer, "join");
            }
            if (SqlKeywords.isNotJoinKeyword(tok)) {
                throw SqlException.position(errorPos).put("'join' expected");
            }
        }
        joinModel.setJoinType(joinType);
        joinModel.setJoinKeywordPosition(errorPos);
        tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            joinModel.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer, parent));
        } else {
            lexer.unparseLast();
            this.parseSelectFrom(lexer, joinModel, parent);
        }
        tok = this.setModelAliasAndGetOptTok(lexer, joinModel);
        if (joinType == 3 && tok != null && SqlKeywords.isOnKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "Cross joins cannot have join clauses");
        }
        block1 : switch (joinType) {
            case 4: 
            case 5: 
            case 6: {
                if (tok == null || !SqlKeywords.isOnKeyword(tok)) {
                    lexer.unparseLast();
                    break;
                }
            }
            case 1: 
            case 2: {
                this.expectTok(lexer, tok, "on");
                try {
                    this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
                    switch (this.expressionTreeBuilder.size()) {
                        case 0: {
                            throw SqlException.$(lexer.lastTokenPosition(), "Expression expected");
                        }
                        case 1: {
                            ExpressionNode expr = this.expressionTreeBuilder.poll();
                            if (expr.type == 4) {
                                do {
                                    joinModel.addJoinColumn(expr);
                                } while ((expr = this.expressionTreeBuilder.poll()) != null);
                                break;
                            }
                            joinModel.setJoinCriteria(this.rewriteKnownStatements(expr));
                            break;
                        }
                        default: {
                            ExpressionNode expr;
                            while ((expr = this.expressionTreeBuilder.poll()) != null) {
                                if (expr.type != 4) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "Column name expected");
                                }
                                joinModel.addJoinColumn(expr);
                            }
                            break block1;
                        }
                    }
                    break;
                }
                catch (SqlException e) {
                    this.expressionTreeBuilder.reset();
                    throw e;
                }
            }
            default: {
                lexer.unparseLast();
            }
        }
        return joinModel;
    }

    private void parseLatestBy(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok != null) {
            if (SqlKeywords.isByKeyword(tok)) {
                this.parseLatestByDeprecated(lexer, model);
                return;
            }
            if (SqlKeywords.isOnKeyword(tok)) {
                this.parseLatestByNew(lexer, model);
                return;
            }
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'on' or 'by' expected");
    }

    private void parseLatestByDeprecated(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        do {
            model.addLatestBy(this.expectLiteral(lexer));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        model.setLatestByType(1);
        if (tok != null) {
            lexer.unparseLast();
        }
    }

    private void parseLatestByNew(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        ExpressionNode timestamp = this.expectLiteral(lexer);
        model.setTimestamp(timestamp);
        this.expectTok(lexer, "partition");
        this.expectTok(lexer, "by");
        do {
            model.addLatestBy(this.expectLiteral(lexer));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        model.setLatestByType(2);
        if (tok != null) {
            lexer.unparseLast();
        }
    }

    private void parseLikeTableName(GenericLexer lexer, CreateTableModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "table name");
        model.setLikeTableName(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, ")");
        if (!Chars.equals(tok, ')')) {
            throw SqlParser.errUnexpected(lexer, tok);
        }
        tok = this.optTok(lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlParser.errUnexpected(lexer, tok);
        }
    }

    private ExecutionModel parseRenameStatement(GenericLexer lexer) throws SqlException {
        this.expectTok(lexer, "table");
        RenameTableModel model = this.renameTableModelPool.next();
        ExpressionNode e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setFrom(e);
        this.expectTok(lexer, "to");
        e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setTo(e);
        return model;
    }

    private ExecutionModel parseSelect(GenericLexer lexer) throws SqlException {
        lexer.unparseLast();
        QueryModel model = this.parseDml(lexer, null, lexer.lastTokenPosition());
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    private void parseSelectClause(GenericLexer lexer, QueryModel model) throws SqlException {
        block28: {
            CharSequence tok = this.tok(lexer, "[distinct] column");
            if (SqlKeywords.isDistinctKeyword(tok)) {
                model.setDistinct(true);
            } else {
                lexer.unparseLast();
            }
            do {
                CharSequence alias;
                QueryColumn col;
                ExpressionNode expr;
                if (Chars.equals(tok = this.tok(lexer, "column"), '*')) {
                    expr = this.nextLiteral(GenericLexer.immutableOf(tok), lexer.lastTokenPosition());
                } else {
                    if (SqlKeywords.isFromKeyword(tok)) {
                        throw SqlException.$(lexer.getPosition(), "column name expected");
                    }
                    if (SqlKeywords.isSelectKeyword(tok)) {
                        throw SqlException.$(lexer.getPosition(), "reserved name");
                    }
                    lexer.unparseLast();
                    expr = this.expr(lexer, model);
                    if (expr == null) {
                        throw SqlException.$(lexer.lastTokenPosition(), "missing expression");
                    }
                    if (Chars.endsWith(expr.token, '.') && expr.type == 4) {
                        throw SqlException.$(expr.position + expr.token.length(), "'*' or column name expected");
                    }
                }
                tok = this.optTok(lexer);
                int colPosition = lexer.lastTokenPosition();
                if (tok != null && SqlKeywords.isOverKeyword(tok)) {
                    this.expectTok(lexer, '(');
                    col = this.analyticColumnPool.next().of(null, expr);
                    tok = this.tokIncludingLocalBrace(lexer, "'partition' or 'order' or ')'");
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        ObjList<ExpressionNode> partitionBy = ((AnalyticColumn)col).getPartitionBy();
                        do {
                            partitionBy.add(this.expectExpr(lexer));
                        } while (Chars.equals(tok = this.tok(lexer, "'order' or ')'"), ','));
                    }
                    if (SqlKeywords.isOrderKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        do {
                            ExpressionNode orderByExpr = this.expectExpr(lexer);
                            tok = this.tokIncludingLocalBrace(lexer, "'asc' or 'desc'");
                            if (SqlKeywords.isDescKeyword(tok)) {
                                ((AnalyticColumn)col).addOrderBy(orderByExpr, 1);
                                tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                                continue;
                            }
                            ((AnalyticColumn)col).addOrderBy(orderByExpr, 0);
                            if (!SqlKeywords.isAscKeyword(tok)) continue;
                            tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                        } while (Chars.equals(tok, ','));
                    }
                    this.expectTok(tok, lexer.lastTokenPosition(), ')');
                    tok = this.optTok(lexer);
                } else {
                    if (expr.type == 65) {
                        throw SqlException.$(expr.position, "query is not expected, did you mean column?");
                    }
                    col = this.queryColumnPool.next().of(null, expr);
                }
                if (tok != null && Chars.equals(tok, ';')) {
                    alias = this.createColumnAlias(expr, model);
                } else if (tok != null && columnAliasStop.excludes(tok)) {
                    this.assertNotDot(lexer, tok);
                    alias = SqlKeywords.isAsKeyword(tok) ? GenericLexer.unquote(GenericLexer.immutableOf(this.tok(lexer, "alias"))) : GenericLexer.immutableOf(GenericLexer.unquote(tok));
                    tok = this.optTok(lexer);
                } else {
                    alias = this.createColumnAlias(expr, model);
                }
                if (alias.length() == 0) {
                    throw SqlParser.err(lexer, null, "column alias cannot be a blank string");
                }
                col.setAlias(alias);
                if (expr.type == 65) {
                    expr.token = alias;
                }
                model.addBottomUpColumn(colPosition, col, false);
                if (model.getColumns().size() == 1 && tok == null && Chars.equals(expr.token, '*')) {
                    throw SqlParser.err(lexer, null, "'from' expected");
                }
                if (tok == null || Chars.equals(tok, ';')) {
                    lexer.unparseLast();
                } else if (SqlKeywords.isFromKeyword(tok)) {
                    lexer.unparseLast();
                } else {
                    if (!setOperations.contains(tok)) continue;
                    lexer.unparseLast();
                }
                break block28;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, tok, "',', 'from' or 'over' expected");
        }
    }

    private void parseSelectFrom(GenericLexer lexer, QueryModel model, LowerCaseCharSequenceObjHashMap<WithClauseModel> masterModel) throws SqlException {
        ExpressionNode expr = this.expr(lexer, model);
        if (expr == null) {
            throw SqlException.position(lexer.lastTokenPosition()).put("table name expected");
        }
        CharSequence name = expr.token;
        switch (expr.type) {
            case 2: 
            case 4: {
                ExpressionNode literal = this.literal(name, expr.position);
                WithClauseModel withClause = masterModel.get(name);
                if (withClause != null) {
                    model.setNestedModel(this.parseWith(lexer, withClause, masterModel));
                    model.setAlias(literal);
                    break;
                }
                model.setTableNameExpr(literal);
                break;
            }
            case 8: {
                model.setTableNameExpr(expr);
                break;
            }
            default: {
                throw SqlException.$(expr.position, "function, literal or constant is expected");
            }
        }
    }

    private int parseSymbolCapacity(GenericLexer lexer) throws SqlException {
        int errorPosition = lexer.getPosition();
        int symbolCapacity = this.expectInt(lexer);
        TableUtils.validateSymbolCapacity(errorPosition, symbolCapacity);
        return Numbers.ceilPow2(symbolCapacity);
    }

    private ExpressionNode parseTimestamp(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isTimestampKeyword(tok)) {
            this.expectTok(lexer, '(');
            ExpressionNode result = this.expectLiteral(lexer);
            this.tokIncludingLocalBrace(lexer, "')'");
            return result;
        }
        return null;
    }

    private ExecutionModel parseUpdate(GenericLexer lexer) throws SqlException {
        lexer.unparseLast();
        QueryModel model = this.parseDmlUpdate(lexer);
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    private void parseUpdateClause(GenericLexer lexer, QueryModel updateQueryModel, QueryModel fromModel) throws SqlException {
        block4: {
            CharSequence tok = this.tok(lexer, "table name or alias");
            CharSequence tableName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
            ExpressionNode tableNameExpr = ExpressionNode.FACTORY.newInstance().of(4, tableName, 0, 0);
            updateQueryModel.setTableNameExpr(tableNameExpr);
            fromModel.setTableNameExpr(tableNameExpr);
            tok = this.tok(lexer, "AS, SET or table alias expected");
            if (SqlKeywords.isAsKeyword(tok) && SqlKeywords.isSetKeyword(tok = this.tok(lexer, "table alias expected"))) {
                throw SqlException.$(lexer.lastTokenPosition(), "table alias expected");
            }
            if (!SqlKeywords.isAsKeyword(tok) && !SqlKeywords.isSetKeyword(tok)) {
                CharSequence tableAlias = GenericLexer.immutableOf(tok);
                ExpressionNode tableAliasExpr = ExpressionNode.FACTORY.newInstance().of(4, tableAlias, 0, 0);
                updateQueryModel.setAlias(tableAliasExpr);
                tok = this.tok(lexer, "SET expected");
            }
            if (!SqlKeywords.isSetKeyword(tok)) {
                throw SqlException.$(lexer.lastTokenPosition(), "SET expected");
            }
            do {
                tok = this.tok(lexer, "column name");
                CharSequence col = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                int colPosition = lexer.lastTokenPosition();
                this.expectTok(lexer, "=");
                ExpressionNode expr = this.expr(lexer, (QueryModel)null);
                ExpressionNode setColumnExpression = this.expressionNodePool.next().of(4, col, 0, colPosition);
                updateQueryModel.getUpdateExpressions().add(setColumnExpression);
                QueryColumn valueColumn = this.queryColumnPool.next().of(col, expr);
                fromModel.addBottomUpColumn(colPosition, valueColumn, false, "in SET clause");
                tok = this.optTok(lexer);
                if (tok == null) break block4;
            } while (tok.length() == 1 && tok.charAt(0) == ',');
            lexer.unparseLast();
        }
    }

    @NotNull
    private ExecutionModel parseWith(GenericLexer lexer) throws SqlException {
        this.parseWithClauses(lexer, this.topLevelWithModel);
        CharSequence tok = this.tok(lexer, "'select', 'update' or name expected");
        if (SqlKeywords.isSelectKeyword(tok)) {
            lexer.unparseLast();
            return this.parseDml(lexer, null, lexer.lastTokenPosition());
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer);
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'select' | 'update' | 'insert' expected");
    }

    private QueryModel parseWith(GenericLexer lexer, WithClauseModel wcm, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel m = wcm.popModel();
        if (m != null) {
            return m;
        }
        lexer.stash();
        lexer.goToPosition(wcm.getPosition());
        m = this.parseAsSubQueryAndExpectClosingBrace(lexer, withClauses);
        lexer.unstash();
        return m;
    }

    private void parseWithClauses(GenericLexer lexer, LowerCaseCharSequenceObjHashMap<WithClauseModel> model) throws SqlException {
        CharSequence tok;
        do {
            ExpressionNode name = this.expectLiteral(lexer);
            if (name.token.length() == 0) {
                throw SqlException.$(name.position, "empty common table expression name");
            }
            if (model.get(name.token) != null) {
                throw SqlException.$(name.position, "duplicate name");
            }
            this.expectTok(lexer, "as");
            this.expectTok(lexer, '(');
            int lo = lexer.lastTokenPosition();
            WithClauseModel wcm = this.withClauseModelPool.next();
            wcm.of(lo + 1, this.parseAsSubQueryAndExpectClosingBrace(lexer, model));
            model.put(name.token, wcm);
        } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        lexer.unparseLast();
    }

    private CharSequence parseWithOffset(GenericLexer lexer, QueryModel model) throws SqlException {
        this.expectOffset(lexer);
        model.setSampleByOffset(this.expectExpr(lexer));
        CharSequence tok = this.optTok(lexer);
        return tok;
    }

    private ExpressionNode rewriteCase(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCase0Ref);
        return parent;
    }

    private void rewriteCase0(ExpressionNode node) {
        if (node.type == 8 && SqlKeywords.isCaseKeyword(node.token)) {
            int lim;
            ExpressionNode elseExpr;
            this.tempExprNodes.clear();
            ExpressionNode literal = null;
            boolean convertToSwitch = true;
            int paramCount = node.paramCount;
            if (node.paramCount == 2) {
                ExpressionNode that = node.rhs;
                node.of(that.type, that.token, that.precedence, that.position);
                node.paramCount = that.paramCount;
                if (that.paramCount == 2) {
                    node.lhs = that.lhs;
                    node.rhs = that.rhs;
                } else {
                    node.args.clear();
                    node.args.addAll(that.args);
                }
                return;
            }
            if ((paramCount & 1) == 0) {
                elseExpr = node.args.getQuick(0);
                lim = 0;
            } else {
                elseExpr = null;
                lim = -1;
            }
            ExpressionNode first = node.args.getQuick(paramCount - 1);
            if (first.token != null) {
                node.token = "switch";
                return;
            }
            for (int i = paramCount - 2; i > lim; --i) {
                if ((i & 1) == 1) {
                    this.tempExprNodes.add(node.args.getQuick(i));
                    continue;
                }
                ExpressionNode where = node.args.getQuick(i);
                if (where.type == 1 && where.token.charAt(0) == '=') {
                    ExpressionNode thisLiteral;
                    ExpressionNode thisConstant;
                    if (where.lhs.type == 2 && where.rhs.type == 4) {
                        thisConstant = where.lhs;
                        thisLiteral = where.rhs;
                    } else if (where.lhs.type == 4 && where.rhs.type == 2) {
                        thisConstant = where.rhs;
                        thisLiteral = where.lhs;
                    } else {
                        convertToSwitch = false;
                        break;
                    }
                    if (literal == null) {
                        literal = thisLiteral;
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    if (Chars.equals(literal.token, thisLiteral.token)) {
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    convertToSwitch = false;
                    break;
                }
                convertToSwitch = false;
                break;
            }
            if (convertToSwitch) {
                int n = this.tempExprNodes.size();
                node.token = "switch";
                node.args.clear();
                node.args.add(elseExpr);
                for (int i = n - 1; i > -1; --i) {
                    node.args.add(this.tempExprNodes.getQuick(i));
                }
                node.args.add(literal);
                node.paramCount = n + 2;
            } else {
                node.args.remove(paramCount - 1);
                node.paramCount = paramCount - 1;
            }
        }
    }

    private ExpressionNode rewriteConcat(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteConcat0Ref);
        return parent;
    }

    private void rewriteConcat0(ExpressionNode node) {
        if (node.type == 1 && SqlKeywords.isConcatOperator(node.token)) {
            node.type = 8;
            node.token = "concat";
            this.addConcatArgs(node.args, node.rhs);
            this.addConcatArgs(node.args, node.lhs);
            node.paramCount = node.args.size();
        }
    }

    private ExpressionNode rewriteCount(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCount0Ref);
        return parent;
    }

    private void rewriteCount0(ExpressionNode node) {
        if (node.type == 8 && SqlKeywords.isCountKeyword(node.token) && node.paramCount == 1) {
            ExpressionNode that = node.rhs;
            if (Chars.equals(that.token, '*') && that.rhs == null && node.lhs == null) {
                that.paramCount = 0;
                node.rhs = null;
                node.paramCount = 0;
            }
        }
    }

    private ExpressionNode rewriteKnownStatements(ExpressionNode parent) throws SqlException {
        return this.rewritePgCast(this.rewriteConcat(this.rewriteCase(this.rewriteCount(parent))));
    }

    private ExpressionNode rewritePgCast(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewritePgCast0Ref);
        return parent;
    }

    private void rewritePgCast0(ExpressionNode node) {
        if (node.type == 1 && SqlKeywords.isColonColon(node.token)) {
            node.token = "cast";
            node.type = 8;
            node.rhs.type = 2;
            if (SqlKeywords.isFloatKeyword(node.rhs.token) || SqlKeywords.isFloat8Keyword(node.rhs.token)) {
                node.rhs.token = "double";
            } else if (SqlKeywords.isFloat4Keyword(node.rhs.token)) {
                node.rhs.token = "float";
            } else if (SqlKeywords.isDateKeyword(node.rhs.token)) {
                node.token = "to_pg_date";
                node.rhs = node.lhs;
                node.lhs = null;
                node.paramCount = 1;
            }
        }
    }

    private CharSequence setModelAliasAndGetOptTok(GenericLexer lexer, QueryModel joinModel) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok != null && tableAliasStop.excludes(tok)) {
            this.checkSupportedJoinType(lexer, tok);
            if (SqlKeywords.isAsKeyword(tok)) {
                tok = this.tok(lexer, "alias");
            }
            ExpressionNode alias = this.literal(lexer, tok);
            if (alias.token.length() == 0) {
                throw SqlException.position(alias.position).put("Empty table alias");
            }
            joinModel.setAlias(alias);
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private CharSequence setModelAliasAndTimestamp(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.setModelAliasAndGetOptTok(lexer, model);
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            model.setTimestamp(timestamp);
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private int toColumnType(GenericLexer lexer, CharSequence tok) throws SqlException {
        short type = ColumnType.tagOf(tok);
        if (type == -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "unsupported column type: ").put(tok);
        }
        if (23 == type) {
            this.expectTok(lexer, '(');
            int bits = GeoHashUtil.parseGeoHashBits(lexer.lastTokenPosition(), 0, this.expectLiteral((GenericLexer)lexer).token);
            this.expectTok(lexer, ')');
            return ColumnType.getGeoHashTypeWithBits(bits);
        }
        return type;
    }

    @NotNull
    private CharSequence tok(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    @NotNull
    private CharSequence tokIncludingLocalBrace(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    private void validateLiteral(int pos, CharSequence tok) throws SqlException {
        switch (tok.charAt(0)) {
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '`': {
                throw SqlException.position(pos).put("literal expected");
            }
        }
    }

    void clear() {
        this.queryModelPool.clear();
        this.queryColumnPool.clear();
        this.expressionNodePool.clear();
        this.analyticColumnPool.clear();
        this.createTableModelPool.clear();
        this.columnCastModelPool.clear();
        this.renameTableModelPool.clear();
        this.withClauseModelPool.clear();
        this.subQueryMode = false;
        this.characterStore.clear();
        this.insertModelPool.clear();
        this.expressionTreeBuilder.reset();
        this.copyModelPool.clear();
        this.topLevelWithModel.clear();
        this.explainModelPool.clear();
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model) throws SqlException {
        try {
            this.expressionTreeBuilder.pushModel(model);
            this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
            ExpressionNode expressionNode = this.rewriteKnownStatements(this.expressionTreeBuilder.poll());
            return expressionNode;
        }
        catch (SqlException e) {
            this.expressionTreeBuilder.reset();
            throw e;
        }
        finally {
            this.expressionTreeBuilder.popModel();
        }
    }

    void expr(GenericLexer lexer, ExpressionParserListener listener) throws SqlException {
        this.expressionParser.parseExpr(lexer, listener);
    }

    ExecutionModel parse(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'rename' or 'select'");
        if (SqlKeywords.isExplainKeyword(tok)) {
            int format = this.parseExplainOptions(lexer);
            ExecutionModel model = this.parseExplain(lexer, executionContext);
            ExplainModel explainModel = this.explainModelPool.next();
            explainModel.setFormat(format);
            explainModel.setModel(model);
            return explainModel;
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer);
        }
        if (SqlKeywords.isCreateKeyword(tok)) {
            return this.parseCreateStatement(lexer, executionContext);
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer);
        }
        if (SqlKeywords.isRenameKeyword(tok)) {
            return this.parseRenameStatement(lexer);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer);
        }
        if (SqlKeywords.isCopyKeyword(tok)) {
            return this.parseCopy(lexer);
        }
        if (SqlKeywords.isWithKeyword(tok)) {
            return this.parseWith(lexer);
        }
        return this.parseSelect(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryModel parseAsSubQuery(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel model;
        this.subQueryMode = true;
        try {
            model = this.parseDml(lexer, withClauses, lexer.getPosition());
        }
        finally {
            this.subQueryMode = false;
        }
        return model;
    }

    static {
        tableAliasStop.add("where");
        tableAliasStop.add("latest");
        tableAliasStop.add("join");
        tableAliasStop.add("inner");
        tableAliasStop.add("left");
        tableAliasStop.add("outer");
        tableAliasStop.add("asof");
        tableAliasStop.add("splice");
        tableAliasStop.add("lt");
        tableAliasStop.add("cross");
        tableAliasStop.add("sample");
        tableAliasStop.add("order");
        tableAliasStop.add("on");
        tableAliasStop.add("timestamp");
        tableAliasStop.add("limit");
        tableAliasStop.add(")");
        tableAliasStop.add(";");
        tableAliasStop.add("union");
        tableAliasStop.add("group");
        tableAliasStop.add("except");
        tableAliasStop.add("intersect");
        tableAliasStop.add("from");
        columnAliasStop.add("from");
        columnAliasStop.add(",");
        columnAliasStop.add("over");
        columnAliasStop.add("union");
        columnAliasStop.add("except");
        columnAliasStop.add("intersect");
        groupByStopSet.add("order");
        groupByStopSet.add(")");
        groupByStopSet.add(",");
        joinStartSet.put("left", 1);
        joinStartSet.put("join", 1);
        joinStartSet.put("inner", 1);
        joinStartSet.put("left", 2);
        joinStartSet.put("cross", 3);
        joinStartSet.put("asof", 4);
        joinStartSet.put("splice", 5);
        joinStartSet.put("lt", 6);
        joinStartSet.put(",", 3);
        setOperations.add("union");
        setOperations.add("except");
        setOperations.add("intersect");
    }
}

