/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer.analyzers;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class KnownBundleAnalyzer
implements ResourceAnalyzer {
    Processor p = new Processor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnownBundleAnalyzer() {
        Properties properties = new Properties();
        InputStream stream = KnownBundleAnalyzer.class.getResourceAsStream("known-bundles.properties");
        if (stream != null) {
            try {
                properties.load(stream);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        this.p.setProperties(properties);
    }

    public KnownBundleAnalyzer(Properties properties) {
        this.p.getProperties().putAll((Map<?, ?>)properties);
    }

    public void setKnownBundlesExtra(Properties extras) {
        this.p.getProperties().putAll((Map<?, ?>)extras);
    }

    public void analyzeResource(Jar resource, ResourceBuilder rb) throws Exception {
        String bsn = resource.getBsn();
        if (bsn == null) {
            return;
        }
        Version version = Version.parseVersion(resource.getVersion());
        for (String key : this.p.getPropertyKeys(false)) {
            CapReqBuilder b;
            VersionRange range;
            String[] parts = key.split(";");
            if (!bsn.equals(parts[0]) || parts.length > 1 && parts[1].length() == 0 && !(range = new VersionRange(parts[1])).includes(version)) continue;
            String type = null;
            if (parts.length > 2) {
                type = parts[2];
            }
            Parameters capreq = new Parameters(this.p.getProperty(key));
            if (type == null || "cap".equals(type)) {
                for (Map.Entry<String, Attrs> entry : capreq.entrySet()) {
                    b = new CapReqBuilder(entry.getKey(), entry.getValue());
                    rb.addCapability(b);
                }
                continue;
            }
            for (Map.Entry<String, Attrs> entry : capreq.entrySet()) {
                b = new CapReqBuilder(entry.getKey(), entry.getValue());
                rb.addRequirement(b);
            }
        }
    }
}

