/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.ansi;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiOutputStream;

public class AnsiSplitter {
    public static List<String> splitLines(String text, int maxLength, int tabs) throws IOException {
        AnsiOutputStreamSplitter splitter = new AnsiOutputStreamSplitter(maxLength);
        splitter.setTabs(tabs);
        splitter.write(text.getBytes());
        splitter.close();
        return splitter.lines;
    }

    public static String substring(String text, int begin, int end, int tabs) throws IOException {
        AnsiOutputStreamSplitter splitter = new AnsiOutputStreamSplitter(begin, end, Integer.MAX_VALUE);
        splitter.setTabs(tabs);
        splitter.write(text.getBytes());
        splitter.close();
        return (String)splitter.lines.get(0);
    }

    public static int length(String curLine, int tabs) throws IOException {
        AnsiOutputStreamSplitter splitter = new AnsiOutputStreamSplitter(0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        splitter.setTabs(tabs);
        splitter.write(curLine.getBytes());
        return splitter.getRealLength();
    }

    public static String cut(String text, int maxLength, int tabs) throws IOException {
        return AnsiSplitter.splitLines(text, maxLength, tabs).get(0);
    }

    public static AnsiBufferedReader window(InputStream is, int begin, int end, int tabs) throws IOException {
        AnsiBufferedReader reader = new AnsiBufferedReader(is, begin, end, Integer.MAX_VALUE);
        reader.setTabs(tabs);
        return reader;
    }

    public static AnsiBufferedReader splitter(InputStream is, int maxLength, int tabs) throws IOException {
        AnsiBufferedReader reader = new AnsiBufferedReader(is, 0, Integer.MAX_VALUE, maxLength);
        reader.setTabs(tabs);
        return reader;
    }

    static class AnsiOutputStreamSplitter
    extends AnsiOutputStream {
        protected static final int ATTRIBUTE_NEGATIVE_OFF = 27;
        Ansi.Attribute intensity;
        Ansi.Attribute underline;
        Ansi.Attribute blink;
        Ansi.Attribute negative;
        Ansi.Color fg;
        Ansi.Color bg;
        private int begin;
        private int length;
        private int maxLength;
        private int escapeLength;
        private int windowState;
        private int tabs;
        private List<String> lines = new ArrayList<String>();

        public AnsiOutputStreamSplitter(int maxLength) {
            this(0, Integer.MAX_VALUE, maxLength);
        }

        public AnsiOutputStreamSplitter(int begin, int end, int maxLength) {
            super((OutputStream)new ByteArrayOutputStream());
            this.begin = begin;
            this.length = end - begin;
            this.maxLength = maxLength - begin;
            this.windowState = begin > 0 ? 0 : 1;
            this.reset();
        }

        public int getTabs() {
            return this.tabs;
        }

        public void setTabs(int tabs) {
            this.tabs = tabs;
        }

        protected void reset() {
            this.intensity = Ansi.Attribute.INTENSITY_BOLD_OFF;
            this.underline = Ansi.Attribute.UNDERLINE_OFF;
            this.blink = Ansi.Attribute.BLINK_OFF;
            this.negative = Ansi.Attribute.NEGATIVE_OFF;
            this.fg = Ansi.Color.DEFAULT;
            this.bg = Ansi.Color.DEFAULT;
        }

        public int getRealLength() {
            return ((ByteArrayOutputStream)this.out).size() - this.escapeLength;
        }

        public void write(int data) throws IOException {
            if (data == 10) {
                this.flushLine(true);
            } else if (data == 9) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
                do {
                    this.write(32);
                } while ((baos.size() - this.escapeLength) % this.tabs > 0);
            } else {
                if (this.windowState != 2) {
                    super.write(data);
                }
                ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
                if (this.windowState == 0 && baos.size() - this.escapeLength > this.begin) {
                    this.windowState = 1;
                    int nbMissing = baos.size() - this.escapeLength - this.begin;
                    byte[] old = baos.toByteArray();
                    this.beginAttributes();
                    baos.write(old, old.length - nbMissing, nbMissing);
                } else if (this.windowState == 1 && baos.size() - this.escapeLength >= this.length) {
                    this.windowState = 2;
                    this.endAttributes();
                    this.reset();
                }
                if (baos.size() - this.escapeLength >= this.maxLength) {
                    this.flushLine(true);
                }
            }
        }

        public void close() throws IOException {
            if (this.windowState == 0) {
                this.beginAttributes();
            }
            this.flushLine(this.lines.isEmpty());
            super.close();
        }

        private void flushLine(boolean force) throws IOException {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            if (this.windowState == 0) {
                this.beginAttributes();
            }
            if (force || baos.size() > this.escapeLength) {
                this.endAttributes();
                this.lines.add(new String(baos.toByteArray()));
                this.beginAttributes();
            }
            this.windowState = 0;
        }

        private void endAttributes() throws IOException {
            if (this.intensity != Ansi.Attribute.INTENSITY_BOLD_OFF) {
                this.setAttribute(Ansi.Attribute.INTENSITY_BOLD_OFF);
            }
            if (this.underline != Ansi.Attribute.UNDERLINE_OFF) {
                this.setAttribute(Ansi.Attribute.UNDERLINE_OFF);
            }
            if (this.blink != Ansi.Attribute.BLINK_OFF) {
                this.setAttribute(Ansi.Attribute.BLINK_OFF);
            }
            if (this.negative != Ansi.Attribute.NEGATIVE_OFF) {
                this.setAttribute(Ansi.Attribute.NEGATIVE_OFF);
            }
            if (this.fg != Ansi.Color.DEFAULT) {
                this.setAttributeFg(Ansi.Color.DEFAULT);
            }
            if (this.bg != Ansi.Color.DEFAULT) {
                this.setAttributeBg(Ansi.Color.DEFAULT);
            }
        }

        private void beginAttributes() throws IOException {
            ((ByteArrayOutputStream)this.out).reset();
            this.escapeLength = 0;
            if (this.intensity != Ansi.Attribute.INTENSITY_BOLD_OFF) {
                this.setAttribute(this.intensity);
            }
            if (this.underline != Ansi.Attribute.UNDERLINE_OFF) {
                this.setAttribute(this.underline);
            }
            if (this.blink != Ansi.Attribute.BLINK_OFF) {
                this.setAttribute(this.blink);
            }
            if (this.negative != Ansi.Attribute.NEGATIVE_OFF) {
                this.setAttribute(this.negative);
            }
            if (this.fg != Ansi.Color.DEFAULT) {
                this.setAttributeFg(this.fg);
            }
            if (this.bg != Ansi.Color.DEFAULT) {
                this.setAttributeBg(this.bg);
            }
        }

        protected void processAttributeRest() throws IOException {
            this.setAttribute(Ansi.Attribute.RESET);
            this.reset();
        }

        protected void processSetAttribute(int attribute) throws IOException {
            switch (attribute) {
                case 1: {
                    this.setIntensity(Ansi.Attribute.INTENSITY_BOLD);
                    break;
                }
                case 2: {
                    this.setIntensity(Ansi.Attribute.INTENSITY_FAINT);
                    break;
                }
                case 22: {
                    this.setIntensity(Ansi.Attribute.INTENSITY_BOLD_OFF);
                    break;
                }
                case 4: {
                    this.setUnderline(Ansi.Attribute.UNDERLINE);
                    break;
                }
                case 21: {
                    this.setUnderline(Ansi.Attribute.UNDERLINE_DOUBLE);
                    break;
                }
                case 24: {
                    this.setUnderline(Ansi.Attribute.UNDERLINE_OFF);
                    break;
                }
                case 25: {
                    this.setBlink(Ansi.Attribute.BLINK_OFF);
                    break;
                }
                case 5: {
                    this.setBlink(Ansi.Attribute.BLINK_SLOW);
                    break;
                }
                case 6: {
                    this.setBlink(Ansi.Attribute.BLINK_FAST);
                    break;
                }
                case 7: {
                    this.setNegative(Ansi.Attribute.NEGATIVE_ON);
                    break;
                }
                case 27: {
                    this.setNegative(Ansi.Attribute.NEGATIVE_OFF);
                    break;
                }
            }
        }

        protected void processSetForegroundColor(int color) throws IOException {
            Ansi.Color c;
            switch (color) {
                case 0: {
                    c = Ansi.Color.BLACK;
                    break;
                }
                case 1: {
                    c = Ansi.Color.RED;
                    break;
                }
                case 2: {
                    c = Ansi.Color.GREEN;
                    break;
                }
                case 3: {
                    c = Ansi.Color.YELLOW;
                    break;
                }
                case 4: {
                    c = Ansi.Color.BLUE;
                    break;
                }
                case 5: {
                    c = Ansi.Color.MAGENTA;
                    break;
                }
                case 6: {
                    c = Ansi.Color.CYAN;
                    break;
                }
                case 7: {
                    c = Ansi.Color.WHITE;
                    break;
                }
                case 9: {
                    c = Ansi.Color.DEFAULT;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.fg != c) {
                this.fg = c;
                this.setAttributeFg(c);
            }
        }

        protected void processSetBackgroundColor(int color) throws IOException {
            Ansi.Color c;
            switch (color) {
                case 0: {
                    c = Ansi.Color.BLACK;
                    break;
                }
                case 1: {
                    c = Ansi.Color.RED;
                    break;
                }
                case 2: {
                    c = Ansi.Color.GREEN;
                    break;
                }
                case 3: {
                    c = Ansi.Color.YELLOW;
                    break;
                }
                case 4: {
                    c = Ansi.Color.BLUE;
                    break;
                }
                case 5: {
                    c = Ansi.Color.MAGENTA;
                    break;
                }
                case 6: {
                    c = Ansi.Color.CYAN;
                    break;
                }
                case 7: {
                    c = Ansi.Color.WHITE;
                    break;
                }
                case 9: {
                    c = Ansi.Color.DEFAULT;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.bg != c) {
                this.bg = c;
                this.setAttributeBg(c);
            }
        }

        protected void processDefaultTextColor() throws IOException {
            this.processSetForegroundColor(9);
        }

        protected void processDefaultBackgroundColor() throws IOException {
            this.processSetBackgroundColor(9);
        }

        protected void setIntensity(Ansi.Attribute intensity) throws IOException {
            if (this.intensity != intensity) {
                this.intensity = intensity;
                this.setAttribute(intensity);
            }
        }

        protected void setUnderline(Ansi.Attribute underline) throws IOException {
            if (this.underline != underline) {
                this.underline = underline;
                this.setAttribute(underline);
            }
        }

        protected void setBlink(Ansi.Attribute blink) throws IOException {
            if (this.blink != blink) {
                this.blink = blink;
                this.setAttribute(blink);
            }
        }

        protected void setNegative(Ansi.Attribute negative) throws IOException {
            if (this.negative != negative) {
                this.negative = negative;
                this.setAttribute(negative);
            }
        }

        private void setAttributeFg(Ansi.Color color) throws IOException {
            String sequence = Ansi.ansi().fg(color).toString();
            this.escapeLength += sequence.length();
            this.out.write(sequence.getBytes());
        }

        private void setAttributeBg(Ansi.Color color) throws IOException {
            String sequence = Ansi.ansi().bg(color).toString();
            this.escapeLength += sequence.length();
            this.out.write(sequence.getBytes());
        }

        private void setAttribute(Ansi.Attribute attribute) throws IOException {
            String sequence = Ansi.ansi().a(attribute).toString();
            this.escapeLength += sequence.length();
            this.out.write(sequence.getBytes());
        }
    }

    public static class AnsiBufferedReader
    implements Closeable {
        private final InputStream in;
        private final AnsiOutputStreamSplitter splitter;

        public AnsiBufferedReader(InputStream in, int begin, int end, int maxLength) {
            this.in = in;
            this.splitter = new AnsiOutputStreamSplitter(begin, end, maxLength);
        }

        public String readLine() throws IOException {
            while (this.splitter.lines.isEmpty()) {
                int c = this.in.read();
                if (c < 0) {
                    this.splitter.flushLine(false);
                    break;
                }
                this.splitter.write(c);
            }
            if (this.splitter.lines.isEmpty()) {
                return null;
            }
            return (String)this.splitter.lines.remove(0);
        }

        @Override
        public void close() throws IOException {
        }

        public void setTabs(int tabs) {
            this.splitter.setTabs(tabs);
        }
    }
}

