/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RemoveDataNodeHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrationPlan;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.RemoveDataNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataNodesProcedure
extends AbstractNodeProcedure<RemoveDataNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveDataNodesProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private List<TDataNodeLocation> removedDataNodes;
    private List<RegionMigrationPlan> regionMigrationPlans = new ArrayList<RegionMigrationPlan>();
    private Map<Integer, NodeStatus> nodeStatusMap;

    public RemoveDataNodesProcedure() {
    }

    public RemoveDataNodesProcedure(List<TDataNodeLocation> removedDataNodes, Map<Integer, NodeStatus> nodeStatusMap) {
        this.removedDataNodes = removedDataNodes;
        this.nodeStatusMap = nodeStatusMap;
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOG.info("procedureId {}-RemoveDataNodes skips acquiring lock, since upper layer ensures the serial execution.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOG.info("procedureId {}-RemoveDataNodes skips releasing lock, since it hasn't acquire any lock.", (Object)this.getProcId());
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) {
        block14: {
            if (this.removedDataNodes.isEmpty()) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            RemoveDataNodeHandler removeDataNodeHandler = env.getRemoveDataNodeHandler();
            try {
                switch (state) {
                    case REGION_REPLICA_CHECK: {
                        if (removeDataNodeHandler.checkEnoughDataNodeAfterRemoving(this.removedDataNodes)) {
                            this.setNextState(RemoveDataNodeState.REMOVE_DATA_NODE_PREPARE);
                        } else {
                            LOG.error("{}, Can not remove DataNode {} because the number of DataNodes is less or equal than region replica number", (Object)"[REMOVE_DATANODE_PROCESS]", this.removedDataNodes);
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                    }
                    case REMOVE_DATA_NODE_PREPARE: {
                        HashMap<Integer, NodeStatus> removedNodeStatusMap = new HashMap<Integer, NodeStatus>();
                        this.removedDataNodes.forEach(dataNode -> removedNodeStatusMap.put(dataNode.getDataNodeId(), NodeStatus.Removing));
                        removeDataNodeHandler.changeDataNodeStatus(this.removedDataNodes, removedNodeStatusMap);
                        this.regionMigrationPlans = removeDataNodeHandler.selectedRegionMigrationPlans(this.removedDataNodes);
                        LOG.info("{}, DataNode regions to be removed is {}", (Object)"[REMOVE_DATANODE_PROCESS]", this.regionMigrationPlans);
                        this.setNextState(RemoveDataNodeState.BROADCAST_DISABLE_DATA_NODE);
                        break;
                    }
                    case BROADCAST_DISABLE_DATA_NODE: {
                        removeDataNodeHandler.broadcastDataNodeStatusChange(this.removedDataNodes);
                        this.setNextState(RemoveDataNodeState.SUBMIT_REGION_MIGRATE);
                        break;
                    }
                    case SUBMIT_REGION_MIGRATE: {
                        if (!this.isStateDeserialized()) {
                            this.submitChildRegionMigrate(env);
                        }
                        this.setNextState(RemoveDataNodeState.STOP_DATA_NODE);
                        break;
                    }
                    case STOP_DATA_NODE: {
                        this.checkRegionStatusAndStopDataNode(env);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Remove Data Node failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to remove data node {}, state {}", new Object[]{this.removedDataNodes, state, e});
                if (this.getCycles() <= 5) break block14;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void submitChildRegionMigrate(ConfigNodeProcedureEnv env) {
        this.regionMigrationPlans.forEach(regionMigrationPlan -> {
            TConsensusGroupId regionId = regionMigrationPlan.getRegionId();
            TDataNodeLocation removedDataNode = regionMigrationPlan.getFromDataNode();
            TDataNodeLocation destDataNode = regionMigrationPlan.getToDataNode();
            TDataNodeLocation coordinatorForAddPeer = env.getRegionMaintainHandler().filterDataNodeWithOtherRegionReplica(regionId, destDataNode).orElse(removedDataNode);
            TDataNodeLocation coordinatorForRemovePeer = destDataNode;
            if (destDataNode != null) {
                RegionMigrateProcedure regionMigrateProcedure = new RegionMigrateProcedure(regionId, removedDataNode, destDataNode, coordinatorForAddPeer, coordinatorForRemovePeer);
                this.addChildProcedure(regionMigrateProcedure);
                LOG.info("Submit RegionMigrateProcedure for regionId {}: removedDataNode={}, destDataNode={}, coordinatorForAddPeer={}, coordinatorForRemovePeer={}", new Object[]{regionId, this.simplifyTDataNodeLocation(removedDataNode), this.simplifyTDataNodeLocation(destDataNode), this.simplifyTDataNodeLocation(coordinatorForAddPeer), this.simplifyTDataNodeLocation(coordinatorForRemovePeer)});
            } else {
                LOG.error("{}, Cannot find target DataNode to migrate the region: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)regionId);
            }
        });
    }

    private String simplifyTDataNodeLocation(TDataNodeLocation dataNodeLocation) {
        return String.format("DataNode(id:%d, address:%s)", dataNodeLocation.getDataNodeId(), dataNodeLocation.getInternalEndPoint().getIp());
    }

    private void checkRegionStatusAndStopDataNode(ConfigNodeProcedureEnv env) {
        List<TRegionReplicaSet> replicaSets = env.getConfigManager().getPartitionManager().getAllReplicaSets();
        ArrayList<TDataNodeLocation> rollBackDataNodes = new ArrayList<TDataNodeLocation>();
        ArrayList<TDataNodeLocation> successDataNodes = new ArrayList<TDataNodeLocation>();
        for (TDataNodeLocation dataNode : this.removedDataNodes) {
            List migratedFailedRegions = replicaSets.stream().filter(replica -> replica.getDataNodeLocations().stream().anyMatch(loc -> loc.getDataNodeId() == dataNode.dataNodeId)).map(TRegionReplicaSet::getRegionId).collect(Collectors.toList());
            if (!migratedFailedRegions.isEmpty()) {
                LOG.warn("{}, Some regions are migrated failed in DataNode: {}, migratedFailedRegions: {}.Regions that have been successfully migrated will not roll back, you can submit the RemoveDataNodes task again later.", new Object[]{"[REMOVE_DATANODE_PROCESS]", dataNode, migratedFailedRegions});
                rollBackDataNodes.add(dataNode);
                continue;
            }
            successDataNodes.add(dataNode);
        }
        if (!successDataNodes.isEmpty()) {
            LOG.info("{}, DataNodes: {} all regions migrated successfully, start to stop them.", (Object)"[REMOVE_DATANODE_PROCESS]", successDataNodes);
            env.getRemoveDataNodeHandler().removeDataNodePersistence(successDataNodes);
            env.getRemoveDataNodeHandler().stopDataNodes(successDataNodes);
        }
        if (!rollBackDataNodes.isEmpty()) {
            LOG.info("{}, Start to roll back the DataNodes status: {}", (Object)"[REMOVE_DATANODE_PROCESS]", rollBackDataNodes);
            env.getRemoveDataNodeHandler().changeDataNodeStatus(rollBackDataNodes, this.nodeStatusMap);
            env.getRemoveDataNodeHandler().broadcastDataNodeStatusChange(rollBackDataNodes);
            LOG.info("{}, Roll back the DataNodes status successfully: {}", (Object)"[REMOVE_DATANODE_PROCESS]", rollBackDataNodes);
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RemoveDataNodeState state) {
        return false;
    }

    @Override
    protected boolean holdLock(ConfigNodeProcedureEnv env) {
        return true;
    }

    @Override
    protected RemoveDataNodeState getState(int stateId) {
        return RemoveDataNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveDataNodeState removeDataNodeState) {
        return removeDataNodeState.ordinal();
    }

    @Override
    protected RemoveDataNodeState getInitialState() {
        return RemoveDataNodeState.REGION_REPLICA_CHECK;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REMOVE_DATA_NODE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        stream.writeInt(this.removedDataNodes.size());
        this.removedDataNodes.forEach(dataNode -> ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)dataNode, (DataOutputStream)stream));
        stream.writeInt(this.regionMigrationPlans.size());
        for (RegionMigrationPlan regionMigrationPlan : this.regionMigrationPlans) {
            regionMigrationPlan.serialize(stream);
        }
        stream.writeInt(this.nodeStatusMap.size());
        for (Map.Entry entry : this.nodeStatusMap.entrySet()) {
            stream.writeInt((Integer)entry.getKey());
            stream.writeByte(((NodeStatus)entry.getValue()).ordinal());
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            int removedDataNodeSize = byteBuffer.getInt();
            this.removedDataNodes = new ArrayList<TDataNodeLocation>(removedDataNodeSize);
            for (int i = 0; i < removedDataNodeSize; ++i) {
                this.removedDataNodes.add(ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer));
            }
            int regionMigrationPlanSize = byteBuffer.getInt();
            this.regionMigrationPlans = new ArrayList<RegionMigrationPlan>(regionMigrationPlanSize);
            for (int i = 0; i < regionMigrationPlanSize; ++i) {
                this.regionMigrationPlans.add(RegionMigrationPlan.deserialize(byteBuffer));
            }
            int nodeStatusMapSize = byteBuffer.getInt();
            this.nodeStatusMap = new HashMap<Integer, NodeStatus>(nodeStatusMapSize);
            for (int i = 0; i < nodeStatusMapSize; ++i) {
                int dataNodeId = byteBuffer.getInt();
                NodeStatus nodeStatus = NodeStatus.values()[byteBuffer.get()];
                this.nodeStatusMap.put(dataNodeId, nodeStatus);
            }
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RemoveDataNodesProcedure) {
            RemoveDataNodesProcedure thatProc = (RemoveDataNodesProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.removedDataNodes.equals(this.removedDataNodes) && thatProc.regionMigrationPlans.equals(this.regionMigrationPlans);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.removedDataNodes, this.regionMigrationPlans);
    }

    public List<TDataNodeLocation> getRemovedDataNodes() {
        return this.removedDataNodes;
    }
}

