/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.io;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;

public abstract class PageIo {
    public static final int MAX_IO_TYPE = 65534;
    public static final int TYPE_OFF = 0;
    public static final int VER_OFF = 2;
    public static final int CRC_OFF = 4;
    public static final int PAGE_ID_OFF = 8;
    public static final int ROTATED_ID_PART_OFF = 16;
    private static final int COMPRESSION_TYPE_OFF = 17;
    private static final int COMPRESSED_SIZE_OFF = 18;
    private static final int COMPACTED_SIZE_OFF = 20;
    private static final int RESERVED_SHORT_OFF = 22;
    private static final int RESERVED_2_OFF = 24;
    private static final int RESERVED_3_OFF = 32;
    public static final int COMMON_HEADER_END = 40;
    private final int ver;
    private final int type;
    private final byte flag;

    protected PageIo(int type, int ver, byte flag) {
        assert (ver > 0 && ver <= 65534) : ver;
        assert (type > 0 && type <= 65534) : type;
        assert (flag == 1 || flag == 2);
        this.type = type;
        this.ver = ver;
        this.flag = flag;
    }

    public final int getType() {
        return this.type;
    }

    public static int getType(ByteBuffer buf) {
        return buf.getShort(0) & 0xFFFF;
    }

    public static int getType(long pageAddr) {
        return PageUtils.getShort(pageAddr, 0) & 0xFFFF;
    }

    protected static void setType(long pageAddr, int type) {
        PageUtils.putShort(pageAddr, 0, (short)type);
        assert (PageIo.getType(pageAddr) == type) : PageIo.getType(pageAddr);
    }

    public final int getVersion() {
        return this.ver;
    }

    public static int getVersion(ByteBuffer buf) {
        return buf.getShort(2) & 0xFFFF;
    }

    public static int getVersion(long pageAddr) {
        return PageUtils.getShort(pageAddr, 2) & 0xFFFF;
    }

    protected static void setVersion(long pageAddr, int ver) {
        PageUtils.putShort(pageAddr, 2, (short)ver);
        assert (PageIo.getVersion(pageAddr) == ver);
    }

    public static long getPageId(ByteBuffer buf) {
        return buf.getLong(8);
    }

    public static long getPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 8);
    }

    public static void setPageId(long pageAddr, long pageId) {
        PageUtils.putLong(pageAddr, 8, pageId);
        assert (PageIo.getPageId(pageAddr) == pageId);
    }

    public static int getRotatedIdPart(long pageAddr) {
        return PageUtils.getUnsignedByte(pageAddr, 16);
    }

    public static void setRotatedIdPart(long pageAddr, int rotatedIdPart) {
        PageUtils.putUnsignedByte(pageAddr, 16, rotatedIdPart);
        assert (PageIo.getRotatedIdPart(pageAddr) == rotatedIdPart);
    }

    public static void setCompressionType(ByteBuffer page, byte compressType) {
        page.put(17, compressType);
    }

    public static byte getCompressionType(ByteBuffer page) {
        return page.get(17);
    }

    public static byte getCompressionType(long pageAddr) {
        return PageUtils.getByte(pageAddr, 17);
    }

    public static void setCompressedSize(ByteBuffer page, short compressedSize) {
        page.putShort(18, compressedSize);
    }

    public static short getCompressedSize(ByteBuffer page) {
        return page.getShort(18);
    }

    public static short getCompressedSize(long pageAddr) {
        return PageUtils.getShort(pageAddr, 18);
    }

    public static void setCompactedSize(ByteBuffer page, short compactedSize) {
        page.putShort(20, compactedSize);
    }

    public static short getCompactedSize(ByteBuffer page) {
        return page.getShort(20);
    }

    public static short getCompactedSize(long pageAddr) {
        return PageUtils.getShort(pageAddr, 20);
    }

    public static void setCrc(ByteBuffer buf, int crc) {
        buf.putInt(4, crc);
    }

    public static void setCrc(long pageAddr, int crc) {
        PageUtils.putInt(pageAddr, 4, crc);
    }

    public static int getCrc(ByteBuffer buf) {
        return buf.getInt(4);
    }

    public static int getCrc(long pageAddr) {
        return PageUtils.getInt(pageAddr, 4);
    }

    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        PageIo.setType(pageAddr, this.getType());
        PageIo.setVersion(pageAddr, this.getVersion());
        PageIo.setPageId(pageAddr, pageId);
        PageIo.setCrc(pageAddr, 0);
        PageUtils.putLong(pageAddr, 16, 0L);
        PageUtils.putLong(pageAddr, 24, 0L);
        PageUtils.putLong(pageAddr, 32, 0L);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ver=" + this.getVersion() + "]";
    }

    protected final void copyPage(ByteBuffer page, ByteBuffer out, int pageSize) {
        assert (out.position() == 0);
        assert (pageSize <= out.remaining());
        assert (pageSize == page.remaining());
        PageUtils.copyMemory(page, 0L, out, 0L, (long)pageSize);
        out.limit(pageSize);
    }

    protected abstract void printPage(long var1, int var3, IgniteStringBuilder var4) throws IgniteInternalCheckedException;

    public static String printPage(PageIoRegistry pageIoRegistry, long pageAddr, int pageSize) {
        IgniteStringBuilder sb = new IgniteStringBuilder("Header [\n\ttype=");
        try {
            Object io = pageIoRegistry.resolve(pageAddr);
            sb.app(PageIo.getType(pageAddr)).app(" (").app(io.getClass().getSimpleName()).app("),\n\tver=").app(PageIo.getVersion(pageAddr)).app(",\n\tcrc=").app(PageIo.getCrc(pageAddr)).app(",\n\t").app(PageIdUtils.toDetailString(PageIo.getPageId(pageAddr))).app("\n],\n");
            if (PageIo.getCompressionType(pageAddr) != 0) {
                sb.app("CompressedPage[\n\tcompressionType=").app(PageIo.getCompressionType(pageAddr)).app(",\n\tcompressedSize=").app(PageIo.getCompressedSize(pageAddr)).app(",\n\tcompactedSize=").app(PageIo.getCompactedSize(pageAddr)).app("\n]");
            } else {
                ((PageIo)io).printPage(pageAddr, pageSize, sb);
            }
        }
        catch (IgniteInternalCheckedException e) {
            sb.app("Failed to print page: ").app(e.getMessage());
        }
        return sb.toString();
    }

    protected final void assertPageType(long pageAddr) {
        assert (PageIo.getType(pageAddr) == this.getType()) : "Expected type " + this.getType() + ", but got " + PageIo.getType(pageAddr);
    }

    protected final void assertPageType(ByteBuffer buf) {
        assert (PageIo.getType(buf) == this.getType()) : "Expected type " + this.getType() + ", but got " + PageIo.getType(buf);
    }

    public final byte getFlag() {
        return this.flag;
    }
}

