/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.internal.catalog.storage.DropColumnsEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataOutput;

public class DropColumnsEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class DropColumnEntrySerializerV2
    implements CatalogObjectSerializer<DropColumnsEntry> {
        DropColumnEntrySerializerV2() {
        }

        @Override
        public DropColumnsEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            Set columns = input.readObjectCollection(IgniteUnsafeDataInput::readUTF, size -> new HashSet(IgniteUtils.capacity(size)));
            return new DropColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(DropColumnsEntry object, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(object.tableId());
            output.writeObjectCollection(IgniteUnsafeDataOutput::writeUTF, object.columns());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class DropColumnEntrySerializerV1
    implements CatalogObjectSerializer<DropColumnsEntry> {
        DropColumnEntrySerializerV1() {
        }

        @Override
        public DropColumnsEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            Set columns = CatalogSerializationUtils.readStringCollection(input, size -> new HashSet(IgniteUtils.capacity(size)));
            return new DropColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(DropColumnsEntry object, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(object.tableId());
            CatalogSerializationUtils.writeStringCollection(object.columns(), output);
        }
    }
}

