/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUpdateImpl;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;

final class DirectUpdateDoublesSketch
extends UpdatableQuantilesDoublesSketch {
    private static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    private MemorySegmentRequest mSegReq_ = null;
    private MemorySegment seg_;

    private DirectUpdateDoublesSketch(int k, MemorySegment seg, MemorySegmentRequest mSegReq) {
        super(k);
        this.mSegReq_ = mSegReq;
        this.seg_ = seg;
    }

    static DirectUpdateDoublesSketch newInstance(int k, MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(dstSeg, "The MemorySegment dstSeg must not be null");
        long segCap = dstSeg.byteSize();
        DirectUpdateDoublesSketch.checkDirectSegCapacity(k, 0L, segCap);
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, 0L);
        PreambleUtil.insertPreLongs(dstSeg, 2);
        PreambleUtil.insertSerVer(dstSeg, 3);
        PreambleUtil.insertFamilyID(dstSeg, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(dstSeg, 4);
        PreambleUtil.insertK(dstSeg, k);
        if (segCap >= 32L) {
            PreambleUtil.insertN(dstSeg, 0L);
            PreambleUtil.insertMinDouble(dstSeg, Double.NaN);
            PreambleUtil.insertMaxDouble(dstSeg, Double.NaN);
        }
        return new DirectUpdateDoublesSketch(k, dstSeg, mSegReq);
    }

    static DirectUpdateDoublesSketch wrapInstance(MemorySegment srcSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(srcSeg, "The source MemorySegment must not be null");
        long segCap = srcSeg.byteSize();
        int preLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        int flags = PreambleUtil.extractFlags(srcSeg);
        int k = PreambleUtil.extractK(srcSeg);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcSeg);
        DirectUpdateDoublesSketch.checkPreLongs(preLongs);
        ClassicUtil.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectUpdateDoublesSketch.checkDirectFlags(flags);
        ClassicUtil.checkK(k);
        DirectUpdateDoublesSketch.checkCompact(serVer, flags);
        DirectUpdateDoublesSketch.checkDirectSegCapacity(k, n, segCap);
        DirectUpdateDoublesSketch.checkEmptyAndN(empty, n);
        return new DirectUpdateDoublesSketch(k, srcSeg, mSegReq);
    }

    @Override
    public double getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
    }

    @Override
    public double getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
    }

    @Override
    public long getN() {
        return this.seg_.byteSize() < 32L ? 0L : this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.seg_ != null;
    }

    @Override
    public boolean isOffHeap() {
        return this.seg_ != null ? this.seg_.isNative() : false;
    }

    @Override
    public boolean isReadOnly() {
        return this.seg_.isReadOnly();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.seg_, that);
    }

    @Override
    public void update(double dataItem) {
        int combBufItemCap;
        if (Double.isNaN(dataItem)) {
            return;
        }
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        int curBBCount = this.getBaseBufferCount();
        int newBBCount = curBBCount + 1;
        if (newBBCount > (combBufItemCap = this.getCombinedBufferItemCapacity())) {
            this.seg_ = this.growCombinedSegBuffer(2 * this.getK());
        }
        long curN = this.getN();
        long newN = curN + 1L;
        if (curN == 0L) {
            this.putMaxItem(dataItem);
            this.putMinItem(dataItem);
        } else {
            if (dataItem > this.getMaxItem()) {
                this.putMaxItem(dataItem);
            }
            if (dataItem < this.getMinItem()) {
                this.putMinItem(dataItem);
            }
        }
        this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L + (long)curBBCount * 8L, dataItem);
        this.seg_.set(ValueLayout.JAVA_BYTE, 3L, (byte)0);
        if (newBBCount == 2 * this.k_) {
            int curSegItemCap = this.getCombinedBufferItemCapacity();
            int itemSpaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(this.k_, newN);
            if (itemSpaceNeeded > curSegItemCap) {
                this.seg_ = this.growCombinedSegBuffer(itemSpaceNeeded);
            }
            DoublesSketchAccessor bbAccessor = DoublesSketchAccessor.wrap(this, true);
            bbAccessor.sort();
            long newBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(0, null, bbAccessor, true, this.k_, DoublesSketchAccessor.wrap(this, true), this.getBitPattern());
            assert (newBitPattern == ClassicUtil.computeBitPattern(this.k_, newN));
        }
        this.putN(newN);
        this.doublesSV = null;
    }

    @Override
    public void reset() {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        if (this.seg_.byteSize() >= 32L) {
            this.seg_.set(ValueLayout.JAVA_BYTE, 3L, (byte)4);
            this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, 0L);
            this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L, Double.NaN);
            this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L, Double.NaN);
        }
    }

    @Override
    int getBaseBufferCount() {
        return ClassicUtil.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return ClassicUtil.computeBitPattern(k, n);
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = ClassicUtil.computeCombinedBufferItemCapacity(k, n);
        double[] combinedBuffer = new double[itemCap];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return Math.max(0, (int)this.seg_.byteSize() - 32) / 8;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg_;
    }

    @Override
    UpdatableQuantilesDoublesSketch getSketchAndReset() {
        HeapUpdateDoublesSketch skCopy = HeapUpdateDoublesSketch.heapifyInstance(this.seg_);
        this.reset();
        return skCopy;
    }

    @Override
    double[] growCombinedBuffer(int curCombBufItemCap, int itemSpaceNeeded) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        this.seg_ = this.growCombinedSegBuffer(itemSpaceNeeded);
        double[] newCombBuf = new double[itemSpaceNeeded];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L, newCombBuf, 0, curCombBufItemCap);
        return newCombBuf;
    }

    @Override
    void putMinItem(double minQuantile) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        assert (this.seg_.byteSize() >= 32L);
        this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L, minQuantile);
    }

    @Override
    void putMaxItem(double maxQuantile) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        assert (this.seg_.byteSize() >= 32L);
        this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L, maxQuantile);
    }

    @Override
    void putN(long n) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        assert (this.seg_.byteSize() >= 32L);
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, n);
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
        MemorySegment.copy(combinedBuffer, 0, this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L, combinedBuffer.length);
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
    }

    @Override
    void putBitPattern(long bitPattern) {
        if (this.seg_.isReadOnly()) {
            throw new SketchesReadOnlyException("This sketch is read only.");
        }
    }

    private MemorySegment growCombinedSegBuffer(int itemSpaceNeeded) {
        long segBytes = this.seg_.byteSize();
        int needBytes = (itemSpaceNeeded << 3) + 32;
        assert ((long)needBytes > segBytes);
        this.mSegReq_ = this.mSegReq_ == null ? MemorySegmentRequest.DEFAULT : this.mSegReq_;
        MemorySegment newSeg = this.mSegReq_.request(needBytes);
        MemorySegment.copy(this.seg_, 0L, newSeg, 0L, segBytes);
        this.mSegReq_.requestClose(this.seg_);
        return newSeg;
    }

    static void checkDirectSegCapacity(int k, long n, long segCapBytes) {
        int reqBufBytes = DirectUpdateDoublesSketch.getUpdatableStorageBytes(k, n);
        if (segCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: MemorySegment capacity too small: " + segCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        boolean compact;
        boolean bl = compact = serVer == 2 || (flags & 8) > 0;
        if (compact) {
            throw new SketchesArgumentException("MemorySegment is in compact form and is not supported for this writableWrap Instance.");
        }
    }

    static void checkPreLongs(int preLongs) {
        if (preLongs < 1 || preLongs > 2) {
            throw new SketchesArgumentException("Possible corruption: PreLongs must be 1 or 2: " + preLongs);
        }
    }

    static void checkDirectFlags(int flags) {
        int allowedFlags = 22;
        int flagsMask = -23;
        if ((flags & 0xFFFFFFE9) > 0) {
            throw new SketchesArgumentException("Possible corruption: Invalid flags field: Cannot be compact! " + Integer.toBinaryString(flags));
        }
    }

    static void checkEmptyAndN(boolean empty, long n) {
        if (empty && n > 0L) {
            throw new SketchesArgumentException("Possible corruption: Empty Flag = true and N > 0: " + n);
        }
    }
}

