/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectLongsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactLongsSketchTest {
    private static final boolean enablePrinting = false;

    @Test
    public void checkRODirectUpdatable_ROandWritable() {
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment srcSeg = MemorySegment.ofArray(byteArr).asReadOnly();
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)srcSeg);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectLongsSketch));
        Assert.assertTrue((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)21L);
        MemorySegment srcWseg = MemorySegment.ofArray(byteArr);
        KllLongsSketch sk3 = KllLongsSketch.wrap((MemorySegment)srcWseg);
        Assert.assertTrue((boolean)(sk3 instanceof KllDirectLongsSketch));
        KllDirectCompactLongsSketchTest.println(sk3.toString(true, false));
        Assert.assertFalse((boolean)sk3.isReadOnly());
        sk3.update(22L);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)22L);
    }

    @Test
    public void checkRODirectCompact() {
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        MemorySegment srcSeg = MemorySegment.ofArray(sk.toByteArray());
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)srcSeg);
        Assert.assertTrue((boolean)sk2.hasMemorySegment());
        Assert.assertTrue((sk2.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sk2.isCompactMemorySegmentFormat());
        Assert.assertFalse((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)21L);
        MemorySegment srcSeg2 = MemorySegment.ofArray(sk2.toByteArray());
        KllLongsSketch sk3 = KllLongsSketch.wrap((MemorySegment)srcSeg2);
        Assert.assertTrue((boolean)sk2.hasMemorySegment());
        Assert.assertTrue((sk2.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sk2.isCompactMemorySegmentFormat());
        Assert.assertFalse((boolean)sk2.isMemorySegmentUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)21L);
    }

    @Test
    public void checkDirectCompactSingleItem() {
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        sk.update(1L);
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertTrue((sk2.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((long)sk2.getLongSingleItem(), (long)1L);
        sk.update(2L);
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((long)sk2.getN(), (long)2L);
        try {
            sk2.getLongSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectCompactGetLongItemsArray() {
        int i;
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        long[] itemsArr = sk2.getLongItemsArray();
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((long)itemsArr[i], (long)0L);
        }
        sk.update(1L);
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        itemsArr = sk2.getLongItemsArray();
        for (i = 0; i < 19; ++i) {
            Assert.assertEquals((long)itemsArr[i], (long)0L);
        }
        Assert.assertEquals((long)itemsArr[19], (long)1L);
        for (i = 2; i <= 21; ++i) {
            sk.update((long)i);
        }
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        itemsArr = sk2.getLongItemsArray();
        Assert.assertEquals((int)itemsArr.length, (int)33);
        Assert.assertEquals((long)itemsArr[22], (long)21L);
    }

    @Test
    public void checkHeapAndDirectCompactGetRetainedItemsArray() {
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        long[] retArr = sk.getLongRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)0);
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        retArr = sk2.getLongRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)0);
        sk.update(1L);
        retArr = sk.getLongRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((long)retArr[0], (long)1L);
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        retArr = sk2.getLongRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((long)retArr[0], (long)1L);
        for (int i = 2; i <= 21; ++i) {
            sk.update((long)i);
        }
        retArr = sk.getLongRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
    }

    @Test
    public void checkMinAndMax() {
        int k = 20;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        sk.update(1L);
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((long)sk2.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        for (int i = 2; i <= 21; ++i) {
            sk.update((long)i);
        }
        sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk.toByteArray()));
        Assert.assertEquals((long)sk2.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
    }

    @Test
    public void checkQuantile() {
        KllLongsSketch sk1 = KllLongsSketch.newHeapInstance();
        for (int i = 1; i <= 1000; ++i) {
            sk1.update((long)i);
        }
        KllLongsSketch sk2 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(sk1.toByteArray()));
        long med2 = sk2.getQuantile(0.5);
        long med1 = sk1.getQuantile(0.5);
        Assert.assertEquals((long)med1, (long)med2);
        KllDirectCompactLongsSketchTest.println("Med1: " + med1);
        KllDirectCompactLongsSketchTest.println("Med2: " + med2);
    }

    @Test
    public void checkCompactSingleItemMerge() {
        int k = 20;
        KllLongsSketch skH1 = KllLongsSketch.newHeapInstance((int)20);
        skH1.update(21L);
        KllLongsSketch skDC1 = KllLongsSketch.wrap((MemorySegment)MemorySegment.ofArray(skH1.toByteArray()));
        KllLongsSketch skH20 = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            skH20.update((long)i);
        }
        skH20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skH20.getN(), (long)21L);
        MemorySegment wseg = MemorySegment.ofArray(new byte[1000]);
        KllLongsSketch skDU20 = KllLongsSketch.newDirectInstance((int)20, (MemorySegment)wseg, null);
        for (int i = 1; i <= 20; ++i) {
            skDU20.update((long)i);
        }
        skDU20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skDU20.getN(), (long)21L);
    }

    @Test
    public void printlnTest() {
        KllDirectCompactLongsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void println(Object o) {
    }
}

