/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.DummyBinaryChromosome;
import org.apache.commons.math3.genetics.DummyListChromosome;
import org.apache.commons.math3.genetics.OrderedCrossover;
import org.junit.Assert;
import org.junit.Test;

public class OrderedCrossoverTest {
    @Test
    public void testCrossover() {
        Integer[] p1 = new Integer[]{8, 4, 7, 3, 6, 2, 5, 1, 9, 0};
        Integer[] p2 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        DummyListChromosome p1c = new DummyListChromosome(p1);
        DummyListChromosome p2c = new DummyListChromosome(p2);
        OrderedCrossover cp = new OrderedCrossover();
        for (int i = 0; i < 20; ++i) {
            HashSet<Integer> parentSet1 = new HashSet<Integer>(Arrays.asList(p1));
            HashSet<Integer> parentSet2 = new HashSet<Integer>(Arrays.asList(p2));
            ChromosomePair pair = cp.crossover((Chromosome)p1c, (Chromosome)p2c);
            Integer[] c1 = ((DummyListChromosome)pair.getFirst()).getRepresentation().toArray(new Integer[p1.length]);
            Integer[] c2 = ((DummyListChromosome)pair.getSecond()).getRepresentation().toArray(new Integer[p2.length]);
            Assert.assertNotSame((Object)((Object)p1c), (Object)pair.getFirst());
            Assert.assertNotSame((Object)((Object)p2c), (Object)pair.getSecond());
            for (int j = 0; j < c1.length; ++j) {
                Assert.assertTrue((boolean)parentSet1.contains(c1[j]));
                parentSet1.remove(c1[j]);
                Assert.assertTrue((boolean)parentSet2.contains(c2[j]));
                parentSet2.remove(c2[j]);
            }
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCrossoverDimensionMismatchException() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        OrderedCrossover cp = new OrderedCrossover();
        cp.crossover((Chromosome)p1c, (Chromosome)p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeFirst() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        Chromosome p2c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        OrderedCrossover cp = new OrderedCrossover();
        cp.crossover((Chromosome)p1c, p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeSecond() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p1);
        Chromosome p1c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        OrderedCrossover cp = new OrderedCrossover();
        cp.crossover(p1c, (Chromosome)p2c);
    }
}

