/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta;

import jakarta.activation.DataSource;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.jakarta.DataSourceResolver;
import org.apache.commons.mail2.jakarta.HtmlEmailTest;
import org.apache.commons.mail2.jakarta.ImageHtmlEmail;
import org.apache.commons.mail2.jakarta.mocks.MockImageHtmlEmailConcrete;
import org.apache.commons.mail2.jakarta.resolver.DataSourceClassPathResolver;
import org.apache.commons.mail2.jakarta.resolver.DataSourceCompositeResolver;
import org.apache.commons.mail2.jakarta.resolver.DataSourceUrlResolver;
import org.apache.commons.mail2.jakarta.util.MimeMessageParser;
import org.apache.commons.mail2.jakarta.util.MimeMessageUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.subethamail.wiser.WiserMessage;

public class ImageHtmlEmailTest
extends HtmlEmailTest {
    private static final boolean TEST_IS_LENIENT = true;
    private static final URL TEST_IMAGE_URL = ImageHtmlEmailTest.class.getResource("/images/asf_logo_wide.gif");
    private static final File TEST_IMAGE_DIR = new File(TEST_IMAGE_URL.getPath()).getParentFile();
    private static final URL TEST_HTML_URL = ImageHtmlEmailTest.class.getResource("/attachments/download_email.cgi.html");
    private static final URL TEST2_HTML_URL = ImageHtmlEmailTest.class.getResource("/attachments/classpathtest.html");
    private MockImageHtmlEmailConcrete email;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadUrlContent(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            StringBuilder html = new StringBuilder();
            try {
                List lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    html.append(line).append("\n");
                }
            }
            finally {
                stream.close();
            }
            String string = html.toString();
            return string;
        }
    }

    @BeforeEach
    public void setupImageHtmlEmailTest() {
        this.email = new MockImageHtmlEmailConcrete();
    }

    @Test
    public void testEmail127() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with URL";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default with URL");
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHtmlMsg("<html><body><img title=\"$\" src=\"http://www.apache.org/images/feather.gif\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send default with URL", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    @Test
    public void testRegex() {
        Pattern pattern = Pattern.compile("(<[Ii][Mm][Gg]\\s*[^>]*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])");
        Matcher matcher = pattern.matcher("<html><body><img src=\"h\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img id=\"laskdasdkj\" src=\"h\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><IMG id=\"laskdasdkj\" SRC=\"h\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img id=\"laskdasdkj\" src=\"http://dstadler1.org/\"/><img id=\"laskdasdkj\" src=\"http://dstadler2.org/\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img\n \rid=\"laskdasdkj\"\n \rsrc=\"http://dstadler1.org/\"/><img id=\"laskdasdkj\" src=\"http://dstadler2.org/\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img\n \t\rid=\"laskdasdkj\"\n \rsrc \n =\r  \"http://dstadler1.org/\"/><img  \r  id=\" laskdasdkj\"    src    =   \"http://dstadler2.org/\"/></body></html>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<img alt=\"Chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0\" src=\"/chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0.2&amp;l=A,C,S,T&amp;v=3.0,3.0,2.0,2.0\"");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"/chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0.2&amp;l=A,C,S,T&amp;v=3.0,3.0,2.0,2.0", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"/><img src=\"file2\"/>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file2", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"/><img src=\"file2\"/><img src=\"file3\"/><img src=\"file4\"/><img src=\"file5\"/>");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file2", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file3", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file4", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file5", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"><img src=\"file2\">");
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)"file2", (Object)matcher.group(2));
    }

    @Test
    public void testSendClassPathFileWithNullName() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setDataSourceResolver((DataSourceResolver)new MockDataSourceClassPathResolver("/", true));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default");
        String html = this.loadUrlContent(TEST2_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assertions.assertEquals((int)1, (int)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendClassPathFileWithNullName.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assertions.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getAttachmentList().size());
    }

    @Test
    public void testSendEmptyHTML() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        ImageHtmlEmail email = new ImageHtmlEmail();
        EmailException e = (EmailException)Assertions.assertThrows(EmailException.class, () -> email.setHtmlMsg(null));
        Assertions.assertTrue((boolean)e.getMessage().contains("Invalid message."), (String)e.getMessage());
    }

    @Test
    public void testSendEmptyHTML2() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        ImageHtmlEmail email = new ImageHtmlEmail();
        EmailException e = (EmailException)Assertions.assertThrows(EmailException.class, () -> email.setHtmlMsg(""));
        Assertions.assertTrue((boolean)e.getMessage().contains("Invalid message."), (String)e.getMessage());
    }

    @Test
    public void testSendHtml() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default");
        String html = this.loadUrlContent(TEST_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assertions.assertEquals((int)1, (int)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assertions.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assertions.assertEquals((int)3, (int)mimeMessageParser.getAttachmentList().size());
    }

    @Test
    public void testSendHTMLAbsoluteLocalFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with absolute local path";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default with absolute local path");
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        File file = File.createTempFile("emailtest", ".tst");
        FileUtils.writeStringToFile((File)file, (String)"just some silly data that we won't be able to display anyway", (Charset)StandardCharsets.UTF_8);
        this.email.setHtmlMsg("<html><body><img src=\"" + file.getAbsolutePath() + "\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send default with absolute local path", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    @Test
    public void testSendHTMLAutoResolveFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        DataSourceResolver[] dataSourceResolvers = new DataSourceResolver[]{new DataSourceUrlResolver(new URL("http://foo"), true), new DataSourceClassPathResolver("/", true)};
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceCompositeResolver(dataSourceResolvers));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default");
        String html = this.loadUrlContent(TEST2_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assertions.assertEquals((int)1, (int)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLAutoFile.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assertions.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getAttachmentList().size());
    }

    @Test
    public void testSendHTMLAutoResolveMultipleFiles() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", true);
        this.email.setDataSourceResolver((DataSourceResolver)dataSourceResolver);
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default");
        String html = "<p>First image  <img src=\"images/contentTypeTest.gif\"/></p><p>Second image <img src=\"images/contentTypeTest.jpg\"/></p><p>Third image  <img src=\"images/contentTypeTest.png\"/></p>";
        this.email.setHtmlMsg("<p>First image  <img src=\"images/contentTypeTest.gif\"/></p><p>Second image <img src=\"images/contentTypeTest.jpg\"/></p><p>Third image  <img src=\"images/contentTypeTest.png\"/></p>");
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assertions.assertEquals((int)1, (int)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLAutoMultipleFiles.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assertions.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"), (String)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)3, (int)mimeMessageParser.getAttachmentList().size());
    }

    @Test
    public void testSendHTMLClassPathFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceClassPathResolver("/", true));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default");
        String html = this.loadUrlContent(TEST2_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assertions.assertEquals((int)1, (int)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLClassPathFile.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assertions.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getAttachmentList().size());
    }

    @Test
    public void testSendHtmlUrl() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with URL";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject("Test HTML Send default with URL");
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHtmlMsg("<html><body><img src=\"http://www.apache.org/images/feather.gif\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send default with URL", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    private static final class MockDataSourceClassPathResolver
    extends DataSourceClassPathResolver {
        public MockDataSourceClassPathResolver(String classPathBase, boolean lenient) {
            super(classPathBase, lenient);
        }

        public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
            ByteArrayDataSource ds = (ByteArrayDataSource)super.resolve(resourceLocation, isLenient);
            ds.setName(null);
            return ds;
        }
    }
}

