/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Capture changes from an Oracle database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumOracleEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Debezium Oracle Connector component.
     */
    public interface DebeziumOracleEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumOracleEndpointBuilder advanced() {
            return (AdvancedDebeziumOracleEndpointBuilder) this;
        }

        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder additionalProperties(String key, Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder internalKeyConverter(String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder internalValueConverter(String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetCommitPolicy(String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetCommitTimeoutMs(String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetFlushIntervalMs(String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStorage(String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStorageFileName(String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStoragePartitions(String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStorageReplicationFactor(String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder offsetStorageTopic(String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Sets the specific archive log destination as the source for reading
         * archive logs.When not set, the connector will automatically select
         * the first LOCAL and VALID destination.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param archiveDestinationName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder archiveDestinationName(String archiveDestinationName) {
            doSetProperty("archiveDestinationName", archiveDestinationName);
            return this;
        }
        /**
         * The number of hours in the past from SYSDATE to mine archive logs.
         * Using 0 mines all available archive logs.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param archiveLogHours the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder archiveLogHours(long archiveLogHours) {
            doSetProperty("archiveLogHours", archiveLogHours);
            return this;
        }
        /**
         * The number of hours in the past from SYSDATE to mine archive logs.
         * Using 0 mines all available archive logs.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param archiveLogHours the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder archiveLogHours(String archiveLogHours) {
            doSetProperty("archiveLogHours", archiveLogHours);
            return this;
        }
        /**
         * Specify how binary (blob, binary, etc.) columns should be represented
         * in change events, including: 'bytes' represents binary data as byte
         * array (default); 'base64' represents binary data as base64-encoded
         * string; 'base64-url-safe' represents binary data as
         * base64-url-safe-encoded string; 'hex' represents binary data as
         * hex-encoded (base16) string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: bytes
         * Group: oracle
         * 
         * @param binaryHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder binaryHandlingMode(String binaryHandlingMode) {
            doSetProperty("binaryHandlingMode", binaryHandlingMode);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder columnExcludeList(String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder columnIncludeList(String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder columnPropagateSourceType(String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder customMetricTags(String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
        /**
         * The adapter to use when capturing changes from the database. Options
         * include: 'logminer': (the default) to capture changes using native
         * Oracle LogMiner; 'xstream' to capture changes using Oracle XStreams.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: LogMiner
         * Group: oracle
         * 
         * @param databaseConnectionAdapter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseConnectionAdapter(String databaseConnectionAdapter) {
            doSetProperty("databaseConnectionAdapter", databaseConnectionAdapter);
            return this;
        }
        /**
         * The name of the database from which the connector should capture
         * changes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databaseDbname the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseDbname(String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseHostname(String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * Name of the XStream Out server to connect to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databaseOutServerName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseOutServerName(String databaseOutServerName) {
            doSetProperty("databaseOutServerName", databaseOutServerName);
            return this;
        }
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: oracle
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databasePassword(String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Name of the pluggable database when working with a multi-tenant
         * set-up. The CDB name must be given via database.dbname in this case.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databasePdbName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databasePdbName(String databasePdbName) {
            doSetProperty("databasePdbName", databasePdbName);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1528
         * Group: oracle
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1528
         * Group: oracle
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databasePort(String databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10m
         * Group: oracle
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10m
         * Group: oracle
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseQueryTimeoutMs(String databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
        /**
         * Complete JDBC URL as an alternative to specifying hostname, port and
         * database provided as a way to support alternative connection
         * scenarios.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databaseUrl the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseUrl(String databaseUrl) {
            doSetProperty("databaseUrl", databaseUrl);
            return this;
        }
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder databaseUser(String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder datatypePropagateSourceType(String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: precise
         * Group: oracle
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder decimalHandlingMode(String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: oracle
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: oracle
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder errorsMaxRetries(String errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: fail
         * Group: oracle
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder eventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * The query executed with every heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param heartbeatActionQuery the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder heartbeatActionQuery(String heartbeatActionQuery) {
            doSetProperty("heartbeatActionQuery", heartbeatActionQuery);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder heartbeatIntervalMs(String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium-heartbeat
         * Group: oracle
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder heartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: oracle
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder includeSchemaChanges(boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: oracle
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder includeSchemaChanges(String includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder includeSchemaComments(boolean includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder includeSchemaComments(String includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: INSERT_INSERT
         * Group: oracle
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder incrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
        /**
         * Specify how INTERVAL columns should be represented in change events,
         * including: 'string' represents values as an exact ISO formatted
         * string; 'numeric' (default) represents values using the inexact
         * conversion into microseconds.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: numeric
         * Group: oracle
         * 
         * @param intervalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder intervalHandlingMode(String intervalHandlingMode) {
            doSetProperty("intervalHandlingMode", intervalHandlingMode);
            return this;
        }
        /**
         * When set to 'false', the default, LOB fields will not be captured nor
         * emitted. When set to 'true', the connector will capture LOB fields
         * and emit changes for those fields like any other column type.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param lobEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder lobEnabled(boolean lobEnabled) {
            doSetProperty("lobEnabled", lobEnabled);
            return this;
        }
        /**
         * When set to 'false', the default, LOB fields will not be captured nor
         * emitted. When set to 'true', the connector will capture LOB fields
         * and emit changes for those fields like any other column type.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param lobEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder lobEnabled(String lobEnabled) {
            doSetProperty("lobEnabled", lobEnabled);
            return this;
        }
        /**
         * When set to 'false', the default, the connector will mine both
         * archive log and redo logs to emit change events. When set to 'true',
         * the connector will only mine archive logs. There are circumstances
         * where its advantageous to only mine archive logs and accept latency
         * in event emission due to frequent revolving redo logs.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningArchiveLogOnlyMode(boolean logMiningArchiveLogOnlyMode) {
            doSetProperty("logMiningArchiveLogOnlyMode", logMiningArchiveLogOnlyMode);
            return this;
        }
        /**
         * When set to 'false', the default, the connector will mine both
         * archive log and redo logs to emit change events. When set to 'true',
         * the connector will only mine archive logs. There are circumstances
         * where its advantageous to only mine archive logs and accept latency
         * in event emission due to frequent revolving redo logs.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningArchiveLogOnlyMode(String logMiningArchiveLogOnlyMode) {
            doSetProperty("logMiningArchiveLogOnlyMode", logMiningArchiveLogOnlyMode);
            return this;
        }
        /**
         * The interval in milliseconds to wait between polls checking to see if
         * the SCN is in the archive logs.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyScnPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningArchiveLogOnlyScnPollIntervalMs(long logMiningArchiveLogOnlyScnPollIntervalMs) {
            doSetProperty("logMiningArchiveLogOnlyScnPollIntervalMs", logMiningArchiveLogOnlyScnPollIntervalMs);
            return this;
        }
        /**
         * The interval in milliseconds to wait between polls checking to see if
         * the SCN is in the archive logs.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyScnPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningArchiveLogOnlyScnPollIntervalMs(String logMiningArchiveLogOnlyScnPollIntervalMs) {
            doSetProperty("logMiningArchiveLogOnlyScnPollIntervalMs", logMiningArchiveLogOnlyScnPollIntervalMs);
            return this;
        }
        /**
         * The starting SCN interval size that the connector will use for
         * reading data from redo/archive logs.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 20000
         * Group: oracle
         * 
         * @param logMiningBatchSizeDefault the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeDefault(long logMiningBatchSizeDefault) {
            doSetProperty("logMiningBatchSizeDefault", logMiningBatchSizeDefault);
            return this;
        }
        /**
         * The starting SCN interval size that the connector will use for
         * reading data from redo/archive logs.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 20000
         * Group: oracle
         * 
         * @param logMiningBatchSizeDefault the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeDefault(String logMiningBatchSizeDefault) {
            doSetProperty("logMiningBatchSizeDefault", logMiningBatchSizeDefault);
            return this;
        }
        /**
         * The maximum SCN interval size that this connector will use when
         * reading from redo/archive logs.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 100000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMax the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeMax(long logMiningBatchSizeMax) {
            doSetProperty("logMiningBatchSizeMax", logMiningBatchSizeMax);
            return this;
        }
        /**
         * The maximum SCN interval size that this connector will use when
         * reading from redo/archive logs.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 100000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMax the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeMax(String logMiningBatchSizeMax) {
            doSetProperty("logMiningBatchSizeMax", logMiningBatchSizeMax);
            return this;
        }
        /**
         * The minimum SCN interval size that this connector will try to read
         * from redo/archive logs. Active batch size will be also
         * increased/decreased by this amount for tuning connector throughput
         * when needed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeMin(long logMiningBatchSizeMin) {
            doSetProperty("logMiningBatchSizeMin", logMiningBatchSizeMin);
            return this;
        }
        /**
         * The minimum SCN interval size that this connector will try to read
         * from redo/archive logs. Active batch size will be also
         * increased/decreased by this amount for tuning connector throughput
         * when needed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBatchSizeMin(String logMiningBatchSizeMin) {
            doSetProperty("logMiningBatchSizeMin", logMiningBatchSizeMin);
            return this;
        }
        /**
         * When set to true the underlying buffer cache is not retained when the
         * connector is stopped. When set to false (the default), the buffer
         * cache is retained across restarts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningBufferDropOnStop the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferDropOnStop(boolean logMiningBufferDropOnStop) {
            doSetProperty("logMiningBufferDropOnStop", logMiningBufferDropOnStop);
            return this;
        }
        /**
         * When set to true the underlying buffer cache is not retained when the
         * connector is stopped. When set to false (the default), the buffer
         * cache is retained across restarts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningBufferDropOnStop the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferDropOnStop(String logMiningBufferDropOnStop) {
            doSetProperty("logMiningBufferDropOnStop", logMiningBufferDropOnStop);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'events' cache.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheEvents the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferInfinispanCacheEvents(String logMiningBufferInfinispanCacheEvents) {
            doSetProperty("logMiningBufferInfinispanCacheEvents", logMiningBufferInfinispanCacheEvents);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'global'
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheGlobal the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferInfinispanCacheGlobal(String logMiningBufferInfinispanCacheGlobal) {
            doSetProperty("logMiningBufferInfinispanCacheGlobal", logMiningBufferInfinispanCacheGlobal);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan
         * 'processed-transactions' cache.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheProcessedTransactions the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferInfinispanCacheProcessedTransactions(String logMiningBufferInfinispanCacheProcessedTransactions) {
            doSetProperty("logMiningBufferInfinispanCacheProcessedTransactions", logMiningBufferInfinispanCacheProcessedTransactions);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'schema-changes'
         * cache.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferInfinispanCacheSchemaChanges(String logMiningBufferInfinispanCacheSchemaChanges) {
            doSetProperty("logMiningBufferInfinispanCacheSchemaChanges", logMiningBufferInfinispanCacheSchemaChanges);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'transactions'
         * cache.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheTransactions the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferInfinispanCacheTransactions(String logMiningBufferInfinispanCacheTransactions) {
            doSetProperty("logMiningBufferInfinispanCacheTransactions", logMiningBufferInfinispanCacheTransactions);
            return this;
        }
        /**
         * The number of events a transaction can include before the transaction
         * is discarded. This is useful for managing buffer memory and/or space
         * when dealing with very large transactions. Defaults to 0, meaning
         * that no threshold is applied and transactions can have unlimited
         * events.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param logMiningBufferTransactionEventsThreshold the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferTransactionEventsThreshold(long logMiningBufferTransactionEventsThreshold) {
            doSetProperty("logMiningBufferTransactionEventsThreshold", logMiningBufferTransactionEventsThreshold);
            return this;
        }
        /**
         * The number of events a transaction can include before the transaction
         * is discarded. This is useful for managing buffer memory and/or space
         * when dealing with very large transactions. Defaults to 0, meaning
         * that no threshold is applied and transactions can have unlimited
         * events.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param logMiningBufferTransactionEventsThreshold the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferTransactionEventsThreshold(String logMiningBufferTransactionEventsThreshold) {
            doSetProperty("logMiningBufferTransactionEventsThreshold", logMiningBufferTransactionEventsThreshold);
            return this;
        }
        /**
         * The buffer type controls how the connector manages buffering
         * transaction data. memory - Uses the JVM process' heap to buffer all
         * transaction data. infinispan_embedded - This option uses an embedded
         * Infinispan cache to buffer transaction data and persist it to disk.
         * infinispan_remote - This option uses a remote Infinispan cluster to
         * buffer transaction data and persist it to disk.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: memory
         * Group: oracle
         * 
         * @param logMiningBufferType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningBufferType(String logMiningBufferType) {
            doSetProperty("logMiningBufferType", logMiningBufferType);
            return this;
        }
        /**
         * The name of the flush table used by the connector, defaults to
         * LOG_MINING_FLUSH.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: LOG_MINING_FLUSH
         * Group: oracle
         * 
         * @param logMiningFlushTableName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningFlushTableName(String logMiningFlushTableName) {
            doSetProperty("logMiningFlushTableName", logMiningFlushTableName);
            return this;
        }
        /**
         * When enabled, the transaction log REDO SQL will be included in the
         * source information block.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningIncludeRedoSql the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningIncludeRedoSql(boolean logMiningIncludeRedoSql) {
            doSetProperty("logMiningIncludeRedoSql", logMiningIncludeRedoSql);
            return this;
        }
        /**
         * When enabled, the transaction log REDO SQL will be included in the
         * source information block.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningIncludeRedoSql the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningIncludeRedoSql(String logMiningIncludeRedoSql) {
            doSetProperty("logMiningIncludeRedoSql", logMiningIncludeRedoSql);
            return this;
        }
        /**
         * Specifies how the filter configuration is applied to the LogMiner
         * database query. none - The query does not apply any schema or table
         * filters, all filtering is at runtime by the connector. in - The query
         * uses SQL in-clause expressions to specify the schema or table
         * filters. regex - The query uses Oracle REGEXP_LIKE expressions to
         * specify the schema or table filters.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: oracle
         * 
         * @param logMiningQueryFilterMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningQueryFilterMode(String logMiningQueryFilterMode) {
            doSetProperty("logMiningQueryFilterMode", logMiningQueryFilterMode);
            return this;
        }
        /**
         * Debezium opens a database connection and keeps that connection open
         * throughout the entire streaming phase. In some situations, this can
         * lead to excessive SGA memory usage. By setting this option to 'true'
         * (the default is 'false'), the connector will close and re-open a
         * database connection after every detected log switch or if the
         * log.mining.session.max.ms has been reached.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningRestartConnection the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningRestartConnection(boolean logMiningRestartConnection) {
            doSetProperty("logMiningRestartConnection", logMiningRestartConnection);
            return this;
        }
        /**
         * Debezium opens a database connection and keeps that connection open
         * throughout the entire streaming phase. In some situations, this can
         * lead to excessive SGA memory usage. By setting this option to 'true'
         * (the default is 'false'), the connector will close and re-open a
         * database connection after every detected log switch or if the
         * log.mining.session.max.ms has been reached.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningRestartConnection the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningRestartConnection(String logMiningRestartConnection) {
            doSetProperty("logMiningRestartConnection", logMiningRestartConnection);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than this value, and the time difference
         * of current SCN and previous end SCN is smaller than
         * log.mining.scn.gap.detection.time.interval.max.ms, consider it a SCN
         * gap.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000000
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionGapSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningScnGapDetectionGapSizeMin(long logMiningScnGapDetectionGapSizeMin) {
            doSetProperty("logMiningScnGapDetectionGapSizeMin", logMiningScnGapDetectionGapSizeMin);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than this value, and the time difference
         * of current SCN and previous end SCN is smaller than
         * log.mining.scn.gap.detection.time.interval.max.ms, consider it a SCN
         * gap.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000000
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionGapSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningScnGapDetectionGapSizeMin(String logMiningScnGapDetectionGapSizeMin) {
            doSetProperty("logMiningScnGapDetectionGapSizeMin", logMiningScnGapDetectionGapSizeMin);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than
         * log.mining.scn.gap.detection.gap.size.min, and the time difference of
         * current SCN and previous end SCN is smaller than this value, consider
         * it a SCN gap.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 20s
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionTimeIntervalMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningScnGapDetectionTimeIntervalMaxMs(long logMiningScnGapDetectionTimeIntervalMaxMs) {
            doSetProperty("logMiningScnGapDetectionTimeIntervalMaxMs", logMiningScnGapDetectionTimeIntervalMaxMs);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than
         * log.mining.scn.gap.detection.gap.size.min, and the time difference of
         * current SCN and previous end SCN is smaller than this value, consider
         * it a SCN gap.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 20s
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionTimeIntervalMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningScnGapDetectionTimeIntervalMaxMs(String logMiningScnGapDetectionTimeIntervalMaxMs) {
            doSetProperty("logMiningScnGapDetectionTimeIntervalMaxMs", logMiningScnGapDetectionTimeIntervalMaxMs);
            return this;
        }
        /**
         * The maximum number of milliseconds that a LogMiner session lives for
         * before being restarted. Defaults to 0 (indefinite until a log switch
         * occurs).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSessionMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSessionMaxMs(long logMiningSessionMaxMs) {
            doSetProperty("logMiningSessionMaxMs", logMiningSessionMaxMs);
            return this;
        }
        /**
         * The maximum number of milliseconds that a LogMiner session lives for
         * before being restarted. Defaults to 0 (indefinite until a log switch
         * occurs).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSessionMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSessionMaxMs(String logMiningSessionMaxMs) {
            doSetProperty("logMiningSessionMaxMs", logMiningSessionMaxMs);
            return this;
        }
        /**
         * The amount of time that the connector will sleep after reading data
         * from redo/archive logs and before starting reading data again. Value
         * is in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1s
         * Group: oracle
         * 
         * @param logMiningSleepTimeDefaultMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeDefaultMs(long logMiningSleepTimeDefaultMs) {
            doSetProperty("logMiningSleepTimeDefaultMs", logMiningSleepTimeDefaultMs);
            return this;
        }
        /**
         * The amount of time that the connector will sleep after reading data
         * from redo/archive logs and before starting reading data again. Value
         * is in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1s
         * Group: oracle
         * 
         * @param logMiningSleepTimeDefaultMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeDefaultMs(String logMiningSleepTimeDefaultMs) {
            doSetProperty("logMiningSleepTimeDefaultMs", logMiningSleepTimeDefaultMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will use to tune the
         * optimal sleep time when reading data from LogMiner. Value is in
         * milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 200ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeIncrementMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeIncrementMs(long logMiningSleepTimeIncrementMs) {
            doSetProperty("logMiningSleepTimeIncrementMs", logMiningSleepTimeIncrementMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will use to tune the
         * optimal sleep time when reading data from LogMiner. Value is in
         * milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 200ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeIncrementMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeIncrementMs(String logMiningSleepTimeIncrementMs) {
            doSetProperty("logMiningSleepTimeIncrementMs", logMiningSleepTimeIncrementMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 3s
         * Group: oracle
         * 
         * @param logMiningSleepTimeMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeMaxMs(long logMiningSleepTimeMaxMs) {
            doSetProperty("logMiningSleepTimeMaxMs", logMiningSleepTimeMaxMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 3s
         * Group: oracle
         * 
         * @param logMiningSleepTimeMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeMaxMs(String logMiningSleepTimeMaxMs) {
            doSetProperty("logMiningSleepTimeMaxMs", logMiningSleepTimeMaxMs);
            return this;
        }
        /**
         * The minimum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeMinMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeMinMs(long logMiningSleepTimeMinMs) {
            doSetProperty("logMiningSleepTimeMinMs", logMiningSleepTimeMinMs);
            return this;
        }
        /**
         * The minimum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeMinMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningSleepTimeMinMs(String logMiningSleepTimeMinMs) {
            doSetProperty("logMiningSleepTimeMinMs", logMiningSleepTimeMinMs);
            return this;
        }
        /**
         * There are strategies: Online catalog with faster mining but no
         * captured DDL. Another - with data dictionary loaded into REDO LOG
         * files.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: redo_log_catalog
         * Group: oracle
         * 
         * @param logMiningStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningStrategy(String logMiningStrategy) {
            doSetProperty("logMiningStrategy", logMiningStrategy);
            return this;
        }
        /**
         * Duration in milliseconds to keep long running transactions in
         * transaction buffer between log mining sessions. By default, all
         * transactions are retained.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningTransactionRetentionMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningTransactionRetentionMs(long logMiningTransactionRetentionMs) {
            doSetProperty("logMiningTransactionRetentionMs", logMiningTransactionRetentionMs);
            return this;
        }
        /**
         * Duration in milliseconds to keep long running transactions in
         * transaction buffer between log mining sessions. By default, all
         * transactions are retained.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningTransactionRetentionMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningTransactionRetentionMs(String logMiningTransactionRetentionMs) {
            doSetProperty("logMiningTransactionRetentionMs", logMiningTransactionRetentionMs);
            return this;
        }
        /**
         * Comma separated list of usernames to exclude from LogMiner query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningUsernameExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningUsernameExcludeList(String logMiningUsernameExcludeList) {
            doSetProperty("logMiningUsernameExcludeList", logMiningUsernameExcludeList);
            return this;
        }
        /**
         * Comma separated list of usernames to include from LogMiner query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param logMiningUsernameIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder logMiningUsernameIncludeList(String logMiningUsernameIncludeList) {
            doSetProperty("logMiningUsernameIncludeList", logMiningUsernameIncludeList);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: oracle
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: oracle
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8192
         * Group: oracle
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8192
         * Group: oracle
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder maxQueueSizeInBytes(String maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder messageKeyColumns(String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder notificationEnabledChannels(String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder notificationSinkTopicName(String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
        /**
         * The hostname of the OpenLogReplicator network service.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorHost the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder openlogreplicatorHost(String openlogreplicatorHost) {
            doSetProperty("openlogreplicatorHost", openlogreplicatorHost);
            return this;
        }
        /**
         * The port of the OpenLogReplicator network service.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorPort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder openlogreplicatorPort(int openlogreplicatorPort) {
            doSetProperty("openlogreplicatorPort", openlogreplicatorPort);
            return this;
        }
        /**
         * The port of the OpenLogReplicator network service.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorPort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder openlogreplicatorPort(String openlogreplicatorPort) {
            doSetProperty("openlogreplicatorPort", openlogreplicatorPort);
            return this;
        }
        /**
         * The configured logical source name in the OpenLogReplicator
         * configuration that is to stream changes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorSource the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder openlogreplicatorSource(String openlogreplicatorSource) {
            doSetProperty("openlogreplicatorSource", openlogreplicatorSource);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500ms
         * Group: oracle
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500ms
         * Group: oracle
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder pollIntervalMs(String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder postProcessors(String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder provideTransactionMetadata(String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size, defaults
         * to '2000'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10000
         * Group: oracle
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size, defaults
         * to '2000'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10000
         * Group: oracle
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder queryFetchSize(String queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * A comma-separated list of RAC node hostnames or ip addresses.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param racNodes the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder racNodes(String racNodes) {
            doSetProperty("racNodes", racNodes);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder retriableRestartConnectorWaitMs(String retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * The name of the SchemaHistory class that should be used to store and
         * recover database schema changes. The configuration properties for the
         * history are prefixed with the 'schema.history.internal.' string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.storage.kafka.history.KafkaSchemaHistory
         * Group: oracle
         * 
         * @param schemaHistoryInternal the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternal(String schemaHistoryInternal) {
            doSetProperty("schemaHistoryInternal", schemaHistoryInternal);
            return this;
        }
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalSkipUnparseableDdl(String schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (true) only DDL that manipulates a table from captured
         * schema/database will be stored. If set to false, then Debezium will
         * store all incoming DDL statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (true) only DDL that manipulates a table from captured
         * schema/database will be stored. If set to false, then Debezium will
         * store all incoming DDL statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(String schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(String schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: oracle
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder schemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder signalDataCollection(String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: source
         * Group: oracle
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder signalEnabledChannels(String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5s
         * Group: oracle
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5s
         * Group: oracle
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder signalPollIntervalMs(String signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: t
         * Group: oracle
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder skippedOperations(String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * The number of attempts to retry database errors during snapshots
         * before failing.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param snapshotDatabaseErrorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotDatabaseErrorsMaxRetries(int snapshotDatabaseErrorsMaxRetries) {
            doSetProperty("snapshotDatabaseErrorsMaxRetries", snapshotDatabaseErrorsMaxRetries);
            return this;
        }
        /**
         * The number of attempts to retry database errors during snapshots
         * before failing.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param snapshotDatabaseErrorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotDatabaseErrorsMaxRetries(String snapshotDatabaseErrorsMaxRetries) {
            doSetProperty("snapshotDatabaseErrorsMaxRetries", snapshotDatabaseErrorsMaxRetries);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotDelayMs(String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: oracle
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: oracle
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotFetchSize(String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * Controls how the connector holds locks on tables while performing the
         * schema snapshot. The default is 'shared', which means the connector
         * will hold a table lock that prevents exclusive table access for just
         * the initial portion of the snapshot while the database schemas and
         * other metadata are being read. The remaining work in a snapshot
         * involves selecting all rows from each table, and this is done using a
         * flashback query that requires no locks. However, in some cases it may
         * be desirable to avoid locks entirely which can be done by specifying
         * 'none'. This mode is only safe to use if no schema changes are
         * happening while the snapshot is taken.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: shared
         * Group: oracle
         * 
         * @param snapshotLockingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotLockingMode(String snapshotLockingMode) {
            doSetProperty("snapshotLockingMode", snapshotLockingMode);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotLockTimeoutMs(String snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: oracle
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotMaxThreads(int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: oracle
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotMaxThreads(String snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'always': The connector
         * runs a snapshot every time that it starts. After the snapshot
         * completes, the connector begins to stream changes from the redo
         * logs.; 'initial' (default): If the connector does not detect any
         * offsets for the logical server name, it runs a snapshot that captures
         * the current full state of the configured tables. After the snapshot
         * completes, the connector begins to stream changes from the redo logs.
         * 'initial_only': The connector performs a snapshot as it does for the
         * 'initial' option, but after the connector completes the snapshot, it
         * stops, and does not stream changes from the redo logs.;
         * 'schema_only': If the connector does not detect any offsets for the
         * logical server name, it runs a snapshot that captures only the schema
         * (table structures), but not any table data. After the snapshot
         * completes, the connector begins to stream changes from the redo
         * logs.; 'schema_only_recovery': The connector performs a snapshot that
         * captures only the database schema history. The connector then
         * transitions to streaming from the redo logs. Use this setting to
         * restore a corrupted or lost database schema history topic. Do not use
         * if the database schema was modified after the connector stopped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: initial
         * Group: oracle
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotData(String snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(String snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(String snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(String snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeConfigurationBasedStartStream(String snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotModeCustomName(String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: disabled
         * Group: oracle
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder snapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.connector.oracle.OracleSourceInfoStructMaker
         * Group: oracle
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder sourceinfoStructMaker(String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder streamingDelayMs(long streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder streamingDelayMs(String streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder tableExcludeList(String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: oracle
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder tableIncludeList(String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: adaptive
         * Group: oracle
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder timePrecisionMode(String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder tombstonesOnDelete(String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: oracle
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder topicNamingStrategy(String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: oracle
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder topicPrefix(String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
        /**
         * Class to make transaction context &amp; transaction struct/schemas.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory
         * Group: oracle
         * 
         * @param transactionMetadataFactory the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder transactionMetadataFactory(String transactionMetadataFactory) {
            doSetProperty("transactionMetadataFactory", transactionMetadataFactory);
            return this;
        }
        /**
         * Specify the constant that will be provided by Debezium to indicate
         * that the original value is unavailable and not provided by the
         * database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium_unavailable_value
         * Group: oracle
         * 
         * @param unavailableValuePlaceholder the value to set
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder unavailableValuePlaceholder(String unavailableValuePlaceholder) {
            doSetProperty("unavailableValuePlaceholder", unavailableValuePlaceholder);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium Oracle Connector component.
     */
    public interface AdvancedDebeziumOracleEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumOracleEndpointBuilder basic() {
            return (DebeziumOracleEndpointBuilder) this;
        }

        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumOracleEndpointBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface DebeziumOracleBuilders {
        /**
         * Debezium Oracle Connector (camel-debezium-oracle)
         * Capture changes from an Oracle database.
         * 
         * Category: database
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-oracle
         * 
         * @return the dsl builder for the headers' name.
         */
        default DebeziumOracleHeaderNameBuilder debeziumOracle() {
            return DebeziumOracleHeaderNameBuilder.INSTANCE;
        }
        /**
         * Debezium Oracle Connector (camel-debezium-oracle)
         * Capture changes from an Oracle database.
         * 
         * Category: database
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-oracle
         * 
         * Syntax: <code>debezium-oracle:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder debeziumOracle(String path) {
            return DebeziumOracleEndpointBuilderFactory.endpointBuilder("debezium-oracle", path);
        }
        /**
         * Debezium Oracle Connector (camel-debezium-oracle)
         * Capture changes from an Oracle database.
         * 
         * Category: database
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-oracle
         * 
         * Syntax: <code>debezium-oracle:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default DebeziumOracleEndpointBuilder debeziumOracle(String componentName, String path) {
            return DebeziumOracleEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Debezium Oracle Connector component.
     */
    public static class DebeziumOracleHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DebeziumOracleHeaderNameBuilder INSTANCE = new DebeziumOracleHeaderNameBuilder();

        /**
         * The metadata about the source event, for example table name, database
         * name, log position, etc, please refer to the Debezium documentation
         * for more info.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumSourceMetadata}.
         */
        public String debeziumSourceMetadata() {
            return "CamelDebeziumSourceMetadata";
        }
        /**
         * The identifier of the connector, normally is this format
         * {server-name}.{database-name}.{table-name}.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumIdentifier}.
         */
        public String debeziumIdentifier() {
            return "CamelDebeziumIdentifier";
        }
        /**
         * The key of the event, normally is the table Primary Key.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumKey}.
         */
        public String debeziumKey() {
            return "CamelDebeziumKey";
        }
        /**
         * If presents, the type of event operation. Values for the connector
         * are c for create (or insert), u for update, d for delete or r for
         * read (in the case of a initial sync) or in case of a snapshot event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumOperation}.
         */
        public String debeziumOperation() {
            return "CamelDebeziumOperation";
        }
        /**
         * If presents, the time (using the system clock in the JVM) at which
         * the connector processed the event.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumTimestamp}.
         */
        public String debeziumTimestamp() {
            return "CamelDebeziumTimestamp";
        }
        /**
         * If presents, contains the state of the row before the event occurred.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumBefore}.
         */
        public String debeziumBefore() {
            return "CamelDebeziumBefore";
        }
        /**
         * If presents, the ddl sql text of the event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumDdlSQL}.
         */
        public String debeziumDdlSQL() {
            return "CamelDebeziumDdlSQL";
        }
    }
    static DebeziumOracleEndpointBuilder endpointBuilder(String componentName, String path) {
        class DebeziumOracleEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumOracleEndpointBuilder, AdvancedDebeziumOracleEndpointBuilder {
            public DebeziumOracleEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumOracleEndpointBuilderImpl(path);
    }
}