/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingComponent;

/**
 * Provide access to TensorFlow Serving model servers to run inference with
 * TensorFlow saved models remotely
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface TensorflowServingComponentBuilderFactory {

    /**
     * TensorFlow Serving (camel-tensorflow-serving)
     * Provide access to TensorFlow Serving model servers to run inference with
     * TensorFlow saved models remotely
     * 
     * Category: ai
     * Since: 4.10
     * Maven coordinates: org.apache.camel:camel-tensorflow-serving
     * 
     * @return the dsl builder
     */
    static TensorflowServingComponentBuilder tensorflowServing() {
        return new TensorflowServingComponentBuilderImpl();
    }

    /**
     * Builder for the TensorFlow Serving component.
     */
    interface TensorflowServingComponentBuilder extends ComponentBuilder<TensorFlowServingComponent> {
    
        /**
         * The configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder configuration(org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Required servable name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param modelName the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder modelName(java.lang.String modelName) {
            doSetProperty("modelName", modelName);
            return this;
        }
    
        /**
         * Optional choice of which version of the model to use. Use this
         * specific version number.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder modelVersion(java.lang.Long modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
    
        /**
         * Optional choice of which version of the model to use. Use the version
         * associated with the given label.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param modelVersionLabel the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder modelVersionLabel(java.lang.String modelVersionLabel) {
            doSetProperty("modelVersionLabel", modelVersionLabel);
            return this;
        }
    
        /**
         * A named signature to evaluate. If unspecified, the default signature
         * will be used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signatureName the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder signatureName(java.lang.String signatureName) {
            doSetProperty("signatureName", signatureName);
            return this;
        }
    
        
        /**
         * The target URI of the client. See:
         * https://grpc.github.io/grpc-java/javadoc/io/grpc/Grpc.html#newChannelBuilder%28java.lang.String,io.grpc.ChannelCredentials%29.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:8500
         * Group: common
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder target(java.lang.String target) {
            doSetProperty("target", target);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * The credentials of the client.
         * 
         * The option is a: &lt;code&gt;io.grpc.ChannelCredentials&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default TensorflowServingComponentBuilder credentials(io.grpc.ChannelCredentials credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    class TensorflowServingComponentBuilderImpl
            extends AbstractComponentBuilder<TensorFlowServingComponent>
            implements TensorflowServingComponentBuilder {
        @Override
        protected TensorFlowServingComponent buildConcreteComponent() {
            return new TensorFlowServingComponent();
        }
        private org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration getOrCreateConfiguration(TensorFlowServingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((TensorFlowServingComponent) component).setConfiguration((org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration) value); return true;
            case "modelName": getOrCreateConfiguration((TensorFlowServingComponent) component).setModelName((java.lang.String) value); return true;
            case "modelVersion": getOrCreateConfiguration((TensorFlowServingComponent) component).setModelVersion((java.lang.Long) value); return true;
            case "modelVersionLabel": getOrCreateConfiguration((TensorFlowServingComponent) component).setModelVersionLabel((java.lang.String) value); return true;
            case "signatureName": getOrCreateConfiguration((TensorFlowServingComponent) component).setSignatureName((java.lang.String) value); return true;
            case "target": getOrCreateConfiguration((TensorFlowServingComponent) component).setTarget((java.lang.String) value); return true;
            case "lazyStartProducer": ((TensorFlowServingComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((TensorFlowServingComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "credentials": getOrCreateConfiguration((TensorFlowServingComponent) component).setCredentials((io.grpc.ChannelCredentials) value); return true;
            default: return false;
            }
        }
    }
}