
(* (c) Microsoft Corporation. All rights reserved *)
(*F# 
module Microsoft.FSharp.Compiler.Pickle 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.FSharp.Compiler 
module Il = Microsoft.Research.AbstractIL.IL 
module Ccuthunk = Microsoft.FSharp.Compiler.CcuThunk 
F#*)

type outstate 
type instate 

type 'a pickler = 'a -> outstate -> unit
type 'a unpickler = instate -> 'a

val p_byte : int -> outstate -> unit
val u_byte : instate -> int
val p_bool : bool -> outstate -> unit
val u_bool : instate -> bool
val p_void : outstate -> unit
val u_void : instate -> unit
val p_unit : unit -> outstate -> unit
val u_unit : instate -> unit
val p_int32 : int32 -> outstate -> unit
val u_int32 : instate -> int32
val p_bytes : Bytes.bytes pickler
val u_bytes : instate -> Bytes.bytes
val p_int : int -> outstate -> unit
val u_int : instate -> int
val p_int8 : Nums.i8  -> outstate -> unit
val u_int8 : instate -> Nums.i8
val p_uint8 : Nums.u8  -> outstate -> unit
val u_uint8 : instate -> Nums.u8
val p_int16 : Nums.i16  -> outstate -> unit
val u_int16 : instate -> Nums.i16
val p_uint16 : Nums.u16  -> outstate -> unit
val u_uint16 : instate -> Nums.u16
val p_uint32 : Nums.u32  -> outstate -> unit
val u_uint32 : instate -> Nums.u32
val p_int64 : int64  -> outstate -> unit
val u_int64 : instate -> int64
val p_uint64 : Nums.u64  -> outstate -> unit
val u_uint64 : instate -> Nums.u64
val p_single: Nums.ieee32  -> outstate -> unit
val u_single: instate -> Nums.ieee32
val p_float64 : float  -> outstate -> unit
val u_float64 : instate -> float
val p_ieee64 : Nums.ieee64  -> outstate -> unit
val u_ieee64 : instate -> Nums.ieee64
val p_char : Nums.unichar  -> outstate -> unit
val u_char : instate -> Nums.unichar

val (*F# inline F#*)  p_tup2 : ('a pickler) -> ('b pickler) -> ('a * 'b) pickler
val (*F# inline F#*)   p_tup3 : ('a pickler) -> ('b pickler) -> ('c pickler) -> ('a * 'b * 'c) pickler
val (*F# inline F#*)   p_tup4 : ('a pickler) -> ('b pickler) -> ('c pickler) -> ('d pickler) -> ('a * 'b * 'c * 'd) pickler
val (*F# inline F#*)  p_tup5 : ('a pickler) -> ('b pickler) -> ('c pickler) -> ('d pickler) -> ('e pickler) -> ('a * 'b * 'c * 'd * 'e) pickler
val (*F# inline F#*)  u_tup2 : ('b unpickler) -> ('c unpickler ) -> ('b * 'c) unpickler
val (*F# inline F#*)  u_tup3 : ('b unpickler) -> ('c unpickler ) -> ('d unpickler ) -> ('b * 'c * 'd ) unpickler
val (*F# inline F#*)  u_tup4 : ('b unpickler) -> ('c unpickler ) -> ('d unpickler ) -> ('e unpickler) -> ('b * 'c * 'd * 'e) unpickler
val (*F# inline F#*)  u_tup5 : ('b unpickler) -> ('c unpickler ) -> ('d unpickler ) -> ('e unpickler) -> ('f unpickler) -> ('b * 'c * 'd * 'e * 'f) unpickler
val p_list : ('a pickler) -> 'a list pickler
val u_list : 'a unpickler -> 'a list unpickler
val p_wrap : ('a -> 'b) -> 'b pickler -> 'a pickler
val u_wrap : ('b -> 'a) -> 'b unpickler -> 'a unpickler
val p_array : ('a pickler) -> 'a array pickler
val u_array : 'a unpickler -> 'a array unpickler
val p_option : ('a pickler) -> 'a option pickler
val u_option : 'a unpickler -> 'a option unpickler
val p_hole : unit -> ('a pickler -> unit) * 'a pickler
val u_hole : unit -> ('a unpickler -> unit) * 'a unpickler
val p_string : string pickler
val u_string : string unpickler
val p_namemap : ('a pickler) -> 'a Lib.namemap pickler
val u_namemap : ('a unpickler) -> 'a Lib.namemap unpickler

val pickle_obj_with_dangling_ccus : Tast.ccu (* scope *) -> ('a pickler) -> 'a -> Bytes.bytes
val unpickle_obj_with_dangling_ccus : Il.scope_ref (* viewed scope *) -> ('a  unpickler) -> Bytes.bytes -> ('a,Tast.ccu_spec) Ccuthunk.pickled_data_with_dangling_references

val p_const : Tast.tconst pickler
val u_const : Tast.tconst unpickler
val p_vref : string -> Tast.val_ref pickler
val u_vref : Tast.val_ref unpickler
val p_tcref : string -> Tast.tycon_ref pickler
val u_tcref : Tast.tycon_ref unpickler
val p_ucref : Tast.unionconstr_ref pickler
val u_ucref : Tast.unionconstr_ref unpickler
val p_expr : Tast.expr pickler
val u_expr : Tast.expr unpickler
val p_typ : Tast.typ pickler
val u_typ : Tast.typ unpickler

val pickle_modul_spec : Tast.modul_spec pickler
val unpickle_modul_spec : instate -> Tast.modul_spec
