(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.
 * 
 * Parsing: support fsyacc-generated parsers
 *=========================================================================*)

module Microsoft.FSharp.Compatibility.OCaml.Parsing
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives
open Microsoft.FSharp.Tools.FsYacc

open Lexing

let err _  = failwith "You must generate your parser using the '--ml-compatibility' option or call 'Parsing.set_parse_state parseState' in each action before using functions from the Parsing module.  This is because the module uses global state which must be set up for use in each parsing action. Review the notes in the 'Parsing' module if you are using parsers on multiple threads."
let dummyProvider = 
    { new IParseState<position> with 
        member x.StartOfRHS(i) = err();
        member x.EndOfRHS(i) = err();
        member x.StartOfLHS = err();
        member x.EndOfLHS = err();
        member x.GetData(i) = err();
        member x.RaiseError<'b>() = (err(): 'b)  }

let parse_information = ref dummyProvider
let set_parse_state x = parse_information := x
let get_parse_information () = !parse_information

let dummy_pos = {pos_fname="?"; pos_lnum= 1; pos_bol= 1; pos_cnum=0 }
let enforce_nonnull_pos p = 
  match (box p) with 
  | null -> dummy_pos
  | _ -> p

let symbol_start_pos ()   = (get_parse_information()).StartOfLHS    |> enforce_nonnull_pos
let symbol_end_pos ()     = (get_parse_information()).EndOfLHS      |> enforce_nonnull_pos
let rhs_start_pos (n:int) = (get_parse_information()).StartOfRHS(n) |> enforce_nonnull_pos
let rhs_end_pos (n:int)   = (get_parse_information()).EndOfRHS(n)   |> enforce_nonnull_pos
 
exception Parse_error  = Microsoft.FSharp.Tools.FsYacc.RecoverableParseError
let parse_error s = (get_parse_information()).RaiseError()(failwith s : unit)

let symbol_start () = (symbol_start_pos()).pos_cnum
let symbol_end () = (symbol_end_pos()).pos_cnum
let rhs_start n = (rhs_start_pos n).pos_cnum
let rhs_end n = (rhs_end_pos n).pos_cnum

