(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.  
 *
 *=========================================================================*)

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Func = 
    let apply f x = f x
    let rec repeatN n f x = if n <= 0 then x else repeatN (n-1) f (f x)
    let rec repeatUntil f = if f () then () else repeatUntil f
    let rec foldUntil f x = match f x with None -> x | Some y -> foldUntil f y
    let compose f g = (f >> g)    
