//--------------------------------------------------------------------
// This file is written in F# and defines the implementation of
// a software component which publishes some simple types and 
// functions.  See FSharpLibrary.fsi for more details.  
//
// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//--------------------------------------------------------------------

#light

let rec PrintIntegers n = 
   if n <= 0 then () 
   else 
       print_endline (string_of_int n);
       PrintIntegers (n-1)

type MyData = 
    | A of string 
    | B of int * MyData

let rec MyDataPrint d = 
    match d with 
    | A s -> Printf.printf "%s: waterloo!\n" s
    | B (n,d) -> Printf.printf "%d\n" n; MyDataPrint d

let rec MyDataMap f d = 
    match d with 
    | A x -> A x
    | B (n,d) -> B (f n,MyDataMap f d)



