// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math

    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core

    /// The type of arbitrary-sized integers
    [<Struct>]
    type BigInt =
        static member ( + )      : BigInt * BigInt -> BigInt
        static member ( % )      : BigInt * BigInt -> BigInt
        static member ( * )      : BigInt * BigInt -> BigInt
        static member ( - )      : BigInt * BigInt -> BigInt
        static member ( / )      : BigInt * BigInt -> BigInt
        static member (~-)       : BigInt -> BigInt
        static member (~+)       : BigInt -> BigInt
        static member (..)       : BigInt * BigInt -> seq<BigInt>
        static member (.. ..)    : BigInt * BigInt * BigInt -> seq<BigInt>
        static member ToDouble   : BigInt -> float
        static member FromInt32  : int32 -> BigInt
        static member FromInt64  : int64 -> BigInt
        static member ToInt64    : BigInt -> int64
        static member ToInt32    : BigInt -> int32
        static member Parse    : string -> BigInt
        member IsNegative : bool
        member IsPositive : bool
        member IsZero : bool
        member IsOne : bool
        interface System.IComparable
        interface IStructuralHash
        override Equals : obj -> bool
        override GetHashCode : unit -> int


namespace Microsoft.FSharp.Core

    type bigint = Microsoft.FSharp.Math.BigInt

namespace Microsoft.FSharp.Math

    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Math

    [<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
    module BigInt =

        val of_int      : int -> bigint 
        val to_int      : bigint -> int 

        val of_int64    : int64 -> bigint 
        val to_int64    : bigint -> int64 

        val one         : bigint
        val zero        : bigint

        val neg         :          bigint -> bigint
        val scale       : int   -> bigint -> bigint  

        val add         : bigint -> bigint -> bigint 
        val sub         : bigint -> bigint -> bigint

        val mul         : bigint -> bigint -> bigint
        val div         : bigint -> bigint -> bigint
        val rem         : bigint -> bigint -> bigint     
        val hcf         : bigint -> bigint -> bigint
        val divmod      : bigint -> bigint -> bigint * bigint   

        val min         : bigint -> bigint -> bigint
        val max         : bigint -> bigint -> bigint
        
        val abs         : bigint -> bigint
        val negative    : bigint -> bool 
        val positive    : bigint -> bool 
        val isZero      : bigint -> bool
        val isOne       : bigint -> bool

        val sign        : bigint -> int

        val equal       : bigint -> bigint -> bool 
        val lt          : bigint -> bigint -> bool 
        val gt          : bigint -> bigint -> bool 
        val lte         : bigint -> bigint -> bool 
        val gte         : bigint -> bigint -> bool
        val compare     : bigint -> bigint -> int

        val powi        : bigint -> int -> bigint
        val pow         : bigint -> bigint   -> bigint  
        val factorial   : bigint -> bigint

        val hash        : bigint -> int

        val to_float    : bigint -> float

        val to_string : bigint -> string
        val of_string : string -> bigint

        val bits         : bigint -> int

namespace Microsoft.FSharp.Math.Types

    type BigInt = Microsoft.FSharp.Math.BigInt
