package javax.persistence;

/**
 * The ResultItem interface defines an item that is returned by a query.
 * @param <X> the type of the result item
 */
public interface ResultItem<X> 
{
    /**
     * Return the Java type of the result item.
     * @return the Java type of the result item
     */
    Class<X> getJavaType();

    /**
     * Return the alias assigned to the item or null, if no alias has been assigned.
     * @return alias
     */
    String getAlias();
}