package com.google.appengine.api.capabilities;

/**
 * Represents the status of a {@link Capability}.
 *
 *
 */

public enum CapabilityStatus {
  /**
   * The capability is available and no maintenance is currently planned.
   */
  ENABLED,
  /**
   * The capability is available but scheduled for maintenance.
   */
  SCHEDULED_MAINTENANCE,
  /**
   * The capability is disabled. API calls which depend on this capability will
   * fail.
   */
  DISABLED,

  /**
   * The status of the capability is unknown.
   */
  UNKNOWN;

}
