/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;

@GwtCompatible
public interface S2Shape {
    public int numEdges();

    public void getEdge(int var1, MutableEdge var2);

    public boolean hasInterior();

    public boolean containsOrigin();

    public int numChains();

    public int getChainStart(int var1);

    public int getChainLength(int var1);

    public void getChainEdge(int var1, int var2, MutableEdge var3);

    public S2Point getChainVertex(int var1, int var2);

    public int dimension();

    default public ReferencePoint getReferencePoint() {
        Preconditions.checkState((this.dimension() == 2 ? 1 : 0) != 0);
        return ReferencePoint.create(S2.origin(), this.containsOrigin());
    }

    public static abstract class ReferencePoint
    extends S2Point {
        private static final ReferencePoint ORIGIN_INSIDE = ReferencePoint.create(S2.origin(), true);
        private static final ReferencePoint ORIGIN_OUTSIDE = ReferencePoint.create(S2.origin(), false);

        private ReferencePoint(S2Point p) {
            super(p.x, p.y, p.z);
        }

        public abstract boolean contained();

        public static ReferencePoint create(boolean contained) {
            return contained ? ORIGIN_INSIDE : ORIGIN_OUTSIDE;
        }

        public static ReferencePoint create(S2Point p, boolean contained) {
            if (contained) {
                return new ReferencePoint(p){

                    @Override
                    public boolean contained() {
                        return true;
                    }
                };
            }
            return new ReferencePoint(p){

                @Override
                public boolean contained() {
                    return false;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ReferencePoint && super.equals(o) && this.contained() == ((ReferencePoint)o).contained();
        }
    }

    public static final class MutableEdge {
        S2Point a;
        S2Point b;

        public S2Point getStart() {
            return this.a;
        }

        public S2Point getEnd() {
            return this.b;
        }

        public boolean isEndpoint(S2Point point) {
            return this.a.equalsPoint(point) || this.b.equalsPoint(point);
        }

        public void set(S2Point start, S2Point end) {
            this.a = start;
            this.b = end;
        }
    }
}

