/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;

public class Client {
    private static final Client INTANCE = new Client();
    private final HttpTransport transport = EnvUtil.isRunningOnAppEngineProd() ? new UrlFetchTransport() : new NetHttpTransport();
    private final JsonFactory jsonFactory = new JacksonFactory();
    private final HttpRequestFactory jsonHttpRequestFactory = this.transport.createRequestFactory(new HttpRequestInitializer(){

        @Override
        public void initialize(HttpRequest request) {
            request.setParser(new JsonObjectParser(Client.this.jsonFactory));
        }
    });

    @VisibleForTesting
    Client() {
    }

    public static Client getInstance() {
        return INTANCE;
    }

    public HttpTransport getHttpTransport() {
        return this.transport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public HttpRequestFactory getJsonHttpRequestFactory() {
        return this.jsonHttpRequestFactory;
    }
}

