/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.store.AbstractAutoStartMechanism;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.XMLAutoStarterEntityResolver;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLAutoStarter
extends AbstractAutoStartMechanism {
    protected final URL fileUrl;
    protected Document doc;
    protected Element rootElement;

    public XMLAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) throws MalformedURLException {
        this.fileUrl = new URL("file:" + storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.autoStartMechanismXmlFile"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            try {
                db.setEntityResolver(new XMLAutoStarterEntityResolver());
                this.rootElement = db.parse(new InputSource(new InputStreamReader(this.fileUrl.openStream()))).getDocumentElement();
                this.doc = this.rootElement.getOwnerDocument();
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.info(LOCALISER.msg("034201", (Object)this.fileUrl.getFile()));
                this.doc = db.newDocument();
                this.rootElement = this.doc.createElement("datanucleus_autostart");
                this.doc.appendChild(this.rootElement);
                this.writeToFile();
            }
        }
        catch (ParserConfigurationException e1) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("034202", (Object)this.fileUrl.getFile(), (Object)e1.getMessage()));
        }
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        HashSet<StoreData> classes = new HashSet<StoreData>();
        NodeList classElements = this.rootElement.getElementsByTagName("class");
        for (int i = 0; i < classElements.getLength(); ++i) {
            Element element = (Element)classElements.item(i);
            StoreData data = new StoreData(element.getAttribute("name"), element.getAttribute("type").equals("FCO") ? 1 : 2);
            NamedNodeMap attributeMap = element.getAttributes();
            for (int j = 0; j < attributeMap.getLength(); ++j) {
                Node attr = attributeMap.item(j);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                if (attrName.equals("name") || attrName.equals("type")) continue;
                data.addProperty(attrName, attrValue);
            }
            classes.add(data);
        }
        return classes;
    }

    public boolean isOpen() {
        return true;
    }

    public void close() {
        this.writeToFile();
        super.close();
    }

    public void addClass(StoreData data) {
        Element classElement = this.doc.createElement("class");
        classElement.setAttribute("name", data.getName());
        classElement.setAttribute("type", data.isFCO() ? "FCO" : "SCO");
        classElement.setAttribute("version", ObjectManagerFactoryImpl.getVersionNumber());
        Map dataProps = data.getProperties();
        for (Map.Entry entry : dataProps.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (!(val instanceof String)) continue;
            classElement.setAttribute(key, (String)val);
        }
        this.rootElement.appendChild(classElement);
    }

    public void deleteClass(String className) {
        NodeList classElements = this.rootElement.getElementsByTagName("class");
        for (int i = 0; i < classElements.getLength(); ++i) {
            Element element = (Element)classElements.item(i);
            String attr = element.getAttribute("name");
            if (attr == null || !attr.equals(className)) continue;
            this.rootElement.removeChild(element);
        }
    }

    public void deleteAllClasses() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            this.doc = db.newDocument();
            this.rootElement = this.doc.createElement("datanucleus_autostart");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("034203", (Object)this.fileUrl.getFile(), (Object)e.getMessage()));
        }
    }

    public String getStorageDescription() {
        return LOCALISER.msg("034200");
    }

    private synchronized void writeToFile() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer m = tf.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            FileOutputStream os = new FileOutputStream(this.fileUrl.getFile());
            StreamResult result = new StreamResult(os);
            m.setOutputProperty("indent", "yes");
            m.setOutputProperty("doctype-public", "-//DataNucleus//DTD DataNucleus AutoStarter Metadata 1.0//EN");
            m.transform(source, result);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("034203", (Object)this.fileUrl.getFile(), (Object)e.getMessage()));
        }
    }
}

