/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import javax.jdo.JDOException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.query.QueryTimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueryExceptionWrappers {
    private QueryExceptionWrappers() {
    }

    static <T> Utils.Supplier<T> datastoreToDataNucleus(final Utils.Supplier<T> supplier) {
        return new Utils.Supplier<T>(){

            @Override
            public T get() {
                try {
                    return supplier.get();
                }
                catch (IllegalArgumentException e) {
                    throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
                }
                catch (DatastoreTimeoutException e) {
                    throw DatastoreExceptionTranslator.wrapDatastoreTimeoutExceptionForQuery(e);
                }
                catch (DatastoreFailureException e) {
                    throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
                }
            }
        };
    }

    static <T> Utils.Supplier<T> dataNucleusToJDO(final Utils.Supplier<T> supplier) {
        return new Utils.Supplier<T>(){

            @Override
            public T get() {
                try {
                    return supplier.get();
                }
                catch (QueryTimeoutException qte) {
                    throw new JDOQueryTimeoutException(qte);
                }
                catch (NucleusException ne) {
                    throw NucleusJDOHelper.getJDOExceptionForNucleusException((NucleusException)ne);
                }
            }
        };
    }

    static <T> Utils.Supplier<T> dataNucleusToJPA(final Utils.Supplier<T> supplier) {
        return new Utils.Supplier<T>(){

            @Override
            public T get() {
                try {
                    return supplier.get();
                }
                catch (QueryTimeoutException qte) {
                    javax.persistence.QueryTimeoutException rte = new javax.persistence.QueryTimeoutException();
                    rte.initCause(qte);
                    throw rte;
                }
                catch (NucleusException ne) {
                    throw NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)ne);
                }
                catch (JDOException je) {
                    throw NucleusJPAHelper.getJPAExceptionForJDOException((JDOException)je);
                }
            }
        };
    }

    static final class JDOQueryTimeoutException
    extends javax.jdo.JDOQueryTimeoutException {
        private final Throwable cause;

        JDOQueryTimeoutException(Throwable cause) {
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

