/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.digester.plugins;

import com.google.appengine.repackaged.org.apache.commons.digester.Digester;
import com.google.appengine.repackaged.org.apache.commons.digester.Rule;
import com.google.appengine.repackaged.org.apache.commons.digester.plugins.Declaration;
import com.google.appengine.repackaged.org.apache.commons.digester.plugins.PluginException;
import com.google.appengine.repackaged.org.apache.commons.digester.plugins.PluginInvalidInputException;
import com.google.appengine.repackaged.org.apache.commons.digester.plugins.PluginManager;
import com.google.appengine.repackaged.org.apache.commons.digester.plugins.PluginRules;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PluginDeclarationRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        int nAttrs = attributes.getLength();
        Properties props = new Properties();
        int i = 0;
        while (i < nAttrs) {
            String key = attributes.getLocalName(i);
            if (key == null || key.length() == 0) {
                key = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            props.setProperty(key, value);
            ++i;
        }
        try {
            PluginDeclarationRule.declarePlugin(this.digester, props);
        }
        catch (PluginInvalidInputException ex) {
            throw new PluginInvalidInputException("Error on element [" + this.digester.getMatch() + "]: " + ex.getMessage());
        }
    }

    public static void declarePlugin(Digester digester, Properties props) throws PluginException {
        String id = props.getProperty("id");
        String pluginClassName = props.getProperty("class");
        if (id == null) {
            throw new PluginInvalidInputException("mandatory attribute id not present on plugin declaration");
        }
        if (pluginClassName == null) {
            throw new PluginInvalidInputException("mandatory attribute class not present on plugin declaration");
        }
        Declaration newDecl = new Declaration(pluginClassName);
        newDecl.setId(id);
        newDecl.setProperties(props);
        PluginRules rc = (PluginRules)digester.getRules();
        PluginManager pm = rc.getPluginManager();
        newDecl.init(digester, pm);
        pm.addDeclaration(newDecl);
    }
}

