/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.NoDatastoreMappingException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOUtils;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        if (mmd.getContainer() == null) {
            throw new NucleusUserException(LOCALISER.msg("041023", (Object)mmd.getFullFieldName()));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.storeMgr.newJoinDatastoreContainerObject(mmd, clr);
        }
    }

    public boolean hasSimpleDatastoreRepresentation() {
        return false;
    }

    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            super.prepareDatastoreMapping();
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        if (this.mmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("setObject")).setFatal();
        }
        ObjectProvider[] sms = null;
        ApiAdapter api = ec.getApiAdapter();
        if (value != null) {
            HashSet<ObjectProvider> smsColl = null;
            if (value instanceof Collection) {
                for (Object elem : (Collection)value) {
                    ObjectProvider sm;
                    if (!api.isPersistable(elem) || (sm = ec.findObjectProvider(elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<ObjectProvider>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    ObjectProvider sm;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (api.isPersistable(key) && (sm = ec.findObjectProvider(key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!api.isPersistable(val) || (sm = ec.findObjectProvider(val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new ObjectProvider[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (this.mmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("getObject")).setFatal();
        }
        return this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    public DatastoreContainerObject getDatastoreContainer() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.datastoreContainer;
        }
        return null;
    }

    public int getNumberOfDatastoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreMappings();
        }
        return 0;
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDatastoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.mmd.getName());
    }

    public DatastoreMapping[] getDatastoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDatastoreMappings();
        }
        throw new NoDatastoreMappingException(this.mmd.getName());
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (this.mmd != null && this.mmd.isSerialized()) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasCollection() && SCOUtils.collectionHasSerialisedElements(this.mmd)) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasMap() && SCOUtils.mapHasSerialisedKeysAndValues(this.mmd)) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasArray() && SCOUtils.arrayIsStoredInSingleColumn(this.mmd, this.storeMgr.getMetaDataManager())) {
            return !MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
        }
        return false;
    }

    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    protected SCO replaceFieldWithWrapper(ObjectProvider ownerSM, Object value, boolean forInsert, boolean forUpdate) {
        Class<List> type = this.mmd.getType();
        if (value != null) {
            type = value.getClass();
        } else if (this.mmd.getOrderMetaData() != null && type.isAssignableFrom(List.class)) {
            type = List.class;
        }
        SCO sco = SCOUtils.newSCOInstance(ownerSM, this.mmd, this.mmd.getType(), type, value, forInsert, forUpdate, true);
        return sco;
    }

    public void postFetch(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        this.replaceFieldWithWrapper(sm, null, false, false);
    }
}

