/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeployStageExecutionStep
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="state")
    private final State state;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;

    @Deprecated
    @ConstructorProperties(value={"name", "state", "timeStarted", "timeFinished"})
    public DeployStageExecutionStep(String name, State state, Date timeStarted, Date timeFinished) {
        this.name = name;
        this.state = state;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployStageExecutionStep(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployStageExecutionStep)) {
            return false;
        }
        DeployStageExecutionStep other = (DeployStageExecutionStep)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum State implements BmcEnum
    {
        Waiting("WAITING"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'State', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(State.class);
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="state")
        private State state;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public DeployStageExecutionStep build() {
            DeployStageExecutionStep model = new DeployStageExecutionStep(this.name, this.state, this.timeStarted, this.timeFinished);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeployStageExecutionStep model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            return this;
        }
    }
}

